/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.mms.transaction.MessagingNotification;

public class MessageStatusReceiver
extends BroadcastReceiver {
    public static final String MESSAGE_STATUS_RECEIVED_ACTION = "com.android.mms.transaction.MessageStatusReceiver.MESSAGE_STATUS_RECEIVED";
    private static final String[] ID_PROJECTION = new String[]{"_id"};
    private static final String LOG_TAG = "MessageStatusReceiver";
    private static final Uri STATUS_URI = Uri.parse((String)"content://sms/status");
    private Context mContext;

    public void onReceive(Context context, Intent intent) {
        byte[] pdu;
        Uri messageUri;
        SmsMessage message;
        this.mContext = context;
        if (MESSAGE_STATUS_RECEIVED_ACTION.equals(intent.getAction()) && (message = this.updateMessageStatus(context, messageUri = intent.getData(), pdu = (byte[])intent.getExtra("pdu"))).getStatus() < 32) {
            MessagingNotification.nonBlockingUpdateNewMessageIndicator(context, true, message.isStatusReportMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmsMessage updateMessageStatus(Context context, Uri messageUri, byte[] pdu) {
        Cursor cursor = SqliteWrapper.query((Context)context, (ContentResolver)context.getContentResolver(), (Uri)messageUri, (String[])ID_PROJECTION, null, null, null);
        SmsMessage message = SmsMessage.createFromPdu((byte[])pdu);
        try {
            if (cursor.moveToFirst()) {
                int messageId = cursor.getInt(0);
                Uri updateUri = ContentUris.withAppendedId((Uri)STATUS_URI, (long)messageId);
                int status = message.getStatus();
                boolean isStatusReport = message.isStatusReportMessage();
                ContentValues contentValues = new ContentValues(1);
                if (Log.isLoggable((String)"Mms", (int)3)) {
                    this.log("updateMessageStatus: msgUrl=" + messageUri + ", status=" + status + ", isStatusReport=" + isStatusReport);
                }
                contentValues.put("status", Integer.valueOf(status));
                SqliteWrapper.update((Context)context, (ContentResolver)context.getContentResolver(), (Uri)updateUri, (ContentValues)contentValues, null, null);
            } else {
                this.error("Can't find message for status update: " + messageUri);
            }
        }
        finally {
            cursor.close();
        }
        return message;
    }

    private void error(String message) {
        Log.e((String)LOG_TAG, (String)("[MessageStatusReceiver] " + message));
    }

    private void log(String message) {
        Log.d((String)LOG_TAG, (String)("[MessageStatusReceiver] " + message));
    }
}

