/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.Context;
import android.net.http.AndroidHttpClient;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.mms.MmsConfig;
import com.android.mms.transaction.ProgressCallbackEntity;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpUtils {
    private static final String TAG = "Mms:transaction";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    public static final int HTTP_POST_METHOD = 1;
    public static final int HTTP_GET_METHOD = 2;
    private static final String HDR_VALUE_ACCEPT_LANGUAGE = HttpUtils.getHttpAcceptLanguage();
    private static final String HDR_KEY_ACCEPT = "Accept";
    private static final String HDR_KEY_ACCEPT_LANGUAGE = "Accept-Language";
    private static final String HDR_VALUE_ACCEPT = "*/*, application/vnd.wap.mms-message, application/vnd.wap.sic";

    private HttpUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] httpConnection(Context context, long token, String url, byte[] pdu, int method, boolean isProxySet, String proxyHost, int proxyPort) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null.");
        }
        AndroidHttpClient client = null;
        try {
            byte[] body;
            block39: {
                String extraHttpParams;
                URI hostUrl = new URI(url);
                HttpHost target = new HttpHost(hostUrl.getHost(), hostUrl.getPort(), "http");
                client = HttpUtils.createHttpClient(context);
                HttpGet req = null;
                switch (method) {
                    case 1: {
                        ProgressCallbackEntity entity = new ProgressCallbackEntity(context, token, pdu);
                        entity.setContentType("application/vnd.wap.mms-message");
                        HttpPost post = new HttpPost(url);
                        post.setEntity((HttpEntity)entity);
                        req = post;
                        break;
                    }
                    case 2: {
                        req = new HttpGet(url);
                        break;
                    }
                    default: {
                        Log.e((String)TAG, (String)("Unknown HTTP method: " + method + ". Must be one of POST[" + 1 + "] or GET[" + 2 + "]."));
                        byte[] byArray = null;
                        return byArray;
                    }
                }
                HttpParams params = client.getParams();
                if (isProxySet) {
                    ConnRouteParams.setDefaultProxy((HttpParams)params, (HttpHost)new HttpHost(proxyHost, proxyPort));
                }
                req.setParams(params);
                req.addHeader(HDR_KEY_ACCEPT, HDR_VALUE_ACCEPT);
                String xWapProfileTagName = MmsConfig.getUaProfTagName();
                String xWapProfileUrl = MmsConfig.getUaProfUrl();
                if (xWapProfileUrl != null) {
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        Log.d((String)TAG, (String)("[HttpUtils] httpConn: xWapProfUrl=" + xWapProfileUrl));
                    }
                    req.addHeader(xWapProfileTagName, xWapProfileUrl);
                }
                if ((extraHttpParams = MmsConfig.getHttpParams()) != null) {
                    String[] paramList;
                    String line1Number = ((TelephonyManager)context.getSystemService("phone")).getLine1Number();
                    String line1Key = MmsConfig.getHttpParamsLine1Key();
                    for (String paramPair : paramList = extraHttpParams.split("\\|")) {
                        String[] splitPair = paramPair.split(":", 2);
                        if (splitPair.length != 2) continue;
                        String name = splitPair[0].trim();
                        String value = splitPair[1].trim();
                        if (line1Key != null) {
                            value = value.replace(line1Key, line1Number);
                        }
                        if (TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)value)) continue;
                        req.addHeader(name, value);
                    }
                }
                req.addHeader(HDR_KEY_ACCEPT_LANGUAGE, HDR_VALUE_ACCEPT_LANGUAGE);
                HttpResponse response = client.execute(target, (HttpRequest)req);
                StatusLine status = response.getStatusLine();
                if (status.getStatusCode() != 200) {
                    throw new IOException("HTTP error: " + status.getReasonPhrase());
                }
                HttpEntity entity = response.getEntity();
                body = null;
                if (entity != null) {
                    try {
                        if (entity.getContentLength() <= 0L) break block39;
                        body = new byte[(int)entity.getContentLength()];
                        DataInputStream dis = new DataInputStream(entity.getContent());
                        try {
                            dis.readFully(body);
                        }
                        finally {
                            try {
                                dis.close();
                            }
                            catch (IOException e) {
                                Log.e((String)TAG, (String)("Error closing input stream: " + e.getMessage()));
                            }
                        }
                    }
                    finally {
                        if (entity != null) {
                            entity.consumeContent();
                        }
                    }
                }
            }
            byte[] byArray = body;
            return byArray;
        }
        catch (URISyntaxException e) {
            HttpUtils.handleHttpConnectionException(e, url);
        }
        catch (IllegalStateException e) {
            HttpUtils.handleHttpConnectionException(e, url);
        }
        catch (IllegalArgumentException e) {
            HttpUtils.handleHttpConnectionException(e, url);
        }
        catch (SocketException e) {
            HttpUtils.handleHttpConnectionException(e, url);
        }
        catch (Exception e) {
            HttpUtils.handleHttpConnectionException(e, url);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        return null;
    }

    private static void handleHttpConnectionException(Exception exception, String url) throws IOException {
        Log.e((String)TAG, (String)("Url: " + url + "\n" + exception.getMessage()));
        IOException e = new IOException(exception.getMessage());
        e.initCause(exception);
        throw e;
    }

    private static AndroidHttpClient createHttpClient(Context context) {
        String userAgent = MmsConfig.getUserAgent();
        AndroidHttpClient client = AndroidHttpClient.newInstance((String)userAgent, (Context)context);
        HttpParams params = client.getParams();
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        int soTimeout = MmsConfig.getHttpSocketTimeout();
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("[HttpUtils] createHttpClient w/ socket timeout " + soTimeout + " ms, " + ", UA=" + userAgent));
        }
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)soTimeout);
        return client;
    }

    private static String getHttpAcceptLanguage() {
        Locale locale = Locale.getDefault();
        StringBuilder builder = new StringBuilder();
        HttpUtils.addLocaleToHttpAcceptLanguage(builder, locale);
        if (!locale.equals(Locale.US)) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            HttpUtils.addLocaleToHttpAcceptLanguage(builder, Locale.US);
        }
        return builder.toString();
    }

    private static void addLocaleToHttpAcceptLanguage(StringBuilder builder, Locale locale) {
        String language = locale.getLanguage();
        if (language != null) {
            builder.append(language);
            String country = locale.getCountry();
            if (country != null) {
                builder.append("-");
                builder.append(country);
            }
        }
    }
}

