/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.model;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.android.mms.ContentRestrictionException;
import com.android.mms.dom.events.EventImpl;
import com.android.mms.drm.DrmWrapper;
import com.android.mms.model.ContentRestriction;
import com.android.mms.model.ContentRestrictionFactory;
import com.android.mms.model.MediaModel;
import com.android.mms.model.RegionMediaModel;
import com.android.mms.model.RegionModel;
import com.google.android.mms.MmsException;
import java.io.IOException;
import org.w3c.dom.events.Event;

public class VideoModel
extends RegionMediaModel {
    private static final String TAG = "Mms/media";
    private static final boolean DEBUG = true;
    private static final boolean LOCAL_LOGV = true;

    public VideoModel(Context context, Uri uri, RegionModel region) throws MmsException {
        this(context, null, null, uri, region);
        this.initModelFromUri(uri);
        this.checkContentRestriction();
    }

    public VideoModel(Context context, String contentType, String src, Uri uri, RegionModel region) throws MmsException {
        super(context, "video", contentType, src, uri, region);
    }

    public VideoModel(Context context, String contentType, String src, DrmWrapper wrapper, RegionModel regionModel) throws IOException {
        super(context, "video", contentType, src, wrapper, regionModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initModelFromUri(Uri uri) throws MmsException {
        ContentResolver cr = this.mContext.getContentResolver();
        Cursor c = SqliteWrapper.query((Context)this.mContext, (ContentResolver)cr, (Uri)uri, null, null, null, null);
        if (c == null) throw new MmsException("Bad URI: " + uri);
        try {
            int index;
            if (!c.moveToFirst()) throw new MmsException("Nothing found: " + uri);
            String path = c.getString(c.getColumnIndexOrThrow("_data"));
            this.mSrc = path.substring(path.lastIndexOf(47) + 1);
            this.mContentType = c.getString(c.getColumnIndexOrThrow("mime_type"));
            if (TextUtils.isEmpty((CharSequence)this.mContentType)) {
                throw new MmsException("Type of media is unknown.");
            }
            if (this.mContentType.equals("video/mp4") && !TextUtils.isEmpty((CharSequence)this.mSrc) && (index = this.mSrc.lastIndexOf(".")) != -1) {
                try {
                    String extension = this.mSrc.substring(index + 1);
                    if (!TextUtils.isEmpty((CharSequence)extension) && (extension.equalsIgnoreCase("3gp") || extension.equalsIgnoreCase("3gpp") || extension.equalsIgnoreCase("3g2"))) {
                        this.mContentType = "video/3gpp";
                    }
                }
                catch (IndexOutOfBoundsException ex) {
                    Log.v((String)TAG, (String)"Media extension is unknown.");
                }
            }
            if (Log.isLoggable((String)"Mms:app", (int)2)) {
                Log.v((String)TAG, (String)("New VideoModel created: mSrc=" + this.mSrc + " mContentType=" + this.mContentType + " mUri=" + uri));
            }
        }
        finally {
            c.close();
        }
        this.initMediaDuration();
    }

    public void handleEvent(Event evt) {
        String evtType = evt.getType();
        Log.v((String)TAG, (String)("[VideoModel] handleEvent " + evt.getType() + " on " + this));
        MediaModel.MediaAction action = MediaModel.MediaAction.NO_ACTIVE_ACTION;
        if (evtType.equals("SmilMediaStart")) {
            action = MediaModel.MediaAction.START;
            this.pauseMusicPlayer();
            this.mVisible = true;
        } else if (evtType.equals("SmilMediaEnd")) {
            action = MediaModel.MediaAction.STOP;
            if (this.mFill != 1) {
                this.mVisible = false;
            }
        } else if (evtType.equals("SmilMediaPause")) {
            action = MediaModel.MediaAction.PAUSE;
            this.mVisible = true;
        } else if (evtType.equals("SmilMediaSeek")) {
            action = MediaModel.MediaAction.SEEK;
            this.mSeekTo = ((EventImpl)evt).getSeekTo();
            this.mVisible = true;
        }
        this.appendAction(action);
        this.notifyModelChanged(false);
    }

    protected void checkContentRestriction() throws ContentRestrictionException {
        ContentRestriction cr = ContentRestrictionFactory.getContentRestriction();
        cr.checkVideoContentType(this.mContentType);
    }

    protected boolean isPlayable() {
        return true;
    }
}

