/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.model;

import android.drm.mobile1.DrmException;
import android.text.TextUtils;
import android.util.Log;
import com.android.mms.dom.smil.SmilDocumentImpl;
import com.android.mms.dom.smil.parser.SmilXmlParser;
import com.android.mms.drm.DrmWrapper;
import com.android.mms.model.AudioModel;
import com.android.mms.model.ImageModel;
import com.android.mms.model.LayoutModel;
import com.android.mms.model.MediaModel;
import com.android.mms.model.RegionModel;
import com.android.mms.model.SlideModel;
import com.android.mms.model.SlideshowModel;
import com.android.mms.model.TextModel;
import com.android.mms.model.VideoModel;
import com.google.android.mms.ContentType;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduPart;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.smil.SMILDocument;
import org.w3c.dom.smil.SMILElement;
import org.w3c.dom.smil.SMILLayoutElement;
import org.w3c.dom.smil.SMILMediaElement;
import org.w3c.dom.smil.SMILParElement;
import org.w3c.dom.smil.SMILRegionElement;
import org.w3c.dom.smil.SMILRegionMediaElement;
import org.w3c.dom.smil.SMILRootLayoutElement;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmilHelper {
    private static final String TAG = "Mms/smil";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    public static final String ELEMENT_TAG_TEXT = "text";
    public static final String ELEMENT_TAG_IMAGE = "img";
    public static final String ELEMENT_TAG_AUDIO = "audio";
    public static final String ELEMENT_TAG_VIDEO = "video";
    public static final String ELEMENT_TAG_REF = "ref";

    private SmilHelper() {
    }

    public static SMILDocument getDocument(PduBody pb) {
        PduPart smilPart = SmilHelper.findSmilPart(pb);
        SMILDocument document = null;
        if (smilPart != null) {
            document = SmilHelper.getSmilDocument(smilPart);
        }
        if (document == null) {
            document = SmilHelper.createSmilDocument(pb);
        }
        return document;
    }

    public static SMILDocument getDocument(SlideshowModel model) {
        return SmilHelper.createSmilDocument(model);
    }

    private static PduPart findSmilPart(PduBody body) {
        int partNum = body.getPartsNum();
        for (int i = 0; i < partNum; ++i) {
            PduPart part = body.getPart(i);
            if (!Arrays.equals(part.getContentType(), "application/smil".getBytes())) continue;
            return part;
        }
        return null;
    }

    private static SMILDocument validate(SMILDocument in) {
        return in;
    }

    private static SMILDocument getSmilDocument(PduPart smilPart) {
        try {
            byte[] data = smilPart.getData();
            if (data != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                SMILDocument document = new SmilXmlParser().parse(bais);
                return SmilHelper.validate(document);
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to parse SMIL document.", (Throwable)e);
        }
        catch (SAXException e) {
            Log.e((String)TAG, (String)"Failed to parse SMIL document.", (Throwable)e);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)"Failed to parse SMIL document.", (Throwable)e);
        }
        return null;
    }

    public static SMILParElement addPar(SMILDocument document) {
        SMILParElement par = (SMILParElement)document.createElement("par");
        par.setDur(8.0f);
        document.getBody().appendChild(par);
        return par;
    }

    public static SMILMediaElement createMediaElement(String tag, SMILDocument document, String src) {
        SMILMediaElement mediaElement = (SMILMediaElement)document.createElement(tag);
        mediaElement.setSrc(SmilHelper.escapeXML(src));
        return mediaElement;
    }

    public static String escapeXML(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    private static SMILDocument createSmilDocument(PduBody pb) {
        SmilDocumentImpl document = new SmilDocumentImpl();
        SMILElement smil = (SMILElement)document.createElement("smil");
        smil.setAttribute("xmlns", "http://www.w3.org/2001/SMIL20/Language");
        document.appendChild(smil);
        SMILElement head = (SMILElement)document.createElement("head");
        smil.appendChild(head);
        SMILLayoutElement layout2 = (SMILLayoutElement)document.createElement("layout");
        head.appendChild(layout2);
        SMILElement body = (SMILElement)document.createElement("body");
        smil.appendChild(body);
        SMILParElement par = SmilHelper.addPar(document);
        int partsNum = pb.getPartsNum();
        if (partsNum == 0) {
            return document;
        }
        boolean hasText = false;
        boolean hasMedia = false;
        for (int i = 0; i < partsNum; ++i) {
            PduPart part;
            String contentType;
            if (par == null || hasMedia && hasText) {
                par = SmilHelper.addPar(document);
                hasText = false;
                hasMedia = false;
            }
            if (ContentType.isDrmType((String)(contentType = new String((part = pb.getPart(i)).getContentType())))) {
                try {
                    DrmWrapper dw = new DrmWrapper(contentType, part.getDataUri(), part.getData());
                    contentType = dw.getContentType();
                }
                catch (DrmException e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                }
            }
            if (contentType.equals("text/plain") || contentType.equalsIgnoreCase("application/vnd.wap.xhtml+xml") || contentType.equals("text/html")) {
                SMILMediaElement textElement = SmilHelper.createMediaElement(ELEMENT_TAG_TEXT, document, part.generateLocation());
                par.appendChild(textElement);
                hasText = true;
                continue;
            }
            if (ContentType.isImageType((String)contentType)) {
                SMILMediaElement imageElement = SmilHelper.createMediaElement(ELEMENT_TAG_IMAGE, document, part.generateLocation());
                par.appendChild(imageElement);
                hasMedia = true;
                continue;
            }
            if (ContentType.isVideoType((String)contentType)) {
                SMILMediaElement videoElement = SmilHelper.createMediaElement(ELEMENT_TAG_VIDEO, document, part.generateLocation());
                par.appendChild(videoElement);
                hasMedia = true;
                continue;
            }
            if (ContentType.isAudioType((String)contentType)) {
                SMILMediaElement audioElement = SmilHelper.createMediaElement(ELEMENT_TAG_AUDIO, document, part.generateLocation());
                par.appendChild(audioElement);
                hasMedia = true;
                continue;
            }
            Log.w((String)TAG, (String)"unsupport media type");
        }
        return document;
    }

    private static SMILDocument createSmilDocument(SlideshowModel slideshow) {
        SmilDocumentImpl document = new SmilDocumentImpl();
        SMILElement smilElement = (SMILElement)document.createElement("smil");
        document.appendChild(smilElement);
        SMILElement headElement = (SMILElement)document.createElement("head");
        smilElement.appendChild(headElement);
        SMILLayoutElement layoutElement = (SMILLayoutElement)document.createElement("layout");
        headElement.appendChild(layoutElement);
        SMILRootLayoutElement rootLayoutElement = (SMILRootLayoutElement)document.createElement("root-layout");
        LayoutModel layouts = slideshow.getLayout();
        rootLayoutElement.setWidth(layouts.getLayoutWidth());
        rootLayoutElement.setHeight(layouts.getLayoutHeight());
        String bgColor = layouts.getBackgroundColor();
        if (!TextUtils.isEmpty((CharSequence)bgColor)) {
            rootLayoutElement.setBackgroundColor(bgColor);
        }
        layoutElement.appendChild(rootLayoutElement);
        ArrayList<RegionModel> regions = layouts.getRegions();
        ArrayList<SMILRegionElement> smilRegions = new ArrayList<SMILRegionElement>();
        for (RegionModel r : regions) {
            SMILRegionElement smilRegion = (SMILRegionElement)document.createElement("region");
            smilRegion.setId(r.getRegionId());
            smilRegion.setLeft(r.getLeft());
            smilRegion.setTop(r.getTop());
            smilRegion.setWidth(r.getWidth());
            smilRegion.setHeight(r.getHeight());
            smilRegion.setFit(r.getFit());
            smilRegions.add(smilRegion);
        }
        SMILElement bodyElement = (SMILElement)document.createElement("body");
        smilElement.appendChild(bodyElement);
        boolean txtRegionPresentInLayout = false;
        boolean imgRegionPresentInLayout = false;
        for (SlideModel slide : slideshow) {
            SMILParElement par = SmilHelper.addPar(document);
            par.setDur((float)slide.getDuration() / 1000.0f);
            SmilHelper.addParElementEventListeners((EventTarget)((Object)par), slide);
            for (MediaModel media : slide) {
                int duration;
                SMILMediaElement sme = null;
                String src = media.getSrc();
                if (media instanceof TextModel) {
                    TextModel text = (TextModel)media;
                    if (TextUtils.isEmpty((CharSequence)text.getText())) continue;
                    sme = SmilHelper.createMediaElement(ELEMENT_TAG_TEXT, document, src);
                    txtRegionPresentInLayout = SmilHelper.setRegion((SMILRegionMediaElement)sme, smilRegions, layoutElement, "Text", txtRegionPresentInLayout);
                } else if (media instanceof ImageModel) {
                    sme = SmilHelper.createMediaElement(ELEMENT_TAG_IMAGE, document, src);
                    imgRegionPresentInLayout = SmilHelper.setRegion((SMILRegionMediaElement)sme, smilRegions, layoutElement, "Image", imgRegionPresentInLayout);
                } else if (media instanceof VideoModel) {
                    sme = SmilHelper.createMediaElement(ELEMENT_TAG_VIDEO, document, src);
                    imgRegionPresentInLayout = SmilHelper.setRegion((SMILRegionMediaElement)sme, smilRegions, layoutElement, "Image", imgRegionPresentInLayout);
                } else if (media instanceof AudioModel) {
                    sme = SmilHelper.createMediaElement(ELEMENT_TAG_AUDIO, document, src);
                } else {
                    Log.w((String)TAG, (String)("Unsupport media: " + media));
                    continue;
                }
                int begin = media.getBegin();
                if (begin != 0) {
                    sme.setAttribute("begin", String.valueOf(begin / 1000));
                }
                if ((duration = media.getDuration()) != 0) {
                    sme.setDur((float)duration / 1000.0f);
                }
                par.appendChild(sme);
                SmilHelper.addMediaElementEventListeners((EventTarget)((Object)sme), media);
            }
        }
        return document;
    }

    private static SMILRegionElement findRegionElementById(ArrayList<SMILRegionElement> smilRegions, String rId) {
        for (SMILRegionElement smilRegion : smilRegions) {
            if (!smilRegion.getId().equals(rId)) continue;
            return smilRegion;
        }
        return null;
    }

    private static boolean setRegion(SMILRegionMediaElement srme, ArrayList<SMILRegionElement> smilRegions, SMILLayoutElement smilLayout, String regionId, boolean regionPresentInLayout) {
        SMILRegionElement smilRegion = SmilHelper.findRegionElementById(smilRegions, regionId);
        if (!regionPresentInLayout && smilRegion != null) {
            srme.setRegion(smilRegion);
            smilLayout.appendChild(smilRegion);
            return true;
        }
        return false;
    }

    static void addMediaElementEventListeners(EventTarget target, MediaModel media) {
        target.addEventListener("SmilMediaStart", media, false);
        target.addEventListener("SmilMediaEnd", media, false);
        target.addEventListener("SmilMediaPause", media, false);
        target.addEventListener("SmilMediaSeek", media, false);
    }

    static void addParElementEventListeners(EventTarget target, SlideModel slide) {
        target.addEventListener("SmilSlideStart", slide, false);
        target.addEventListener("SmilSlideEnd", slide, false);
    }
}

