/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.model;

import android.content.ContentUris;
import android.content.Context;
import android.drm.mobile1.DrmException;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.android.mms.ContentRestrictionException;
import com.android.mms.ExceedMessageSizeException;
import com.android.mms.MmsConfig;
import com.android.mms.dom.smil.parser.SmilXmlSerializer;
import com.android.mms.drm.DrmWrapper;
import com.android.mms.layout.LayoutManager;
import com.android.mms.model.ContentRestriction;
import com.android.mms.model.ContentRestrictionFactory;
import com.android.mms.model.IModelChangedObserver;
import com.android.mms.model.LayoutModel;
import com.android.mms.model.MediaModel;
import com.android.mms.model.MediaModelFactory;
import com.android.mms.model.Model;
import com.android.mms.model.RegionModel;
import com.android.mms.model.SlideModel;
import com.android.mms.model.SmilHelper;
import com.android.mms.model.TextModel;
import com.google.android.mms.ContentType;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.MultimediaMessagePdu;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduPart;
import com.google.android.mms.pdu.PduPersister;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.smil.SMILDocument;
import org.w3c.dom.smil.SMILElement;
import org.w3c.dom.smil.SMILLayoutElement;
import org.w3c.dom.smil.SMILMediaElement;
import org.w3c.dom.smil.SMILParElement;
import org.w3c.dom.smil.SMILRegionElement;
import org.w3c.dom.smil.SMILRootLayoutElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideshowModel
extends Model
implements List<SlideModel>,
IModelChangedObserver {
    private static final String TAG = "Mms/slideshow";
    private final LayoutModel mLayout;
    private final ArrayList<SlideModel> mSlides;
    private SMILDocument mDocumentCache;
    private PduBody mPduBodyCache;
    private int mCurrentMessageSize;
    private Context mContext;
    public static final int SLIDESHOW_SLOP = 1024;

    private SlideshowModel(Context context) {
        this.mLayout = new LayoutModel();
        this.mSlides = new ArrayList();
        this.mContext = context;
    }

    private SlideshowModel(LayoutModel layouts, ArrayList<SlideModel> slides, SMILDocument documentCache, PduBody pbCache, Context context) {
        this.mLayout = layouts;
        this.mSlides = slides;
        this.mContext = context;
        this.mDocumentCache = documentCache;
        this.mPduBodyCache = pbCache;
        for (SlideModel slide : this.mSlides) {
            this.increaseMessageSize(slide.getSlideSize());
            slide.setParent(this);
        }
    }

    public static SlideshowModel createNew(Context context) {
        return new SlideshowModel(context);
    }

    public static SlideshowModel createFromMessageUri(Context context, Uri uri) throws MmsException {
        return SlideshowModel.createFromPduBody(context, SlideshowModel.getPduBody(context, uri));
    }

    public static SlideshowModel createFromPduBody(Context context, PduBody pb) throws MmsException {
        SMILDocument document = SmilHelper.getDocument(pb);
        SMILLayoutElement sle = document.getLayout();
        SMILRootLayoutElement srle = sle.getRootLayout();
        int w = srle.getWidth();
        int h = srle.getHeight();
        if (w == 0 || h == 0) {
            w = LayoutManager.getInstance().getLayoutParameters().getWidth();
            h = LayoutManager.getInstance().getLayoutParameters().getHeight();
            srle.setWidth(w);
            srle.setHeight(h);
        }
        RegionModel rootLayout = new RegionModel(null, 0, 0, w, h);
        ArrayList<RegionModel> regions = new ArrayList<RegionModel>();
        NodeList nlRegions = sle.getRegions();
        int regionsNum = nlRegions.getLength();
        for (int i = 0; i < regionsNum; ++i) {
            SMILRegionElement sre = (SMILRegionElement)nlRegions.item(i);
            RegionModel r = new RegionModel(sre.getId(), sre.getFit(), sre.getLeft(), sre.getTop(), sre.getWidth(), sre.getHeight(), sre.getBackgroundColor());
            regions.add(r);
        }
        LayoutModel layouts = new LayoutModel(rootLayout, regions);
        SMILElement docBody = document.getBody();
        NodeList slideNodes = docBody.getChildNodes();
        int slidesNum = slideNodes.getLength();
        ArrayList<SlideModel> slides = new ArrayList<SlideModel>(slidesNum);
        for (int i = 0; i < slidesNum; ++i) {
            SMILParElement par = (SMILParElement)slideNodes.item(i);
            NodeList mediaNodes = par.getChildNodes();
            int mediaNum = mediaNodes.getLength();
            ArrayList<MediaModel> mediaSet = new ArrayList<MediaModel>(mediaNum);
            for (int j = 0; j < mediaNum; ++j) {
                SMILMediaElement sme = (SMILMediaElement)mediaNodes.item(j);
                try {
                    MediaModel media = MediaModelFactory.getMediaModel(context, sme, layouts, pb);
                    if (!MmsConfig.getSlideDurationEnabled()) {
                        int mediadur = media.getDuration();
                        float dur = par.getDur();
                        if (dur == 0.0f) {
                            mediadur = MmsConfig.getMinimumSlideElementDuration() * 1000;
                            media.setDuration(mediadur);
                        }
                        if ((float)(mediadur / 1000) != dur) {
                            String tag = sme.getTagName();
                            if (ContentType.isVideoType((String)media.mContentType) || tag.equals("video") || ContentType.isAudioType((String)media.mContentType) || tag.equals("audio")) {
                                par.setDur((float)mediadur / 1000.0f + 1.0f);
                            } else if ((float)(mediadur / 1000) < dur) {
                                media.setDuration((int)dur * 1000);
                            } else if ((int)dur != 0) {
                                media.setDuration((int)dur * 1000);
                            } else {
                                par.setDur((float)mediadur / 1000.0f);
                            }
                        }
                    }
                    SmilHelper.addMediaElementEventListeners((EventTarget)((Object)sme), media);
                    mediaSet.add(media);
                    continue;
                }
                catch (DrmException e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                }
            }
            SlideModel slide = new SlideModel((int)(par.getDur() * 1000.0f), mediaSet);
            slide.setFill(par.getFill());
            SmilHelper.addParElementEventListeners((EventTarget)((Object)par), slide);
            slides.add(slide);
        }
        SlideshowModel slideshow = new SlideshowModel(layouts, slides, document, pb, context);
        slideshow.registerModelChangedObserver(slideshow);
        return slideshow;
    }

    public PduBody toPduBody() {
        if (this.mPduBodyCache == null) {
            this.mDocumentCache = SmilHelper.getDocument(this);
            this.mPduBodyCache = this.makePduBody(this.mDocumentCache);
        }
        return this.mPduBodyCache;
    }

    private PduBody makePduBody(SMILDocument document) {
        return this.makePduBody(null, document, false);
    }

    private PduBody makePduBody(Context context, SMILDocument document, boolean isMakingCopy) {
        PduBody pb = new PduBody();
        boolean hasForwardLock = false;
        for (SlideModel slide : this.mSlides) {
            for (MediaModel media : slide) {
                if (isMakingCopy && media.isDrmProtected() && !media.isAllowedToForward()) {
                    hasForwardLock = true;
                    continue;
                }
                PduPart part = new PduPart();
                if (media.isText()) {
                    TextModel text = (TextModel)media;
                    if (TextUtils.isEmpty((CharSequence)text.getText())) continue;
                    part.setCharset(text.getCharset());
                }
                part.setContentType(media.getContentType().getBytes());
                String src = media.getSrc();
                boolean startWithContentId = src.startsWith("cid:");
                String location = startWithContentId ? src.substring("cid:".length()) : src;
                part.setContentLocation(location.getBytes());
                if (startWithContentId) {
                    part.setContentId(location.getBytes());
                } else {
                    int index = location.lastIndexOf(".");
                    String contentId = index == -1 ? location : location.substring(0, index);
                    part.setContentId(contentId.getBytes());
                }
                if (media.isDrmProtected()) {
                    DrmWrapper wrapper = media.getDrmObject();
                    part.setDataUri(wrapper.getOriginalUri());
                    part.setData(wrapper.getOriginalData());
                } else if (media.isText()) {
                    part.setData(((TextModel)media).getText().getBytes());
                } else if (media.isImage() || media.isVideo() || media.isAudio()) {
                    part.setDataUri(media.getUri());
                } else {
                    Log.w((String)TAG, (String)("Unsupport media: " + media));
                }
                pb.addPart(part);
            }
        }
        if (hasForwardLock && isMakingCopy && context != null) {
            Toast.makeText((Context)context, (CharSequence)context.getString(2131165271), (int)1).show();
            document = SmilHelper.getDocument(pb);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SmilXmlSerializer.serialize(document, out);
        PduPart smilPart = new PduPart();
        smilPart.setContentId("smil".getBytes());
        smilPart.setContentLocation("smil.xml".getBytes());
        smilPart.setContentType("application/smil".getBytes());
        smilPart.setData(out.toByteArray());
        pb.addPart(0, smilPart);
        return pb;
    }

    public PduBody makeCopy(Context context) {
        return this.makePduBody(context, SmilHelper.getDocument(this), true);
    }

    public SMILDocument toSmilDocument() {
        if (this.mDocumentCache == null) {
            this.mDocumentCache = SmilHelper.getDocument(this);
        }
        return this.mDocumentCache;
    }

    public static PduBody getPduBody(Context context, Uri msg) throws MmsException {
        PduPersister p = PduPersister.getPduPersister((Context)context);
        GenericPdu pdu = p.load(msg);
        int msgType = pdu.getMessageType();
        if (msgType == 128 || msgType == 132) {
            return ((MultimediaMessagePdu)pdu).getBody();
        }
        throw new MmsException();
    }

    public void setCurrentMessageSize(int size) {
        this.mCurrentMessageSize = size;
    }

    public int getCurrentMessageSize() {
        return this.mCurrentMessageSize;
    }

    public void increaseMessageSize(int increaseSize) {
        if (increaseSize > 0) {
            this.mCurrentMessageSize += increaseSize;
        }
    }

    public void decreaseMessageSize(int decreaseSize) {
        if (decreaseSize > 0) {
            this.mCurrentMessageSize -= decreaseSize;
        }
    }

    public LayoutModel getLayout() {
        return this.mLayout;
    }

    @Override
    public boolean add(SlideModel object) {
        int increaseSize = object.getSlideSize();
        this.checkMessageSize(increaseSize);
        if (object != null && this.mSlides.add(object)) {
            this.increaseMessageSize(increaseSize);
            object.registerModelChangedObserver(this);
            for (IModelChangedObserver observer : this.mModelChangedObservers) {
                object.registerModelChangedObserver(observer);
            }
            this.notifyModelChanged(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends SlideModel> collection) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public void clear() {
        if (this.mSlides.size() > 0) {
            for (SlideModel slide : this.mSlides) {
                slide.unregisterModelChangedObserver(this);
                for (IModelChangedObserver observer : this.mModelChangedObservers) {
                    slide.unregisterModelChangedObserver(observer);
                }
            }
            this.mCurrentMessageSize = 0;
            this.mSlides.clear();
            this.notifyModelChanged(true);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.mSlides.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.mSlides.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.mSlides.isEmpty();
    }

    @Override
    public Iterator<SlideModel> iterator() {
        return this.mSlides.iterator();
    }

    @Override
    public boolean remove(Object object) {
        if (object != null && this.mSlides.remove(object)) {
            SlideModel slide = (SlideModel)object;
            this.decreaseMessageSize(slide.getSlideSize());
            slide.unregisterAllModelChangedObservers();
            this.notifyModelChanged(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public int size() {
        return this.mSlides.size();
    }

    @Override
    public Object[] toArray() {
        return this.mSlides.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array2) {
        return this.mSlides.toArray(array2);
    }

    @Override
    public void add(int location, SlideModel object) {
        if (object != null) {
            int increaseSize = object.getSlideSize();
            this.checkMessageSize(increaseSize);
            this.mSlides.add(location, object);
            this.increaseMessageSize(increaseSize);
            object.registerModelChangedObserver(this);
            for (IModelChangedObserver observer : this.mModelChangedObservers) {
                object.registerModelChangedObserver(observer);
            }
            this.notifyModelChanged(true);
        }
    }

    @Override
    public boolean addAll(int location, Collection<? extends SlideModel> collection) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public SlideModel get(int location) {
        return location >= 0 && location < this.mSlides.size() ? this.mSlides.get(location) : null;
    }

    @Override
    public int indexOf(Object object) {
        return this.mSlides.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.mSlides.lastIndexOf(object);
    }

    @Override
    public ListIterator<SlideModel> listIterator() {
        return this.mSlides.listIterator();
    }

    @Override
    public ListIterator<SlideModel> listIterator(int location) {
        return this.mSlides.listIterator(location);
    }

    @Override
    public SlideModel remove(int location) {
        SlideModel slide = this.mSlides.remove(location);
        if (slide != null) {
            this.decreaseMessageSize(slide.getSlideSize());
            slide.unregisterAllModelChangedObservers();
            this.notifyModelChanged(true);
        }
        return slide;
    }

    @Override
    public SlideModel set(int location, SlideModel object) {
        SlideModel slide = this.mSlides.get(location);
        if (null != object) {
            int removeSize = 0;
            int addSize = object.getSlideSize();
            if (null != slide) {
                removeSize = slide.getSlideSize();
            }
            if (addSize > removeSize) {
                this.checkMessageSize(addSize - removeSize);
                this.increaseMessageSize(addSize - removeSize);
            } else {
                this.decreaseMessageSize(removeSize - addSize);
            }
        }
        if ((slide = this.mSlides.set(location, object)) != null) {
            slide.unregisterAllModelChangedObservers();
        }
        if (object != null) {
            object.registerModelChangedObserver(this);
            for (IModelChangedObserver observer : this.mModelChangedObservers) {
                object.registerModelChangedObserver(observer);
            }
        }
        this.notifyModelChanged(true);
        return slide;
    }

    @Override
    public List<SlideModel> subList(int start, int end) {
        return this.mSlides.subList(start, end);
    }

    @Override
    protected void registerModelChangedObserverInDescendants(IModelChangedObserver observer) {
        this.mLayout.registerModelChangedObserver(observer);
        for (SlideModel slide : this.mSlides) {
            slide.registerModelChangedObserver(observer);
        }
    }

    @Override
    protected void unregisterModelChangedObserverInDescendants(IModelChangedObserver observer) {
        this.mLayout.unregisterModelChangedObserver(observer);
        for (SlideModel slide : this.mSlides) {
            slide.unregisterModelChangedObserver(observer);
        }
    }

    @Override
    protected void unregisterAllModelChangedObserversInDescendants() {
        this.mLayout.unregisterAllModelChangedObservers();
        for (SlideModel slide : this.mSlides) {
            slide.unregisterAllModelChangedObservers();
        }
    }

    @Override
    public void onModelChanged(Model model, boolean dataChanged) {
        if (dataChanged) {
            this.mDocumentCache = null;
            this.mPduBodyCache = null;
        }
    }

    public void sync(PduBody pb) {
        for (SlideModel slide : this.mSlides) {
            for (MediaModel media : slide) {
                PduPart part = pb.getPartByContentLocation(media.getSrc());
                if (part == null) continue;
                media.setUri(part.getDataUri());
            }
        }
    }

    public void checkMessageSize(int increaseSize) throws ContentRestrictionException {
        ContentRestriction cr = ContentRestrictionFactory.getContentRestriction();
        cr.checkMessageSize(this.mCurrentMessageSize, increaseSize, this.mContext.getContentResolver());
    }

    public boolean isSimple() {
        if (this.size() != 1) {
            return false;
        }
        SlideModel slide = this.get(0);
        if (!(slide.hasImage() ^ slide.hasVideo())) {
            return false;
        }
        return !slide.hasAudio();
    }

    public void prepareForSend() {
        TextModel text;
        if (this.size() == 1 && (text = this.get(0).getText()) != null) {
            text.cloneText();
        }
    }

    public void finalResize(Uri messageUri) throws MmsException, ExceedMessageSizeException {
        int resizableCnt = 0;
        int fixedSizeTotal = 0;
        for (SlideModel slide : this.mSlides) {
            for (MediaModel media : slide) {
                if (media.getMediaResizable()) {
                    ++resizableCnt;
                    continue;
                }
                fixedSizeTotal += media.getMediaSize();
            }
        }
        if (resizableCnt > 0) {
            int remainingSize = MmsConfig.getMaxMessageSize() - fixedSizeTotal - 1024;
            if (remainingSize <= 0) {
                throw new ExceedMessageSizeException("No room for pictures");
            }
            long messageId = ContentUris.parseId((Uri)messageUri);
            int bytesPerMediaItem = remainingSize / resizableCnt;
            for (SlideModel slide : this.mSlides) {
                for (MediaModel media : slide) {
                    if (!media.getMediaResizable()) continue;
                    media.resizeMedia(bytesPerMediaItem, messageId);
                }
            }
            int totalSize = 0;
            for (SlideModel slide : this.mSlides) {
                for (MediaModel media : slide) {
                    totalSize += media.getMediaSize();
                }
            }
            if (totalSize > MmsConfig.getMaxMessageSize()) {
                throw new ExceedMessageSizeException("After compressing pictures, message too big");
            }
            this.setCurrentMessageSize(totalSize);
            this.onModelChanged(this, true);
            PduBody pb = this.toPduBody();
            PduPersister.getPduPersister((Context)this.mContext).updateParts(messageUri, pb);
        }
    }
}

