/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.model;

import com.android.mms.model.IModelChangedObserver;
import java.util.ArrayList;

public class Model {
    protected ArrayList<IModelChangedObserver> mModelChangedObservers = new ArrayList();

    public void registerModelChangedObserver(IModelChangedObserver observer) {
        if (!this.mModelChangedObservers.contains(observer)) {
            this.mModelChangedObservers.add(observer);
            this.registerModelChangedObserverInDescendants(observer);
        }
    }

    public void unregisterModelChangedObserver(IModelChangedObserver observer) {
        this.mModelChangedObservers.remove(observer);
        this.unregisterModelChangedObserverInDescendants(observer);
    }

    public void unregisterAllModelChangedObservers() {
        this.unregisterAllModelChangedObserversInDescendants();
        this.mModelChangedObservers.clear();
    }

    protected void notifyModelChanged(boolean dataChanged) {
        for (IModelChangedObserver observer : this.mModelChangedObservers) {
            observer.onModelChanged(this, dataChanged);
        }
    }

    protected void registerModelChangedObserverInDescendants(IModelChangedObserver observer) {
    }

    protected void unregisterModelChangedObserverInDescendants(IModelChangedObserver observer) {
    }

    protected void unregisterAllModelChangedObserversInDescendants() {
    }
}

