/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.model;

import android.content.Context;
import android.drm.mobile1.DrmException;
import android.util.Log;
import com.android.mms.MmsConfig;
import com.android.mms.UnsupportContentTypeException;
import com.android.mms.drm.DrmWrapper;
import com.android.mms.model.AudioModel;
import com.android.mms.model.ImageModel;
import com.android.mms.model.LayoutModel;
import com.android.mms.model.MediaModel;
import com.android.mms.model.RegionModel;
import com.android.mms.model.TextModel;
import com.android.mms.model.VideoModel;
import com.google.android.mms.ContentType;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduPart;
import java.io.IOException;
import org.w3c.dom.smil.SMILMediaElement;
import org.w3c.dom.smil.SMILRegionElement;
import org.w3c.dom.smil.SMILRegionMediaElement;
import org.w3c.dom.smil.Time;
import org.w3c.dom.smil.TimeList;

public class MediaModelFactory {
    private static final String TAG = "Mms:media";

    public static MediaModel getMediaModel(Context context, SMILMediaElement sme, LayoutModel layouts, PduBody pb) throws DrmException, IOException, IllegalArgumentException, MmsException {
        String tag = sme.getTagName();
        String src = sme.getSrc();
        PduPart part = MediaModelFactory.findPart(pb, src);
        if (sme instanceof SMILRegionMediaElement) {
            return MediaModelFactory.getRegionMediaModel(context, tag, src, (SMILRegionMediaElement)sme, layouts, part);
        }
        return MediaModelFactory.getGenericMediaModel(context, tag, src, sme, part, null);
    }

    private static PduPart findPart(PduBody pb, String src) {
        PduPart part = null;
        if (src != null) {
            if ((src = MediaModelFactory.unescapeXML(src)).startsWith("cid:")) {
                part = pb.getPartByContentId("<" + src.substring("cid:".length()) + ">");
            } else {
                part = pb.getPartByName(src);
                if (part == null && (part = pb.getPartByFileName(src)) == null) {
                    part = pb.getPartByContentLocation(src);
                }
            }
        }
        if (part != null) {
            return part;
        }
        throw new IllegalArgumentException("No part found for the model.");
    }

    private static String unescapeXML(String str) {
        return str.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&apos;", "'").replaceAll("&amp;", "&");
    }

    private static MediaModel getRegionMediaModel(Context context, String tag, String src, SMILRegionMediaElement srme, LayoutModel layouts, PduPart part) throws DrmException, IOException, MmsException {
        SMILRegionElement sre = srme.getRegion();
        if (sre != null) {
            RegionModel region = layouts.findRegionById(sre.getId());
            if (region != null) {
                return MediaModelFactory.getGenericMediaModel(context, tag, src, srme, part, region);
            }
        } else {
            String rId = null;
            rId = tag.equals("text") ? "Text" : "Image";
            RegionModel region = layouts.findRegionById(rId);
            if (region != null) {
                return MediaModelFactory.getGenericMediaModel(context, tag, src, srme, part, region);
            }
        }
        throw new IllegalArgumentException("Region not found or bad region ID.");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MediaModel getGenericMediaModel(Context context, String tag, String src, SMILMediaElement sme, PduPart part, RegionModel regionModel) throws DrmException, IOException, MmsException {
        Time t;
        void var8_27;
        byte[] bytes = part.getContentType();
        if (bytes == null) {
            throw new IllegalArgumentException("Content-Type of the part may not be null.");
        }
        String contentType = new String(bytes);
        Object var8_8 = null;
        if (ContentType.isDrmType((String)contentType)) {
            DrmWrapper wrapper = new DrmWrapper(contentType, part.getDataUri(), part.getData());
            if (tag.equals("text")) {
                TextModel textModel = new TextModel(context, contentType, src, part.getCharset(), wrapper, regionModel);
            } else if (tag.equals("img")) {
                ImageModel imageModel = new ImageModel(context, contentType, src, wrapper, regionModel);
            } else if (tag.equals("video")) {
                VideoModel videoModel = new VideoModel(context, contentType, src, wrapper, regionModel);
            } else if (tag.equals("audio")) {
                AudioModel audioModel = new AudioModel(context, contentType, src, wrapper);
            } else {
                if (!tag.equals("ref")) throw new IllegalArgumentException("Unsupported TAG: " + tag);
                String drmContentType = wrapper.getContentType();
                if (ContentType.isTextType((String)drmContentType)) {
                    TextModel textModel = new TextModel(context, contentType, src, part.getCharset(), wrapper, regionModel);
                } else if (ContentType.isImageType((String)drmContentType)) {
                    ImageModel imageModel = new ImageModel(context, contentType, src, wrapper, regionModel);
                } else if (ContentType.isVideoType((String)drmContentType)) {
                    VideoModel videoModel = new VideoModel(context, contentType, src, wrapper, regionModel);
                } else {
                    if (!ContentType.isAudioType((String)drmContentType)) throw new UnsupportContentTypeException("Unsupported Content-Type: " + drmContentType);
                    AudioModel audioModel = new AudioModel(context, contentType, src, wrapper);
                }
            }
        } else if (tag.equals("text")) {
            TextModel textModel = new TextModel(context, contentType, src, part.getCharset(), part.getData(), regionModel);
        } else if (tag.equals("img")) {
            ImageModel imageModel = new ImageModel(context, contentType, src, part.getDataUri(), regionModel);
        } else if (tag.equals("video")) {
            VideoModel videoModel = new VideoModel(context, contentType, src, part.getDataUri(), regionModel);
        } else if (tag.equals("audio")) {
            AudioModel audioModel = new AudioModel(context, contentType, src, part.getDataUri());
        } else {
            if (!tag.equals("ref")) throw new IllegalArgumentException("Unsupported TAG: " + tag);
            if (ContentType.isTextType((String)contentType)) {
                TextModel textModel = new TextModel(context, contentType, src, part.getCharset(), part.getData(), regionModel);
            } else if (ContentType.isImageType((String)contentType)) {
                ImageModel imageModel = new ImageModel(context, contentType, src, part.getDataUri(), regionModel);
            } else if (ContentType.isVideoType((String)contentType)) {
                VideoModel videoModel = new VideoModel(context, contentType, src, part.getDataUri(), regionModel);
            } else {
                if (!ContentType.isAudioType((String)contentType)) throw new UnsupportContentTypeException("Unsupported Content-Type: " + contentType);
                AudioModel audioModel = new AudioModel(context, contentType, src, part.getDataUri());
            }
        }
        int begin = 0;
        TimeList tl = sme.getBegin();
        if (tl != null && tl.getLength() > 0) {
            Time t2 = tl.item(0);
            begin = (int)(t2.getResolvedOffset() * 1000.0);
        }
        var8_27.setBegin(begin);
        int duration = (int)(sme.getDur() * 1000.0f);
        if (duration <= 0 && (tl = sme.getEnd()) != null && tl.getLength() > 0 && (t = tl.item(0)).getTimeType() != 0 && (duration = (int)(t.getResolvedOffset() * 1000.0) - begin) == 0 && (var8_27 instanceof AudioModel || var8_27 instanceof VideoModel)) {
            duration = MmsConfig.getMinimumSlideElementDuration();
            if (Log.isLoggable((String)"Mms:app", (int)2)) {
                Log.d((String)TAG, (String)("[MediaModelFactory] compute new duration for " + tag + ", duration=" + duration));
            }
        }
        var8_27.setDuration(duration);
        if (!MmsConfig.getSlideDurationEnabled()) {
            var8_27.setFill((short)1);
            return var8_27;
        } else {
            var8_27.setFill(sme.getFill());
        }
        return var8_27;
    }
}

