/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.model;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.drm.mobile1.DrmException;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.util.Log;
import com.android.mms.drm.DrmUtils;
import com.android.mms.drm.DrmWrapper;
import com.android.mms.model.Model;
import com.google.android.mms.MmsException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.w3c.dom.events.EventListener;

public abstract class MediaModel
extends Model
implements EventListener {
    protected static final String TAG = "Mms/media";
    private static final String MUSIC_SERVICE_ACTION = "com.android.music.musicservicecommand";
    protected Context mContext;
    protected int mBegin;
    protected int mDuration;
    protected String mTag;
    protected String mSrc;
    protected String mContentType;
    private Uri mUri;
    private byte[] mData;
    protected short mFill;
    protected int mSize;
    protected int mSeekTo;
    protected DrmWrapper mDrmObjectWrapper;
    protected boolean mMediaResizeable;
    private final ArrayList<MediaAction> mMediaActions;

    public MediaModel(Context context, String tag, String contentType, String src, Uri uri) throws MmsException {
        this.mContext = context;
        this.mTag = tag;
        this.mContentType = contentType;
        this.mSrc = src;
        this.mUri = uri;
        this.initMediaSize();
        this.mMediaActions = new ArrayList();
    }

    public MediaModel(Context context, String tag, String contentType, String src, byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data may not be null.");
        }
        this.mContext = context;
        this.mTag = tag;
        this.mContentType = contentType;
        this.mSrc = src;
        this.mData = data;
        this.mSize = data.length;
        this.mMediaActions = new ArrayList();
    }

    public MediaModel(Context context, String tag, String contentType, String src, DrmWrapper wrapper) throws IOException {
        this.mContext = context;
        this.mTag = tag;
        this.mContentType = contentType;
        this.mSrc = src;
        this.mDrmObjectWrapper = wrapper;
        this.mUri = DrmUtils.insert(context, wrapper);
        this.mSize = wrapper.getOriginalData().length;
        this.mMediaActions = new ArrayList();
    }

    public int getBegin() {
        return this.mBegin;
    }

    public void setBegin(int begin) {
        this.mBegin = begin;
        this.notifyModelChanged(true);
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setDuration(int duration) {
        if (this.isPlayable() && duration < 0) {
            try {
                this.initMediaDuration();
            }
            catch (MmsException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                return;
            }
        } else {
            this.mDuration = duration;
        }
        this.notifyModelChanged(true);
    }

    public String getTag() {
        return this.mTag;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public Uri getUriWithDrmCheck() throws DrmException {
        if (this.mUri != null && this.isDrmProtected() && !this.mDrmObjectWrapper.consumeRights()) {
            throw new DrmException("Insufficient DRM rights.");
        }
        return this.mUri;
    }

    public byte[] getData() throws DrmException {
        if (this.mData != null) {
            if (this.isDrmProtected() && !this.mDrmObjectWrapper.consumeRights()) {
                throw new DrmException(this.mContext.getString(2131165221));
            }
            byte[] data = new byte[this.mData.length];
            System.arraycopy(this.mData, 0, data, 0, this.mData.length);
            return data;
        }
        return null;
    }

    void setUri(Uri uri) {
        this.mUri = uri;
    }

    public String getSrc() {
        return this.mSrc;
    }

    public short getFill() {
        return this.mFill;
    }

    public void setFill(short fill) {
        this.mFill = fill;
        this.notifyModelChanged(true);
    }

    public boolean getMediaResizable() {
        return this.mMediaResizeable;
    }

    public int getMediaSize() {
        return this.mSize;
    }

    public boolean isText() {
        return this.mTag.equals("text");
    }

    public boolean isImage() {
        return this.mTag.equals("img");
    }

    public boolean isVideo() {
        return this.mTag.equals("video");
    }

    public boolean isAudio() {
        return this.mTag.equals("audio");
    }

    public boolean isDrmProtected() {
        return this.mDrmObjectWrapper != null;
    }

    public boolean isAllowedToForward() {
        return this.mDrmObjectWrapper.isAllowedToForward();
    }

    protected void initMediaDuration() throws MmsException {
        if (this.mUri == null) {
            throw new IllegalArgumentException("Uri may not be null.");
        }
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        int duration = 0;
        try {
            retriever.setDataSource(this.mContext, this.mUri);
            String dur = retriever.extractMetadata(9);
            if (dur != null) {
                duration = Integer.parseInt(dur);
            }
            this.mDuration = duration;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("MediaMetadataRetriever failed to get duration for " + this.mUri.getPath()), (Throwable)ex);
            throw new MmsException((Throwable)ex);
        }
        finally {
            retriever.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMediaSize() throws MmsException {
        ContentResolver cr = this.mContext.getContentResolver();
        InputStream input = null;
        try {
            input = cr.openInputStream(this.mUri);
            if (input instanceof FileInputStream) {
                FileInputStream f = (FileInputStream)input;
                this.mSize = (int)f.getChannel().size();
            } else {
                while (-1 != input.read()) {
                    ++this.mSize;
                }
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException caught while opening or reading stream", (Throwable)e);
            if (e instanceof FileNotFoundException) {
                throw new MmsException(e.getMessage());
            }
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"IOException caught while closing stream", (Throwable)e);
                }
            }
        }
    }

    public static boolean isMmsUri(Uri uri) {
        return uri.getAuthority().startsWith("mms");
    }

    public int getSeekTo() {
        return this.mSeekTo;
    }

    public void appendAction(MediaAction action) {
        this.mMediaActions.add(action);
    }

    public MediaAction getCurrentAction() {
        if (0 == this.mMediaActions.size()) {
            return MediaAction.NO_ACTIVE_ACTION;
        }
        return this.mMediaActions.remove(0);
    }

    protected boolean isPlayable() {
        return false;
    }

    public DrmWrapper getDrmObject() {
        return this.mDrmObjectWrapper;
    }

    protected void pauseMusicPlayer() {
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            Log.d((String)TAG, (String)"pauseMusicPlayer");
        }
        Intent i = new Intent(MUSIC_SERVICE_ACTION);
        i.putExtra("command", "pause");
        this.mContext.sendBroadcast(i);
    }

    protected void resizeMedia(int byteLimit, long messageId) throws MmsException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MediaAction {
        NO_ACTIVE_ACTION,
        START,
        STOP,
        PAUSE,
        SEEK;

    }
}

