/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.model;

import android.util.Log;
import com.android.mms.layout.LayoutManager;
import com.android.mms.layout.LayoutParameters;
import com.android.mms.model.IModelChangedObserver;
import com.android.mms.model.Model;
import com.android.mms.model.RegionModel;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutModel
extends Model {
    private static final String TAG = "Mms/slideshow";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    public static final String IMAGE_REGION_ID = "Image";
    public static final String TEXT_REGION_ID = "Text";
    public static final int LAYOUT_BOTTOM_TEXT = 0;
    public static final int LAYOUT_TOP_TEXT = 1;
    public static final int DEFAULT_LAYOUT_TYPE = 0;
    private int mLayoutType = 0;
    private RegionModel mRootLayout;
    private RegionModel mImageRegion;
    private RegionModel mTextRegion;
    private ArrayList<RegionModel> mNonStdRegions;
    private LayoutParameters mLayoutParams = LayoutManager.getInstance().getLayoutParameters();

    public LayoutModel() {
        this.createDefaultRootLayout();
        this.createDefaultImageRegion();
        this.createDefaultTextRegion();
    }

    public LayoutModel(RegionModel rootLayout, ArrayList<RegionModel> regions) {
        this.mRootLayout = rootLayout;
        this.mNonStdRegions = new ArrayList();
        for (RegionModel r : regions) {
            String rId = r.getRegionId();
            if (rId.equals(IMAGE_REGION_ID)) {
                this.mImageRegion = r;
                continue;
            }
            if (rId.equals(TEXT_REGION_ID)) {
                this.mTextRegion = r;
                continue;
            }
            this.mNonStdRegions.add(r);
        }
        this.validateLayouts();
    }

    private void createDefaultRootLayout() {
        this.mRootLayout = new RegionModel(null, 0, 0, this.mLayoutParams.getWidth(), this.mLayoutParams.getHeight());
    }

    private void createDefaultImageRegion() {
        if (this.mRootLayout == null) {
            throw new IllegalStateException("Root-Layout uninitialized.");
        }
        this.mImageRegion = new RegionModel(IMAGE_REGION_ID, 0, 0, this.mRootLayout.getWidth(), this.mLayoutParams.getImageHeight());
    }

    private void createDefaultTextRegion() {
        if (this.mRootLayout == null) {
            throw new IllegalStateException("Root-Layout uninitialized.");
        }
        this.mTextRegion = new RegionModel(TEXT_REGION_ID, 0, this.mLayoutParams.getImageHeight(), this.mRootLayout.getWidth(), this.mLayoutParams.getTextHeight());
    }

    private void validateLayouts() {
        if (this.mRootLayout == null) {
            this.createDefaultRootLayout();
        }
        if (this.mImageRegion == null) {
            this.createDefaultImageRegion();
        }
        if (this.mTextRegion == null) {
            this.createDefaultTextRegion();
        }
    }

    public RegionModel getRootLayout() {
        return this.mRootLayout;
    }

    public void setRootLayout(RegionModel rootLayout) {
        this.mRootLayout = rootLayout;
    }

    public RegionModel getImageRegion() {
        return this.mImageRegion;
    }

    public void setImageRegion(RegionModel imageRegion) {
        this.mImageRegion = imageRegion;
    }

    public RegionModel getTextRegion() {
        return this.mTextRegion;
    }

    public void setTextRegion(RegionModel textRegion) {
        this.mTextRegion = textRegion;
    }

    public ArrayList<RegionModel> getRegions() {
        ArrayList<RegionModel> regions = new ArrayList<RegionModel>();
        if (this.mImageRegion != null) {
            regions.add(this.mImageRegion);
        }
        if (this.mTextRegion != null) {
            regions.add(this.mTextRegion);
        }
        return regions;
    }

    public RegionModel findRegionById(String rId) {
        if (IMAGE_REGION_ID.equals(rId)) {
            return this.mImageRegion;
        }
        if (TEXT_REGION_ID.equals(rId)) {
            return this.mTextRegion;
        }
        for (RegionModel r : this.mNonStdRegions) {
            if (!r.getRegionId().equals(rId)) continue;
            return r;
        }
        return null;
    }

    public int getLayoutWidth() {
        return this.mRootLayout.getWidth();
    }

    public int getLayoutHeight() {
        return this.mRootLayout.getHeight();
    }

    public String getBackgroundColor() {
        return this.mRootLayout.getBackgroundColor();
    }

    public void changeTo(int layout2) {
        if (this.mRootLayout == null) {
            throw new IllegalStateException("Root-Layout uninitialized.");
        }
        if (this.mLayoutParams == null) {
            this.mLayoutParams = LayoutManager.getInstance().getLayoutParameters();
        }
        if (this.mLayoutType != layout2) {
            switch (layout2) {
                case 0: {
                    this.mImageRegion.setTop(0);
                    this.mTextRegion.setTop(this.mLayoutParams.getImageHeight());
                    this.mLayoutType = layout2;
                    this.notifyModelChanged(true);
                    break;
                }
                case 1: {
                    this.mImageRegion.setTop(this.mLayoutParams.getTextHeight());
                    this.mTextRegion.setTop(0);
                    this.mLayoutType = layout2;
                    this.notifyModelChanged(true);
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)("Unknown layout type: " + layout2));
                }
            }
        }
    }

    public int getLayoutType() {
        return this.mLayoutType;
    }

    @Override
    protected void registerModelChangedObserverInDescendants(IModelChangedObserver observer) {
        if (this.mRootLayout != null) {
            this.mRootLayout.registerModelChangedObserver(observer);
        }
        if (this.mImageRegion != null) {
            this.mImageRegion.registerModelChangedObserver(observer);
        }
        if (this.mTextRegion != null) {
            this.mTextRegion.registerModelChangedObserver(observer);
        }
    }

    @Override
    protected void unregisterModelChangedObserverInDescendants(IModelChangedObserver observer) {
        if (this.mRootLayout != null) {
            this.mRootLayout.unregisterModelChangedObserver(observer);
        }
        if (this.mImageRegion != null) {
            this.mImageRegion.unregisterModelChangedObserver(observer);
        }
        if (this.mTextRegion != null) {
            this.mTextRegion.unregisterModelChangedObserver(observer);
        }
    }

    @Override
    protected void unregisterAllModelChangedObserversInDescendants() {
        if (this.mRootLayout != null) {
            this.mRootLayout.unregisterAllModelChangedObservers();
        }
        if (this.mImageRegion != null) {
            this.mImageRegion.unregisterAllModelChangedObservers();
        }
        if (this.mTextRegion != null) {
            this.mTextRegion.unregisterAllModelChangedObservers();
        }
    }
}

