/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.model;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.text.TextUtils;
import com.android.mms.ContentRestrictionException;
import com.android.mms.dom.events.EventImpl;
import com.android.mms.drm.DrmWrapper;
import com.android.mms.model.ContentRestriction;
import com.android.mms.model.ContentRestrictionFactory;
import com.android.mms.model.MediaModel;
import com.google.android.mms.MmsException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.events.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioModel
extends MediaModel {
    private static final String TAG = "Mms/media";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private final HashMap<String, String> mExtras = new HashMap();

    public AudioModel(Context context, Uri uri) throws MmsException {
        this(context, null, null, uri);
        this.initModelFromUri(uri);
        this.checkContentRestriction();
    }

    public AudioModel(Context context, String contentType, String src, Uri uri) throws MmsException {
        super(context, "audio", contentType, src, uri);
    }

    public AudioModel(Context context, String contentType, String src, DrmWrapper wrapper) throws IOException {
        super(context, "audio", contentType, src, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModelFromUri(Uri uri) throws MmsException {
        block10: {
            ContentResolver cr = this.mContext.getContentResolver();
            Cursor c = SqliteWrapper.query((Context)this.mContext, (ContentResolver)cr, (Uri)uri, null, null, null, null);
            if (c != null) {
                try {
                    if (c.moveToFirst()) {
                        String path;
                        boolean isFromMms = AudioModel.isMmsUri(uri);
                        if (isFromMms) {
                            path = c.getString(c.getColumnIndexOrThrow("_data"));
                            this.mContentType = c.getString(c.getColumnIndexOrThrow("ct"));
                        } else {
                            String artist;
                            path = c.getString(c.getColumnIndexOrThrow("_data"));
                            this.mContentType = c.getString(c.getColumnIndexOrThrow("mime_type"));
                            String album = c.getString(c.getColumnIndexOrThrow("album"));
                            if (!TextUtils.isEmpty((CharSequence)album)) {
                                this.mExtras.put("album", album);
                            }
                            if (!TextUtils.isEmpty((CharSequence)(artist = c.getString(c.getColumnIndexOrThrow("artist"))))) {
                                this.mExtras.put("artist", artist);
                            }
                        }
                        this.mSrc = path.substring(path.lastIndexOf(47) + 1);
                        if (TextUtils.isEmpty((CharSequence)this.mContentType)) {
                            throw new MmsException("Type of media is unknown.");
                        }
                        break block10;
                    }
                    throw new MmsException("Nothing found: " + uri);
                }
                finally {
                    c.close();
                }
            }
            throw new MmsException("Bad URI: " + uri);
        }
        this.initMediaDuration();
    }

    public void stop() {
        this.appendAction(MediaModel.MediaAction.STOP);
        this.notifyModelChanged(false);
    }

    @Override
    public void handleEvent(Event evt) {
        String evtType = evt.getType();
        MediaModel.MediaAction action = MediaModel.MediaAction.NO_ACTIVE_ACTION;
        if (evtType.equals("SmilMediaStart")) {
            action = MediaModel.MediaAction.START;
            this.pauseMusicPlayer();
        } else if (evtType.equals("SmilMediaEnd")) {
            action = MediaModel.MediaAction.STOP;
        } else if (evtType.equals("SmilMediaPause")) {
            action = MediaModel.MediaAction.PAUSE;
        } else if (evtType.equals("SmilMediaSeek")) {
            action = MediaModel.MediaAction.SEEK;
            this.mSeekTo = ((EventImpl)evt).getSeekTo();
        }
        this.appendAction(action);
        this.notifyModelChanged(false);
    }

    public Map<String, ?> getExtras() {
        return this.mExtras;
    }

    protected void checkContentRestriction() throws ContentRestrictionException {
        ContentRestriction cr = ContentRestrictionFactory.getContentRestriction();
        cr.checkAudioContentType(this.mContentType);
    }

    @Override
    protected boolean isPlayable() {
        return true;
    }
}

