/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.drm;

import android.drm.mobile1.DrmException;
import android.drm.mobile1.DrmRawContent;
import android.drm.mobile1.DrmRights;
import android.drm.mobile1.DrmRightsManager;
import android.net.Uri;
import android.util.Log;
import com.google.android.mms.ContentType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DrmWrapper {
    private DrmRights mRight;
    private final DrmRawContent mDrmObject;
    private final Uri mDataUri;
    private final byte[] mData;
    private byte[] mDecryptedData;
    private static final String LOG_TAG = "DrmWrapper";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;

    public DrmWrapper(String drmContentType, Uri uri, byte[] drmData) throws DrmException, IOException {
        if (drmContentType == null || drmData == null) {
            throw new IllegalArgumentException("Content-Type or data may not be null.");
        }
        this.mDataUri = uri;
        this.mData = drmData;
        ByteArrayInputStream drmDataStream = new ByteArrayInputStream(drmData);
        this.mDrmObject = new DrmRawContent((InputStream)drmDataStream, drmDataStream.available(), drmContentType);
        if (!this.isRightsInstalled()) {
            this.installRights(drmData);
        }
    }

    private int getPermission() {
        String contentType = this.mDrmObject.getContentType();
        if (ContentType.isAudioType((String)contentType) || ContentType.isVideoType((String)contentType)) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDecryptedData() throws IOException {
        if (this.mDecryptedData == null && this.mRight != null) {
            InputStream decryptedDataStream = this.mDrmObject.getContentInputStream(this.mRight);
            try {
                int len;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[256];
                while ((len = decryptedDataStream.read(buffer)) > 0) {
                    baos.write(buffer, 0, len);
                }
                this.mDecryptedData = baos.toByteArray();
            }
            finally {
                try {
                    decryptedDataStream.close();
                }
                catch (IOException e) {
                    Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.mDecryptedData != null) {
            byte[] decryptedData = new byte[this.mDecryptedData.length];
            System.arraycopy(this.mDecryptedData, 0, decryptedData, 0, this.mDecryptedData.length);
            return decryptedData;
        }
        return null;
    }

    public boolean consumeRights() {
        if (this.mRight == null) {
            return false;
        }
        return this.mRight.consumeRights(this.getPermission());
    }

    public void installRights(byte[] rightData) throws DrmException, IOException {
        if (rightData == null) {
            throw new DrmException("Right data may not be null.");
        }
        ByteArrayInputStream rightDataStream = new ByteArrayInputStream(rightData);
        this.mRight = DrmRightsManager.getInstance().installRights((InputStream)rightDataStream, rightData.length, "application/vnd.oma.drm.message");
    }

    public boolean isRightsInstalled() {
        if (this.mRight != null) {
            return true;
        }
        this.mRight = DrmRightsManager.getInstance().queryRights(this.mDrmObject);
        return this.mRight != null;
    }

    public boolean isAllowedToForward() {
        return 3 == this.mDrmObject.getRawType();
    }

    public String getRightsAddress() {
        if (this.mDrmObject == null) {
            return null;
        }
        return this.mDrmObject.getRightsAddress();
    }

    public String getContentType() {
        return this.mDrmObject.getContentType();
    }

    public Uri getOriginalUri() {
        return this.mDataUri;
    }

    public byte[] getOriginalData() {
        return this.mData;
    }
}

