/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.dom.smil;

import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.smil.Time;

public class TimeImpl
implements Time {
    static final int ALLOW_INDEFINITE_VALUE = 1;
    static final int ALLOW_OFFSET_VALUE = 2;
    static final int ALLOW_SYNCBASE_VALUE = 4;
    static final int ALLOW_SYNCTOPREV_VALUE = 8;
    static final int ALLOW_EVENT_VALUE = 16;
    static final int ALLOW_MARKER_VALUE = 32;
    static final int ALLOW_WALLCLOCK_VALUE = 64;
    static final int ALLOW_NEGATIVE_VALUE = 128;
    static final int ALLOW_ALL = 255;
    short mTimeType;
    boolean mResolved;
    double mResolvedOffset;

    TimeImpl(String timeValue, int constraints) {
        if (timeValue.equals("indefinite") && (constraints & 1) != 0) {
            this.mTimeType = 0;
        } else if ((constraints & 2) != 0) {
            int sign = 1;
            if (timeValue.startsWith("+")) {
                timeValue = timeValue.substring(1);
            } else if (timeValue.startsWith("-")) {
                timeValue = timeValue.substring(1);
                sign = -1;
            }
            this.mResolvedOffset = (double)((float)sign * TimeImpl.parseClockValue(timeValue)) / 1000.0;
            this.mResolved = true;
            this.mTimeType = 1;
        } else {
            throw new IllegalArgumentException("Unsupported time value");
        }
    }

    public static float parseClockValue(String clockValue) {
        try {
            float result = 0.0f;
            clockValue = clockValue.trim();
            if (clockValue.endsWith("ms")) {
                result = TimeImpl.parseFloat(clockValue, 2, true);
            } else if (clockValue.endsWith("s")) {
                result = 1000.0f * TimeImpl.parseFloat(clockValue, 1, true);
            } else if (clockValue.endsWith("min")) {
                result = 60000.0f * TimeImpl.parseFloat(clockValue, 3, true);
            } else if (clockValue.endsWith("h")) {
                result = 3600000.0f * TimeImpl.parseFloat(clockValue, 1, true);
            } else {
                try {
                    return TimeImpl.parseFloat(clockValue, 0, true) * 1000.0f;
                }
                catch (NumberFormatException _) {
                    int indexOfMinutes;
                    String[] timeValues = clockValue.split(":");
                    if (timeValues.length == 2) {
                        indexOfMinutes = 0;
                    } else if (timeValues.length == 3) {
                        result = 3600000 * (int)TimeImpl.parseFloat(timeValues[0], 0, false);
                        indexOfMinutes = 1;
                    } else {
                        throw new IllegalArgumentException();
                    }
                    int minutes = (int)TimeImpl.parseFloat(timeValues[indexOfMinutes], 0, false);
                    if (minutes >= 0 && minutes <= 59) {
                        result += (float)(60000 * minutes);
                    } else {
                        throw new IllegalArgumentException();
                    }
                    float seconds = TimeImpl.parseFloat(timeValues[indexOfMinutes + 1], 0, true);
                    if (seconds >= 0.0f && seconds < 60.0f) {
                        result += 60000.0f * seconds;
                    }
                    throw new IllegalArgumentException();
                }
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException();
        }
    }

    private static float parseFloat(String value, int ignoreLast, boolean parseDecimal) {
        float result;
        int indexOfComma = (value = value.substring(0, value.length() - ignoreLast)).indexOf(46);
        if (indexOfComma != -1) {
            if (!parseDecimal) {
                throw new IllegalArgumentException("int value contains decimal");
            }
            value = value + "000";
            result = Float.parseFloat(value.substring(0, indexOfComma));
            result += Float.parseFloat(value.substring(indexOfComma + 1, indexOfComma + 4)) / 1000.0f;
        } else {
            result = Integer.parseInt(value);
        }
        return result;
    }

    public boolean getBaseBegin() {
        return false;
    }

    public Element getBaseElement() {
        return null;
    }

    public String getEvent() {
        return null;
    }

    public String getMarker() {
        return null;
    }

    public double getOffset() {
        return 0.0;
    }

    public boolean getResolved() {
        return this.mResolved;
    }

    public double getResolvedOffset() {
        return this.mResolvedOffset;
    }

    public short getTimeType() {
        return this.mTimeType;
    }

    public void setBaseBegin(boolean baseBegin) throws DOMException {
    }

    public void setBaseElement(Element baseElement) throws DOMException {
    }

    public void setEvent(String event) throws DOMException {
    }

    public void setMarker(String marker) throws DOMException {
    }

    public void setOffset(double offset) throws DOMException {
    }
}

