/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.data;

import android.text.TextUtils;
import android.util.Log;
import com.android.mms.data.Contact;
import com.android.mms.data.RecipientIdCache;
import com.android.mms.ui.MessageUtils;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactList
extends ArrayList<Contact> {
    private static final long serialVersionUID = 1L;

    public static ContactList getByNumbers(Iterable<String> numbers, boolean canBlock) {
        ContactList list = new ContactList();
        for (String number : numbers) {
            if (TextUtils.isEmpty((CharSequence)number)) continue;
            list.add(Contact.get(number, canBlock));
        }
        return list;
    }

    public static ContactList getByNumbers(String semiSepNumbers, boolean canBlock, boolean replaceNumber) {
        ContactList list = new ContactList();
        for (String number : semiSepNumbers.split(";")) {
            if (TextUtils.isEmpty((CharSequence)number)) continue;
            Contact contact = Contact.get(number, canBlock);
            if (replaceNumber) {
                contact.setNumber(number);
            }
            list.add(contact);
        }
        return list;
    }

    public static ContactList getByIds(String spaceSepIds, boolean canBlock) {
        ContactList list = new ContactList();
        for (RecipientIdCache.Entry entry : RecipientIdCache.getAddresses(spaceSepIds)) {
            if (entry == null || TextUtils.isEmpty((CharSequence)entry.number)) continue;
            Contact contact = Contact.get(entry.number, canBlock);
            contact.setRecipientId(entry.id);
            list.add(contact);
        }
        return list;
    }

    public int getPresenceResId() {
        if (this.size() != 1) {
            return 0;
        }
        return ((Contact)this.get(0)).getPresenceResId();
    }

    public String formatNames(String separator) {
        Object[] names = new String[this.size()];
        int i = 0;
        for (Contact c : this) {
            names[i++] = c.getName();
        }
        return TextUtils.join((CharSequence)separator, (Object[])names);
    }

    public String formatNamesAndNumbers(String separator) {
        Object[] nans = new String[this.size()];
        int i = 0;
        for (Contact c : this) {
            nans[i++] = c.getNameAndNumber();
        }
        return TextUtils.join((CharSequence)separator, (Object[])nans);
    }

    public String serialize() {
        return TextUtils.join((CharSequence)";", (Object[])this.getNumbers());
    }

    public boolean containsEmail() {
        for (Contact c : this) {
            if (!c.isEmail()) continue;
            return true;
        }
        return false;
    }

    public String[] getNumbers() {
        return this.getNumbers(false);
    }

    public String[] getNumbers(boolean scrubForMmsAddress) {
        ArrayList<String> numbers = new ArrayList<String>();
        for (Contact c : this) {
            String number = c.getNumber();
            if (scrubForMmsAddress) {
                number = MessageUtils.parseMmsAddress(number);
            }
            if (TextUtils.isEmpty((CharSequence)number) || numbers.contains(number)) continue;
            numbers.add(number);
        }
        return numbers.toArray(new String[numbers.size()]);
    }

    @Override
    public boolean equals(Object obj) {
        try {
            ContactList other = (ContactList)obj;
            if (this.size() != other.size()) {
                return false;
            }
            for (Contact c : this) {
                if (other.contains(c)) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private void log(String msg) {
        Log.d((String)"Mms", (String)("[ContactList] " + msg));
    }
}

