/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.util.Log;
import com.android.mms.ContentRestrictionException;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MmsConfig {
    private static final String TAG = "MmsConfig";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final String DEFAULT_HTTP_KEY_X_WAP_PROFILE = "x-wap-profile";
    private static final String DEFAULT_USER_AGENT = "Android-Mms/2.0";
    private static final int MAX_IMAGE_HEIGHT = 480;
    private static final int MAX_IMAGE_WIDTH = 640;
    private static final int MAX_TEXT_LENGTH = 2000;
    private static boolean mTransIdEnabled = false;
    private static int mMmsEnabled = 1;
    private static int mMaxMessageSize = 307200;
    private static String mUserAgent = "Android-Mms/2.0";
    private static String mUaProfTagName = "x-wap-profile";
    private static String mUaProfUrl = null;
    private static String mHttpParams = null;
    private static String mHttpParamsLine1Key = null;
    private static String mEmailGateway = null;
    private static int mMaxImageHeight = 480;
    private static int mMaxImageWidth = 640;
    private static int mRecipientLimit = Integer.MAX_VALUE;
    private static int mDefaultSMSMessagesPerThread = 200;
    private static int mDefaultMMSMessagesPerThread = 20;
    private static int mMinMessageCountPerThread = 2;
    private static int mMaxMessageCountPerThread = 5000;
    private static int mHttpSocketTimeout = 60000;
    private static int mMinimumSlideElementDuration = 7;
    private static boolean mNotifyWapMMSC = false;
    private static boolean mAllowAttachAudio = true;
    private static int mSmsToMmsTextThreshold = 4;
    private static boolean mEnableMultipartSMS = true;
    private static boolean mEnableSlideDuration = true;
    private static int mMaxTextLength = -1;
    private static int mMaxSizeScaleForPendingMmsAllowed = 4;
    private static boolean mAliasEnabled = false;
    private static int mAliasRuleMinChars = 2;
    private static int mAliasRuleMaxChars = 48;

    public static void init(Context context) {
        MmsConfig.loadMmsSettings(context);
    }

    public static int getSmsToMmsTextThreshold() {
        return mSmsToMmsTextThreshold;
    }

    public static boolean getMmsEnabled() {
        return mMmsEnabled == 1;
    }

    public static int getMaxMessageSize() {
        return mMaxMessageSize;
    }

    public static boolean getTransIdEnabled() {
        return mTransIdEnabled;
    }

    public static String getUserAgent() {
        return mUserAgent;
    }

    public static String getUaProfTagName() {
        return mUaProfTagName;
    }

    public static String getUaProfUrl() {
        return mUaProfUrl;
    }

    public static String getHttpParams() {
        return mHttpParams;
    }

    public static String getHttpParamsLine1Key() {
        return mHttpParamsLine1Key;
    }

    public static String getEmailGateway() {
        return mEmailGateway;
    }

    public static int getMaxImageHeight() {
        return mMaxImageHeight;
    }

    public static int getMaxImageWidth() {
        return mMaxImageWidth;
    }

    public static int getRecipientLimit() {
        return mRecipientLimit;
    }

    public static int getMaxTextLimit() {
        return mMaxTextLength > -1 ? mMaxTextLength : 2000;
    }

    public static int getDefaultSMSMessagesPerThread() {
        return mDefaultSMSMessagesPerThread;
    }

    public static int getDefaultMMSMessagesPerThread() {
        return mDefaultMMSMessagesPerThread;
    }

    public static int getMinMessageCountPerThread() {
        return mMinMessageCountPerThread;
    }

    public static int getMaxMessageCountPerThread() {
        return mMaxMessageCountPerThread;
    }

    public static int getHttpSocketTimeout() {
        return mHttpSocketTimeout;
    }

    public static int getMinimumSlideElementDuration() {
        return mMinimumSlideElementDuration;
    }

    public static boolean getMultipartSmsEnabled() {
        return mEnableMultipartSMS;
    }

    public static boolean getSlideDurationEnabled() {
        return mEnableSlideDuration;
    }

    public static boolean getNotifyWapMMSC() {
        return mNotifyWapMMSC;
    }

    public static int getMaxSizeScaleForPendingMmsAllowed() {
        return mMaxSizeScaleForPendingMmsAllowed;
    }

    public static boolean isAliasEnabled() {
        return mAliasEnabled;
    }

    public static int getAliasMinChars() {
        return mAliasRuleMinChars;
    }

    public static int getAliasMaxChars() {
        return mAliasRuleMaxChars;
    }

    public static boolean getAllowAttachAudio() {
        return mAllowAttachAudio;
    }

    public static final void beginDocument(XmlPullParser parser, String firstElementName) throws XmlPullParserException, IOException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        if (!parser.getName().equals(firstElementName)) {
            throw new XmlPullParserException("Unexpected start tag: found " + parser.getName() + ", expected " + firstElementName);
        }
    }

    public static final void nextElement(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMmsSettings(Context context) {
        XmlResourceParser parser = context.getResources().getXml(2130968576);
        try {
            MmsConfig.beginDocument((XmlPullParser)parser, "mms_config");
            while (true) {
                MmsConfig.nextElement((XmlPullParser)parser);
                String tag = parser.getName();
                if (tag == null) {
                    break;
                }
                String name = parser.getAttributeName(0);
                String value = parser.getAttributeValue(0);
                String text = null;
                if (parser.next() == 4) {
                    text = parser.getText();
                }
                if (!"name".equalsIgnoreCase(name)) continue;
                if ("bool".equals(tag)) {
                    if ("enabledMMS".equalsIgnoreCase(value)) {
                        mMmsEnabled = "true".equalsIgnoreCase(text) ? 1 : 0;
                        continue;
                    }
                    if ("enabledTransID".equalsIgnoreCase(value)) {
                        mTransIdEnabled = "true".equalsIgnoreCase(text);
                        continue;
                    }
                    if ("enabledNotifyWapMMSC".equalsIgnoreCase(value)) {
                        mNotifyWapMMSC = "true".equalsIgnoreCase(text);
                        continue;
                    }
                    if ("aliasEnabled".equalsIgnoreCase(value)) {
                        mAliasEnabled = "true".equalsIgnoreCase(text);
                        continue;
                    }
                    if ("allowAttachAudio".equalsIgnoreCase(value)) {
                        mAllowAttachAudio = "true".equalsIgnoreCase(text);
                        continue;
                    }
                    if ("enableMultipartSMS".equalsIgnoreCase(value)) {
                        mEnableMultipartSMS = "true".equalsIgnoreCase(text);
                        continue;
                    }
                    if (!"enableSlideDuration".equalsIgnoreCase(value)) continue;
                    mEnableSlideDuration = "true".equalsIgnoreCase(text);
                    continue;
                }
                if ("int".equals(tag)) {
                    if ("maxMessageSize".equalsIgnoreCase(value)) {
                        mMaxMessageSize = Integer.parseInt(text);
                        continue;
                    }
                    if ("maxImageHeight".equalsIgnoreCase(value)) {
                        mMaxImageHeight = Integer.parseInt(text);
                        continue;
                    }
                    if ("maxImageWidth".equalsIgnoreCase(value)) {
                        mMaxImageWidth = Integer.parseInt(text);
                        continue;
                    }
                    if ("defaultSMSMessagesPerThread".equalsIgnoreCase(value)) {
                        mDefaultSMSMessagesPerThread = Integer.parseInt(text);
                        continue;
                    }
                    if ("defaultMMSMessagesPerThread".equalsIgnoreCase(value)) {
                        mDefaultMMSMessagesPerThread = Integer.parseInt(text);
                        continue;
                    }
                    if ("minMessageCountPerThread".equalsIgnoreCase(value)) {
                        mMinMessageCountPerThread = Integer.parseInt(text);
                        continue;
                    }
                    if ("maxMessageCountPerThread".equalsIgnoreCase(value)) {
                        mMaxMessageCountPerThread = Integer.parseInt(text);
                        continue;
                    }
                    if ("recipientLimit".equalsIgnoreCase(value)) {
                        mRecipientLimit = Integer.parseInt(text);
                        if (mRecipientLimit >= 0) continue;
                        mRecipientLimit = Integer.MAX_VALUE;
                        continue;
                    }
                    if ("httpSocketTimeout".equalsIgnoreCase(value)) {
                        mHttpSocketTimeout = Integer.parseInt(text);
                        continue;
                    }
                    if ("minimumSlideElementDuration".equalsIgnoreCase(value)) {
                        mMinimumSlideElementDuration = Integer.parseInt(text);
                        continue;
                    }
                    if ("maxSizeScaleForPendingMmsAllowed".equalsIgnoreCase(value)) {
                        mMaxSizeScaleForPendingMmsAllowed = Integer.parseInt(text);
                        continue;
                    }
                    if ("aliasMinChars".equalsIgnoreCase(value)) {
                        mAliasRuleMinChars = Integer.parseInt(text);
                        continue;
                    }
                    if ("aliasMaxChars".equalsIgnoreCase(value)) {
                        mAliasRuleMaxChars = Integer.parseInt(text);
                        continue;
                    }
                    if ("smsToMmsTextThreshold".equalsIgnoreCase(value)) {
                        mSmsToMmsTextThreshold = Integer.parseInt(text);
                        continue;
                    }
                    if (!"maxMessageTextSize".equalsIgnoreCase(value)) continue;
                    mMaxTextLength = Integer.parseInt(text);
                    continue;
                }
                if (!"string".equals(tag)) continue;
                if ("userAgent".equalsIgnoreCase(value)) {
                    mUserAgent = text;
                    continue;
                }
                if ("uaProfTagName".equalsIgnoreCase(value)) {
                    mUaProfTagName = text;
                    continue;
                }
                if ("uaProfUrl".equalsIgnoreCase(value)) {
                    mUaProfUrl = text;
                    continue;
                }
                if ("httpParams".equalsIgnoreCase(value)) {
                    mHttpParams = text;
                    continue;
                }
                if ("httpParamsLine1Key".equalsIgnoreCase(value)) {
                    mHttpParamsLine1Key = text;
                    continue;
                }
                if (!"emailGatewayNumber".equalsIgnoreCase(value)) continue;
                mEmailGateway = text;
            }
        }
        catch (XmlPullParserException e) {
            Log.e((String)TAG, (String)"loadMmsSettings caught ", (Throwable)e);
        }
        catch (NumberFormatException e) {
            Log.e((String)TAG, (String)"loadMmsSettings caught ", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"loadMmsSettings caught ", (Throwable)e);
        }
        finally {
            parser.close();
        }
        String errorStr = null;
        if (MmsConfig.getMmsEnabled() && mUaProfUrl == null) {
            errorStr = "uaProfUrl";
        }
        if (errorStr != null) {
            String err = String.format("MmsConfig.loadMmsSettings mms_config.xml missing %s setting", errorStr);
            Log.e((String)TAG, (String)err);
            throw new ContentRestrictionException(err);
        }
    }
}

