/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms;

import android.app.Activity;
import android.util.Log;

public class LogTag {
    public static final String TAG = "Mms";
    public static final String TRANSACTION = "Mms:transaction";
    public static final String APP = "Mms:app";
    public static final String THREAD_CACHE = "Mms:threadcache";
    public static final boolean VERBOSE = false;
    public static final boolean SEVERE_WARNING = true;
    private static final boolean SHOW_SEVERE_WARNING_DIALOG = false;

    private static String prettyArray(String[] array2) {
        if (array2.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        int len = array2.length - 1;
        for (int i = 0; i < len; ++i) {
            sb.append(array2[i]);
            sb.append(", ");
        }
        sb.append(array2[len]);
        sb.append("]");
        return sb.toString();
    }

    private static String logFormat(String format, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof String[])) continue;
            args[i] = LogTag.prettyArray((String[])args[i]);
        }
        String s = String.format(format, args);
        s = "[" + Thread.currentThread().getId() + "] " + s;
        return s;
    }

    public static void debug(String format, Object ... args) {
        Log.d((String)TAG, (String)LogTag.logFormat(format, args));
    }

    public static void warn(String format, Object ... args) {
        Log.w((String)TAG, (String)LogTag.logFormat(format, args));
    }

    public static void error(String format, Object ... args) {
        Log.e((String)TAG, (String)LogTag.logFormat(format, args));
    }

    public static void warnPossibleRecipientMismatch(String msg, Activity activity) {
        Log.e((String)TAG, (String)("WARNING!!!! " + msg));
    }
}

