/*
 * Decompiled with CFR 0.152.
 */
package com.android.wallpaper.walkaround;

import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.hardware.Camera;
import android.service.wallpaper.WallpaperService;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.SurfaceHolder;
import java.io.IOException;
import java.util.List;

public class WalkAroundWallpaper
extends WallpaperService {
    private Camera mCamera;
    private WalkAroundEngine mOwner;

    public WallpaperService.Engine onCreateEngine() {
        this.mOwner = new WalkAroundEngine();
        return this.mOwner;
    }

    public void onDestroy() {
        super.onDestroy();
        this.stopCamera();
    }

    public void onCreate() {
        super.onCreate();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mCamera != null && this.mCamera.previewEnabled()) {
            boolean portrait = newConfig.orientation == 1;
            Camera.Parameters params = this.mCamera.getParameters();
            params.set("orientation", portrait ? "portrait" : "landscape");
            this.mCamera.setParameters(params);
            if (this.mCamera.previewEnabled()) {
                this.mCamera.stopPreview();
            }
            this.mCamera.startPreview();
        }
    }

    private void startCamera() {
        if (this.mCamera == null) {
            this.mCamera = Camera.open();
        } else {
            try {
                this.mCamera.reconnect();
            }
            catch (IOException e) {
                this.mCamera.release();
                this.mCamera = null;
                Log.e((String)"WalkAround", (String)"Error opening the camera", (Throwable)e);
            }
        }
    }

    private void stopCamera() {
        if (this.mCamera != null) {
            try {
                this.mCamera.stopPreview();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.mCamera.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mCamera = null;
        }
    }

    class WalkAroundEngine
    extends WallpaperService.Engine {
        private SurfaceHolder mHolder;

        WalkAroundEngine() {
            super((WallpaperService)WalkAroundWallpaper.this);
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            super.onCreate(surfaceHolder);
            surfaceHolder.setType(3);
            this.mHolder = surfaceHolder;
        }

        public void onVisibilityChanged(boolean visible) {
            if (!visible) {
                if (WalkAroundWallpaper.this.mOwner == this) {
                    WalkAroundWallpaper.this.stopCamera();
                }
            } else {
                try {
                    WalkAroundWallpaper.this.startCamera();
                    WalkAroundWallpaper.this.mCamera.setPreviewDisplay(this.mHolder);
                    this.startPreview();
                }
                catch (IOException e) {
                    WalkAroundWallpaper.this.mCamera.release();
                    WalkAroundWallpaper.this.mCamera = null;
                    Log.e((String)"WalkAround", (String)"Error opening the camera", (Throwable)e);
                }
            }
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            super.onSurfaceChanged(holder, format, width, height);
            if (holder.isCreating()) {
                try {
                    if (WalkAroundWallpaper.this.mCamera.previewEnabled()) {
                        WalkAroundWallpaper.this.mCamera.stopPreview();
                    }
                    WalkAroundWallpaper.this.mCamera.setPreviewDisplay(holder);
                }
                catch (IOException e) {
                    WalkAroundWallpaper.this.mCamera.release();
                    WalkAroundWallpaper.this.mCamera = null;
                    Log.e((String)"WalkAround", (String)"Error opening the camera", (Throwable)e);
                }
            }
            if (this.isVisible()) {
                this.startPreview();
            }
        }

        public void onSurfaceCreated(SurfaceHolder holder) {
            super.onSurfaceCreated(holder);
            WalkAroundWallpaper.this.startCamera();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startPreview() {
            Resources resources = WalkAroundWallpaper.this.getResources();
            boolean portrait = resources.getConfiguration().orientation == 1;
            Camera.Parameters params = WalkAroundWallpaper.this.mCamera.getParameters();
            DisplayMetrics metrics = resources.getDisplayMetrics();
            List sizes = params.getSupportedPreviewSizes();
            boolean found = false;
            for (Camera.Size size : sizes) {
                if ((!portrait || size.width != metrics.heightPixels || size.height != metrics.widthPixels) && (portrait || size.width != metrics.widthPixels || size.height != metrics.heightPixels)) continue;
                params.setPreviewSize(size.width, size.height);
                found = true;
            }
            if (!found) {
                for (Camera.Size size : sizes) {
                    if (size.width < metrics.widthPixels || size.height < metrics.heightPixels) continue;
                    params.setPreviewSize(size.width, size.height);
                    found = true;
                }
            }
            if (!found) {
                Camera.Size size;
                Canvas canvas = null;
                try {
                    canvas = this.mHolder.lockCanvas();
                    if (canvas != null) {
                        canvas.drawColor(0);
                    }
                }
                finally {
                    if (canvas != null) {
                        this.mHolder.unlockCanvasAndPost(canvas);
                    }
                }
                size = (Camera.Size)sizes.get(0);
                params.setPreviewSize(size.width, size.height);
            }
            params.set("orientation", portrait ? "portrait" : "landscape");
            WalkAroundWallpaper.this.mCamera.setParameters(params);
            WalkAroundWallpaper.this.mCamera.startPreview();
        }
    }
}

