/*
 * Decompiled with CFR 0.152.
 */
package com.android.wallpaper.polarclock;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.service.wallpaper.WallpaperService;
import android.text.format.Time;
import android.util.Log;
import android.util.MathUtils;
import android.view.SurfaceHolder;
import java.io.IOException;
import java.util.HashMap;
import java.util.TimeZone;
import org.xmlpull.v1.XmlPullParserException;

public class PolarClockWallpaper
extends WallpaperService {
    private final Handler mHandler = new Handler();
    private IntentFilter mFilter;

    public void onCreate() {
        super.onCreate();
        this.mFilter = new IntentFilter();
        this.mFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public WallpaperService.Engine onCreateEngine() {
        return new ClockEngine();
    }

    class ClockEngine
    extends WallpaperService.Engine
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private final HashMap<String, ClockPalette> mPalettes;
        private ClockPalette mPalette;
        private SharedPreferences mPrefs;
        private boolean mShowSeconds;
        private boolean mVariableLineWidth;
        private boolean mWatcherRegistered;
        private Time mCalendar;
        private final Paint mPaint;
        private final RectF mRect;
        private float mOffsetX;
        private final BroadcastReceiver mWatcher;
        private final Runnable mDrawClock;
        private boolean mVisible;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClockEngine() {
            super((WallpaperService)PolarClockWallpaper.this);
            this.mPalettes = new HashMap();
            this.mPaint = new Paint();
            this.mRect = new RectF();
            this.mWatcher = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    String timeZone = intent.getStringExtra("time-zone");
                    ClockEngine.this.mCalendar = new Time(TimeZone.getTimeZone(timeZone).getID());
                    ClockEngine.this.drawFrame();
                }
            };
            this.mDrawClock = new Runnable(){

                public void run() {
                    ClockEngine.this.drawFrame();
                }
            };
            XmlResourceParser xrp = PolarClockWallpaper.this.getResources().getXml(2130903045);
            try {
                int what = xrp.getEventType();
                while (what != 1) {
                    ClockPalette pal;
                    if (what == 2 && "palette".equals(xrp.getName()) && (pal = ClockPalette.parseXmlPaletteTag(xrp)).getId() != null) {
                        this.mPalettes.put(pal.getId(), pal);
                    }
                    what = xrp.next();
                }
            }
            catch (IOException e) {
                Log.e((String)"PolarClock", (String)"An error occured during wallpaper configuration:", (Throwable)e);
            }
            catch (XmlPullParserException e) {
                Log.e((String)"PolarClock", (String)"An error occured during wallpaper configuration:", (Throwable)e);
            }
            finally {
                xrp.close();
            }
            this.mPalette = CyclingClockPalette.getFallback();
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            super.onCreate(surfaceHolder);
            this.mPrefs = PolarClockWallpaper.this.getSharedPreferences("polar_clock_settings", 0);
            this.mPrefs.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
            this.onSharedPreferenceChanged(this.mPrefs, null);
            this.mCalendar = new Time();
            this.mCalendar.setToNow();
            Paint paint = this.mPaint;
            paint.setAntiAlias(true);
            paint.setStrokeWidth(24.0f);
            paint.setStrokeCap(Paint.Cap.ROUND);
            paint.setStyle(Paint.Style.STROKE);
            if (this.isPreview()) {
                this.mOffsetX = 0.5f;
            }
        }

        public void onDestroy() {
            super.onDestroy();
            if (this.mWatcherRegistered) {
                this.mWatcherRegistered = false;
                PolarClockWallpaper.this.unregisterReceiver(this.mWatcher);
            }
            PolarClockWallpaper.this.mHandler.removeCallbacks(this.mDrawClock);
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            String paletteId;
            ClockPalette pal;
            boolean changed = false;
            if (key == null || "show_seconds".equals(key)) {
                this.mShowSeconds = sharedPreferences.getBoolean("show_seconds", true);
                changed = true;
            }
            if (key == null || "variable_line_width".equals(key)) {
                this.mVariableLineWidth = sharedPreferences.getBoolean("variable_line_width", true);
                changed = true;
            }
            if ((key == null || "palette".equals(key)) && (pal = this.mPalettes.get(paletteId = sharedPreferences.getString("palette", ""))) != null) {
                this.mPalette = pal;
                changed = true;
            }
            if (this.mVisible && changed) {
                this.drawFrame();
            }
        }

        public void onVisibilityChanged(boolean visible) {
            this.mVisible = visible;
            if (visible) {
                if (!this.mWatcherRegistered) {
                    this.mWatcherRegistered = true;
                    PolarClockWallpaper.this.registerReceiver(this.mWatcher, PolarClockWallpaper.this.mFilter, null, PolarClockWallpaper.this.mHandler);
                }
                this.mCalendar = new Time();
                this.mCalendar.setToNow();
            } else {
                if (this.mWatcherRegistered) {
                    this.mWatcherRegistered = false;
                    PolarClockWallpaper.this.unregisterReceiver(this.mWatcher);
                }
                PolarClockWallpaper.this.mHandler.removeCallbacks(this.mDrawClock);
            }
            this.drawFrame();
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            super.onSurfaceChanged(holder, format, width, height);
            this.drawFrame();
        }

        public void onSurfaceCreated(SurfaceHolder holder) {
            super.onSurfaceCreated(holder);
        }

        public void onSurfaceDestroyed(SurfaceHolder holder) {
            super.onSurfaceDestroyed(holder);
            this.mVisible = false;
            PolarClockWallpaper.this.mHandler.removeCallbacks(this.mDrawClock);
        }

        public void onOffsetsChanged(float xOffset, float yOffset, float xStep, float yStep, int xPixels, int yPixels) {
            if (this.isPreview()) {
                return;
            }
            this.mOffsetX = xOffset;
            this.drawFrame();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drawFrame() {
            if (this.mPalette == null) {
                Log.w((String)"PolarClockWallpaper", (String)"no palette?!");
                return;
            }
            SurfaceHolder holder = this.getSurfaceHolder();
            Rect frame = holder.getSurfaceFrame();
            int width = frame.width();
            int height = frame.height();
            Canvas c = null;
            try {
                c = holder.lockCanvas();
                if (c != null) {
                    float angle;
                    Time calendar = this.mCalendar;
                    Paint paint = this.mPaint;
                    long millis = System.currentTimeMillis();
                    calendar.set(millis);
                    calendar.normalize(false);
                    int s = width / 2;
                    int t = height / 2;
                    c.drawColor(this.mPalette.getBackgroundColor());
                    c.translate((float)s + MathUtils.lerp((float)s, (float)(-s), (float)this.mOffsetX), (float)t);
                    c.rotate(-90.0f);
                    if (height < width) {
                        c.scale(0.9f, 0.9f);
                    }
                    float size = (float)Math.min(width, height) * 0.5f - 24.0f;
                    RectF rect = this.mRect;
                    rect.set(-size, -size, size, size);
                    float lastRingThickness = 24.0f;
                    if (this.mShowSeconds) {
                        angle = (float)(millis % 60000L) / 60000.0f;
                        paint.setColor(this.mPalette.getSecondColor(angle));
                        if (this.mVariableLineWidth) {
                            lastRingThickness = 8.0f;
                            paint.setStrokeWidth(lastRingThickness);
                        }
                        c.drawArc(rect, 0.0f, angle * 360.0f, false, paint);
                    }
                    rect.set(-(size -= 14.0f + lastRingThickness), -size, size, size);
                    angle = ((float)calendar.minute * 60.0f + (float)calendar.second) % 3600.0f / 3600.0f;
                    paint.setColor(this.mPalette.getMinuteColor(angle));
                    if (this.mVariableLineWidth) {
                        lastRingThickness = 16.0f;
                        paint.setStrokeWidth(lastRingThickness);
                    }
                    c.drawArc(rect, 0.0f, angle * 360.0f, false, paint);
                    rect.set(-(size -= 14.0f + lastRingThickness), -size, size, size);
                    angle = ((float)calendar.hour * 60.0f + (float)calendar.minute) % 1440.0f / 1440.0f;
                    paint.setColor(this.mPalette.getHourColor(angle));
                    if (this.mVariableLineWidth) {
                        lastRingThickness = 32.0f;
                        paint.setStrokeWidth(lastRingThickness);
                    }
                    c.drawArc(rect, 0.0f, angle * 360.0f, false, paint);
                    rect.set(-(size -= 38.0f + lastRingThickness), -size, size, size);
                    angle = (float)(calendar.monthDay - 1) / (float)(calendar.getActualMaximum(4) - 1);
                    paint.setColor(this.mPalette.getDayColor(angle));
                    if (this.mVariableLineWidth) {
                        lastRingThickness = 16.0f;
                        paint.setStrokeWidth(lastRingThickness);
                    }
                    c.drawArc(rect, 0.0f, angle * 360.0f, false, paint);
                    rect.set(-(size -= 14.0f + lastRingThickness), -size, size, size);
                    angle = (float)calendar.month / 11.0f;
                    paint.setColor(this.mPalette.getMonthColor(angle));
                    if (this.mVariableLineWidth) {
                        lastRingThickness = 32.0f;
                        paint.setStrokeWidth(lastRingThickness);
                    }
                    c.drawArc(rect, 0.0f, angle * 360.0f, false, paint);
                }
            }
            finally {
                if (c != null) {
                    holder.unlockCanvasAndPost(c);
                }
            }
            PolarClockWallpaper.this.mHandler.removeCallbacks(this.mDrawClock);
            if (this.mVisible) {
                if (this.mShowSeconds) {
                    PolarClockWallpaper.this.mHandler.postDelayed(this.mDrawClock, 40L);
                } else {
                    PolarClockWallpaper.this.mHandler.postDelayed(this.mDrawClock, 2000L);
                }
            }
        }
    }

    static class CyclingClockPalette
    extends ClockPalette {
        protected String mId;
        protected int mBackgroundColor;
        protected float mSaturation;
        protected float mBrightness;
        private final int[] mColors = new int[720];
        private static CyclingClockPalette sFallbackPalette = null;

        public static CyclingClockPalette getFallback() {
            if (sFallbackPalette == null) {
                sFallbackPalette = new CyclingClockPalette();
                CyclingClockPalette.sFallbackPalette.mId = "default_c";
                CyclingClockPalette.sFallbackPalette.mBackgroundColor = -1;
                CyclingClockPalette.sFallbackPalette.mSaturation = 0.8f;
                CyclingClockPalette.sFallbackPalette.mBrightness = 0.9f;
                sFallbackPalette.computeIntermediateColors();
            }
            return sFallbackPalette;
        }

        private CyclingClockPalette() {
        }

        private void computeIntermediateColors() {
            int[] colors = this.mColors;
            int count = colors.length;
            float invCount = 0.0013888889f;
            for (int i = 0; i < count; ++i) {
                colors[i] = Color.HSBtoColor((float)((float)i * invCount), (float)this.mSaturation, (float)this.mBrightness);
            }
        }

        public static ClockPalette parseXmlPaletteTag(XmlResourceParser xrp) {
            CyclingClockPalette pal = new CyclingClockPalette();
            pal.mId = xrp.getAttributeValue(null, "id");
            String val = xrp.getAttributeValue(null, "background");
            if (val != null) {
                pal.mBackgroundColor = Color.parseColor((String)val);
            }
            if ((val = xrp.getAttributeValue(null, "saturation")) != null) {
                pal.mSaturation = Float.parseFloat(val);
            }
            if ((val = xrp.getAttributeValue(null, "brightness")) != null) {
                pal.mBrightness = Float.parseFloat(val);
            }
            if (pal.mId == null) {
                return null;
            }
            pal.computeIntermediateColors();
            return pal;
        }

        public int getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public int getSecondColor(float forAngle) {
            if (forAngle >= 1.0f || forAngle < 0.0f) {
                forAngle = 0.0f;
            }
            return this.mColors[(int)(forAngle * 720.0f)];
        }

        public int getMinuteColor(float forAngle) {
            if (forAngle >= 1.0f || forAngle < 0.0f) {
                forAngle = 0.0f;
            }
            return this.mColors[(int)(forAngle * 720.0f)];
        }

        public int getHourColor(float forAngle) {
            if (forAngle >= 1.0f || forAngle < 0.0f) {
                forAngle = 0.0f;
            }
            return this.mColors[(int)(forAngle * 720.0f)];
        }

        public int getDayColor(float forAngle) {
            if (forAngle >= 1.0f || forAngle < 0.0f) {
                forAngle = 0.0f;
            }
            return this.mColors[(int)(forAngle * 720.0f)];
        }

        public int getMonthColor(float forAngle) {
            if (forAngle >= 1.0f || forAngle < 0.0f) {
                forAngle = 0.0f;
            }
            return this.mColors[(int)(forAngle * 720.0f)];
        }

        public String getId() {
            return this.mId;
        }
    }

    static class FixedClockPalette
    extends ClockPalette {
        protected String mId;
        protected int mBackgroundColor;
        protected int mSecondColor;
        protected int mMinuteColor;
        protected int mHourColor;
        protected int mDayColor;
        protected int mMonthColor;
        private static FixedClockPalette sFallbackPalette = null;

        private FixedClockPalette() {
        }

        public static ClockPalette parseXmlPaletteTag(XmlResourceParser xrp) {
            FixedClockPalette pal = new FixedClockPalette();
            pal.mId = xrp.getAttributeValue(null, "id");
            String val = xrp.getAttributeValue(null, "background");
            if (val != null) {
                pal.mBackgroundColor = Color.parseColor((String)val);
            }
            if ((val = xrp.getAttributeValue(null, "second")) != null) {
                pal.mSecondColor = Color.parseColor((String)val);
            }
            if ((val = xrp.getAttributeValue(null, "minute")) != null) {
                pal.mMinuteColor = Color.parseColor((String)val);
            }
            if ((val = xrp.getAttributeValue(null, "hour")) != null) {
                pal.mHourColor = Color.parseColor((String)val);
            }
            if ((val = xrp.getAttributeValue(null, "day")) != null) {
                pal.mDayColor = Color.parseColor((String)val);
            }
            if ((val = xrp.getAttributeValue(null, "month")) != null) {
                pal.mMonthColor = Color.parseColor((String)val);
            }
            return pal.mId == null ? null : pal;
        }

        public int getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public int getSecondColor(float forAngle) {
            return this.mSecondColor;
        }

        public int getMinuteColor(float forAngle) {
            return this.mMinuteColor;
        }

        public int getHourColor(float forAngle) {
            return this.mHourColor;
        }

        public int getDayColor(float forAngle) {
            return this.mDayColor;
        }

        public int getMonthColor(float forAngle) {
            return this.mMonthColor;
        }

        public String getId() {
            return this.mId;
        }
    }

    static abstract class ClockPalette {
        ClockPalette() {
        }

        public static ClockPalette parseXmlPaletteTag(XmlResourceParser xrp) {
            String kind = xrp.getAttributeValue(null, "kind");
            if ("cycling".equals(kind)) {
                return CyclingClockPalette.parseXmlPaletteTag(xrp);
            }
            return FixedClockPalette.parseXmlPaletteTag(xrp);
        }

        public abstract int getBackgroundColor();

        public abstract int getSecondColor(float var1);

        public abstract int getMinuteColor(float var1);

        public abstract int getHourColor(float var1);

        public abstract int getDayColor(float var1);

        public abstract int getMonthColor(float var1);

        public abstract String getId();
    }
}

