/*
 * Decompiled with CFR 0.152.
 */
package com.android.wallpaper.nexus;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramStore;
import android.renderscript.ProgramVertex;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.Script;
import android.renderscript.ScriptC;
import android.renderscript.Type;
import com.android.wallpaper.RenderScriptScene;
import java.util.TimeZone;

class NexusRS
extends RenderScriptScene {
    private final BitmapFactory.Options mOptionsARGB = new BitmapFactory.Options();
    private ProgramFragment mPfTexture;
    private ProgramFragment mPfTexture565;
    private ProgramFragment mPfColor;
    private ProgramStore mPsSolid;
    private ProgramStore mPsBlend;
    private ProgramVertex mPvOrtho;
    private ProgramVertex.MatrixAllocation mPvOrthoAlloc;
    private Sampler mClampSampler;
    private Sampler mWrapSampler;
    private Allocation mState;
    private Type mStateType;
    private WorldState mWorldState;
    private Allocation mCommandAllocation;
    private Type mCommandType;
    private CommandState mCommand;
    private Allocation[] mTextures = new Allocation[4];

    public NexusRS(int width, int height) {
        super(width, height);
        this.mOptionsARGB.inScaled = false;
        this.mOptionsARGB.inPreferredConfig = Bitmap.Config.ARGB_8888;
    }

    public void setOffset(float xOffset, float yOffset, int xPixels, int yPixels) {
        this.mWorldState.xOffset = xOffset;
        this.mState.data((Object)this.mWorldState);
    }

    public void start() {
        super.start();
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.mWorldState.width = width;
        this.mWorldState.height = height;
        this.mWorldState.rotate = width > height ? 1 : 0;
        this.mState.data((Object)this.mWorldState);
        this.mPvOrthoAlloc.setupOrthoWindow(this.mWidth, this.mHeight);
    }

    protected ScriptC createScript() {
        this.createProgramVertex();
        this.createProgramFragmentStore();
        this.createProgramFragment();
        this.createState();
        this.loadTextures();
        ScriptC.Builder sb = new ScriptC.Builder((RenderScript)this.mRS);
        sb.setType(this.mStateType, "State", 0);
        sb.setType(this.mCommandType, "Command", 1);
        sb.setScript(this.mResources, 2130968580);
        Script.Invokable invokable = sb.addInvokable("initPulses");
        sb.setRoot(true);
        ScriptC script = sb.create();
        script.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        script.setTimeZone(TimeZone.getDefault().getID());
        script.bindAllocation(this.mState, 0);
        script.bindAllocation(this.mCommandAllocation, 1);
        invokable.execute();
        return script;
    }

    private void createState() {
        this.mWorldState = new WorldState();
        this.mWorldState.width = this.mWidth;
        this.mWorldState.height = this.mHeight;
        this.mWorldState.rotate = this.mWidth > this.mHeight ? 1 : 0;
        this.mWorldState.isPreview = this.isPreview() ? 1 : 0;
        try {
            this.mWorldState.mode = this.mResources.getInteger(2131099648);
        }
        catch (Resources.NotFoundException notFoundException) {
            this.mWorldState.mode = 0;
        }
        this.mStateType = Type.createFromClass((RenderScript)this.mRS, WorldState.class, (int)1, (String)"WorldState");
        this.mState = Allocation.createTyped((RenderScript)this.mRS, (Type)this.mStateType);
        this.mState.data((Object)this.mWorldState);
        this.mCommand = new CommandState();
        this.mCommand.x = -1;
        this.mCommand.y = -1;
        this.mCommand.command = 0;
        this.mCommandType = Type.createFromClass((RenderScript)this.mRS, CommandState.class, (int)1, (String)"DropState");
        this.mCommandAllocation = Allocation.createTyped((RenderScript)this.mRS, (Type)this.mCommandType);
        this.mCommandAllocation.data((Object)this.mCommand);
    }

    private void loadTextures() {
        this.mTextures[0] = this.loadTextureARGB(2130837521, "TBackground");
        this.mTextures[1] = this.loadTextureARGB(2130837519, "TPulse");
        this.mTextures[2] = this.loadTextureARGB(2130837520, "TPulseVert");
        this.mTextures[3] = this.loadTextureARGB(2130837506, "TGlow");
        int count = this.mTextures.length;
        for (int i = 0; i < count; ++i) {
            this.mTextures[i].uploadToTexture(0);
        }
    }

    private Allocation loadTextureARGB(int id, String name) {
        Bitmap b = BitmapFactory.decodeResource((Resources)this.mResources, (int)id, (BitmapFactory.Options)this.mOptionsARGB);
        Allocation allocation = Allocation.createFromBitmap((RenderScript)this.mRS, (Bitmap)b, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)false);
        allocation.setName(name);
        return allocation;
    }

    private void createProgramFragment() {
        Sampler.Builder sampleBuilder = new Sampler.Builder((RenderScript)this.mRS);
        sampleBuilder.setMin(Sampler.Value.LINEAR);
        sampleBuilder.setMag(Sampler.Value.LINEAR);
        sampleBuilder.setWrapS(Sampler.Value.CLAMP);
        sampleBuilder.setWrapT(Sampler.Value.CLAMP);
        this.mWrapSampler = sampleBuilder.create();
        ProgramFragment.Builder builder = new ProgramFragment.Builder((RenderScript)this.mRS);
        builder.setTexture(ProgramFragment.Builder.EnvMode.MODULATE, ProgramFragment.Builder.Format.RGBA, 0);
        this.mPfTexture = builder.create();
        this.mPfTexture.setName("PFTexture");
        this.mPfTexture.bindSampler(this.mWrapSampler, 0);
        builder = new ProgramFragment.Builder((RenderScript)this.mRS);
        this.mPfColor = builder.create();
        this.mPfColor.setName("PFColor");
        this.mPfColor.bindSampler(this.mWrapSampler, 0);
        sampleBuilder.setWrapS(Sampler.Value.CLAMP);
        sampleBuilder.setWrapT(Sampler.Value.CLAMP);
        this.mClampSampler = sampleBuilder.create();
        builder = new ProgramFragment.Builder((RenderScript)this.mRS);
        builder.setTexture(ProgramFragment.Builder.EnvMode.MODULATE, ProgramFragment.Builder.Format.RGB, 0);
        this.mPfTexture565 = builder.create();
        this.mPfTexture565.setName("PFTextureBG");
        this.mPfTexture565.bindSampler(this.mClampSampler, 0);
    }

    private void createProgramFragmentStore() {
        ProgramStore.Builder builder = new ProgramStore.Builder((RenderScript)this.mRS, null, null);
        builder.setDepthFunc(ProgramStore.DepthFunc.ALWAYS);
        builder.setBlendFunc(ProgramStore.BlendSrcFunc.ONE, ProgramStore.BlendDstFunc.ONE);
        builder.setDitherEnable(false);
        builder.setDepthMask(true);
        this.mPsSolid = builder.create();
        this.mPsSolid.setName("PSSolid");
        builder = new ProgramStore.Builder((RenderScript)this.mRS, null, null);
        builder.setDepthFunc(ProgramStore.DepthFunc.ALWAYS);
        builder.setBlendFunc(ProgramStore.BlendSrcFunc.SRC_ALPHA, ProgramStore.BlendDstFunc.ONE);
        builder.setDitherEnable(false);
        builder.setDepthMask(true);
        this.mPsBlend = builder.create();
        this.mPsBlend.setName("PSBlend");
    }

    private void createProgramVertex() {
        this.mPvOrthoAlloc = new ProgramVertex.MatrixAllocation((RenderScript)this.mRS);
        this.mPvOrthoAlloc.setupOrthoWindow(this.mWidth, this.mHeight);
        ProgramVertex.Builder pvb = new ProgramVertex.Builder((RenderScript)this.mRS, null, null);
        pvb.setTextureMatrixEnable(true);
        this.mPvOrtho = pvb.create();
        this.mPvOrtho.bindAllocation(this.mPvOrthoAlloc);
        this.mPvOrtho.setName("PVOrtho");
    }

    public Bundle onCommand(String action, int x, int y, int z, Bundle extras, boolean resultRequested) {
        int dw = this.mWorldState.width;
        int bw = 960;
        if (this.mWorldState.rotate == 0) {
            x = (int)((float)x + this.mWorldState.xOffset * (float)(960 - dw));
        }
        if ("android.wallpaper.tap".equals(action)) {
            this.sendCommand(1, x, y);
        } else if ("android.home.drop".equals(action)) {
            this.sendCommand(2, x, y);
        }
        return null;
    }

    private void sendCommand(int command, int x, int y) {
        this.mCommand.x = x;
        this.mCommand.y = y;
        this.mCommand.command = command;
        this.mCommandAllocation.data((Object)this.mCommand);
    }

    static class CommandState {
        public int x;
        public int y;
        public int command;

        CommandState() {
        }
    }

    static class WorldState {
        public int width;
        public int height;
        public float glWidth;
        public float glHeight;
        public int rotate;
        public int isPreview;
        public float xOffset;
        public int mode;

        WorldState() {
        }
    }
}

