/*
 * Decompiled with CFR 0.152.
 */
package com.android.wallpaper.grass;

import android.location.Location;
import java.util.Calendar;
import java.util.TimeZone;

class SunCalculator {
    private Location mLocation;
    private TimeZone mTimeZone;

    SunCalculator(Location location, String timeZoneIdentifier) {
        this.mLocation = location;
        this.mTimeZone = TimeZone.getTimeZone(timeZoneIdentifier);
    }

    public double computeSunriseTime(double solarZenith, Calendar date) {
        return this.computeSolarEventTime(solarZenith, date, true);
    }

    public double computeSunsetTime(double solarZenith, Calendar date) {
        return this.computeSolarEventTime(solarZenith, date, false);
    }

    public static float timeToDayFraction(double time) {
        int hour = (int)Math.floor(time);
        int minute = (int)Math.round((time - (double)hour) * 60.0);
        if (minute == 60) {
            minute = 0;
            ++hour;
        }
        return (float)(hour * 60 + minute) / 1440.0f;
    }

    private double computeSolarEventTime(double solarZenith, Calendar date, boolean isSunrise) {
        date.setTimeZone(this.mTimeZone);
        double longitudeHour = this.getLongitudeHour(date, isSunrise);
        double meanAnomaly = SunCalculator.getMeanAnomaly(longitudeHour);
        double sunTrueLong = SunCalculator.getSunTrueLongitude(meanAnomaly);
        double cosineSunLocalHour = this.getCosineSunLocalHour(sunTrueLong, solarZenith);
        if (cosineSunLocalHour < -1.0 || cosineSunLocalHour > 1.0) {
            return 0.0;
        }
        double sunLocalHour = SunCalculator.getSunLocalHour(cosineSunLocalHour, isSunrise);
        double localMeanTime = SunCalculator.getLocalMeanTime(sunTrueLong, longitudeHour, sunLocalHour);
        return this.getLocalTime(localMeanTime, date);
    }

    private double getBaseLongitudeHour() {
        return this.mLocation.getLongitude() / 15.0;
    }

    private double getLongitudeHour(Calendar date, Boolean isSunrise) {
        int offset = 18;
        if (isSunrise.booleanValue()) {
            offset = 6;
        }
        double dividend = (double)offset - this.getBaseLongitudeHour();
        double addend = dividend / 24.0;
        return SunCalculator.getDayOfYear(date) + addend;
    }

    private static double getMeanAnomaly(double longitudeHour) {
        return 0.9856 * longitudeHour - 3.289;
    }

    private static double getSunTrueLongitude(double meanAnomaly) {
        double sinDoubleMeanAnomaly;
        double secondPart;
        double meanRadians = Math.toRadians(meanAnomaly);
        double sinMeanAnomaly = Math.sin(meanRadians);
        double firstPart = meanAnomaly + sinMeanAnomaly * 1.916;
        double trueLongitude = firstPart + (secondPart = (sinDoubleMeanAnomaly = Math.sin(meanRadians * 2.0)) * 0.02 + 282.634);
        if (trueLongitude > 360.0) {
            trueLongitude -= 360.0;
        }
        return trueLongitude;
    }

    private static double getRightAscension(double sunTrueLong) {
        double tanL = Math.tan(Math.toRadians(sunTrueLong));
        double innerParens = Math.toDegrees(tanL) * 0.91764;
        double rightAscension = Math.atan(Math.toRadians(innerParens));
        if ((rightAscension = Math.toDegrees(rightAscension)) < 0.0) {
            rightAscension += 360.0;
        } else if (rightAscension > 360.0) {
            rightAscension -= 360.0;
        }
        double ninety = 90.0;
        double longitudeQuadrant = (int)(sunTrueLong / ninety);
        double rightAscensionQuadrant = (int)(rightAscension / ninety);
        double augend = (longitudeQuadrant *= ninety) - (rightAscensionQuadrant *= ninety);
        return (rightAscension + augend) / 15.0;
    }

    private double getCosineSunLocalHour(double sunTrueLong, double zenith) {
        double sinSunDeclination = SunCalculator.getSinOfSunDeclination(sunTrueLong);
        double cosineSunDeclination = SunCalculator.getCosineOfSunDeclination(sinSunDeclination);
        double zenithInRads = Math.toRadians(zenith);
        double latitude = Math.toRadians(this.mLocation.getLatitude());
        double cosineZenith = Math.cos(zenithInRads);
        double sinLatitude = Math.sin(latitude);
        double cosLatitude = Math.cos(latitude);
        double sinDeclinationTimesSinLat = sinSunDeclination * sinLatitude;
        double dividend = cosineZenith - sinDeclinationTimesSinLat;
        double divisor = cosineSunDeclination * cosLatitude;
        return dividend / divisor;
    }

    private static double getSinOfSunDeclination(double sunTrueLong) {
        double sinTrueLongitude = Math.sin(Math.toRadians(sunTrueLong));
        return sinTrueLongitude * 0.39782;
    }

    private static double getCosineOfSunDeclination(double sinSunDeclination) {
        double arcSinOfSinDeclination = Math.asin(sinSunDeclination);
        return Math.cos(arcSinOfSinDeclination);
    }

    private static double getSunLocalHour(double cosineSunLocalHour, Boolean isSunrise) {
        double arcCosineOfCosineHourAngle = Math.acos(cosineSunLocalHour);
        double localHour = Math.toDegrees(arcCosineOfCosineHourAngle);
        if (isSunrise.booleanValue()) {
            localHour = 360.0 - localHour;
        }
        return localHour / 15.0;
    }

    private static double getLocalMeanTime(double sunTrueLong, double longitudeHour, double sunLocalHour) {
        double rightAscension = SunCalculator.getRightAscension(sunTrueLong);
        double innerParens = longitudeHour * 0.06571;
        double localMeanTime = sunLocalHour + rightAscension - innerParens;
        if ((localMeanTime -= 6.622) < 0.0) {
            localMeanTime += 24.0;
        } else if (localMeanTime > 24.0) {
            localMeanTime -= 24.0;
        }
        return localMeanTime;
    }

    private double getLocalTime(double localMeanTime, Calendar date) {
        double utcTime = localMeanTime - this.getBaseLongitudeHour();
        double utcOffSet = SunCalculator.getUTCOffSet(date);
        double utcOffSetTime = utcTime + utcOffSet;
        return this.adjustForDST(utcOffSetTime, date);
    }

    private double adjustForDST(double localMeanTime, Calendar date) {
        double localTime = localMeanTime;
        if (this.mTimeZone.inDaylightTime(date.getTime())) {
            localTime += 1.0;
        }
        if (localTime > 24.0) {
            localTime -= 24.0;
        }
        return localTime;
    }

    private static double getDayOfYear(Calendar date) {
        return date.get(6);
    }

    private static double getUTCOffSet(Calendar date) {
        int offSetInMillis = date.get(15);
        return offSetInMillis / 3600000;
    }
}

