/*
 * Decompiled with CFR 0.152.
 */
package com.android.wallpaper.grass;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.renderscript.Allocation;
import android.renderscript.Dimension;
import android.renderscript.Element;
import android.renderscript.Primitive;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramStore;
import android.renderscript.ProgramVertex;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.Script;
import android.renderscript.ScriptC;
import android.renderscript.SimpleMesh;
import android.renderscript.Type;
import android.text.format.Time;
import android.util.MathUtils;
import com.android.wallpaper.RenderScriptScene;
import com.android.wallpaper.grass.SunCalculator;
import java.util.Calendar;
import java.util.TimeZone;

class GrassRS
extends RenderScriptScene {
    private Script.Invokable mUpdateBladesInvokable;
    private ProgramFragment mPfBackground;
    private ProgramFragment mPfGrass;
    private ProgramStore mPfsBackground;
    private ProgramVertex mPvBackground;
    private ProgramVertex.MatrixAllocation mPvOrthoAlloc;
    private Allocation[] mTextures;
    private Type mStateType;
    private Allocation mState;
    private Type mBladesType;
    private Allocation mBlades;
    private Allocation mBladesBuffer;
    private Allocation mBladesIndicies;
    private SimpleMesh mBladesMesh;
    private int mVerticies;
    private int mIndicies;
    private int[] mBladeSizes;
    private final float[] mFloatData5 = new float[5];
    private WorldState mWorldState;
    private final Context mContext;
    private final LocationManager mLocationManager;
    private LocationUpdater mLocationUpdater;
    private TimezoneTracker mTimezoneTracker;

    GrassRS(Context context, int width, int height) {
        super(width, height);
        this.mContext = context;
        this.mLocationManager = (LocationManager)context.getSystemService("location");
    }

    public void start() {
        super.start();
        if (this.mTimezoneTracker == null) {
            this.mTimezoneTracker = new TimezoneTracker();
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.DATE_CHANGED");
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            this.mContext.registerReceiver((BroadcastReceiver)this.mTimezoneTracker, filter);
        }
        if (this.mLocationUpdater == null) {
            this.mLocationUpdater = new LocationUpdater();
            this.mLocationManager.requestLocationUpdates("network", 3600000L, 150000.0f, (LocationListener)this.mLocationUpdater);
        }
        this.updateLocation();
    }

    public void stop() {
        super.stop();
        if (this.mTimezoneTracker != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mTimezoneTracker);
            this.mTimezoneTracker = null;
        }
        if (this.mLocationUpdater != null) {
            this.mLocationManager.removeUpdates((LocationListener)this.mLocationUpdater);
            this.mLocationUpdater = null;
        }
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.mWorldState.width = width;
        this.mWorldState.height = height;
        this.mState.data((Object)this.mWorldState);
        this.mUpdateBladesInvokable.execute();
        this.mPvOrthoAlloc.setupOrthoWindow(width, height);
    }

    protected ScriptC createScript() {
        this.createProgramVertex();
        this.createProgramFragmentStore();
        this.loadTextures();
        this.createProgramFragment();
        this.createScriptStructures();
        ScriptC.Builder sb = new ScriptC.Builder((RenderScript)this.mRS);
        sb.setType(this.mStateType, "State", 0);
        sb.setType(this.mBladesType, "Blades", 1);
        sb.setScript(this.mResources, 2130968579);
        sb.setRoot(true);
        this.mUpdateBladesInvokable = sb.addInvokable("updateBlades");
        ScriptC script = sb.create();
        script.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        script.setTimeZone(TimeZone.getDefault().getID());
        script.bindAllocation(this.mState, 0);
        script.bindAllocation(this.mBlades, 1);
        script.bindAllocation(this.mBladesBuffer, 2);
        return script;
    }

    private void createScriptStructures() {
        this.createBlades();
        this.createState();
    }

    public void setOffset(float xOffset, float yOffset, int xPixels, int yPixels) {
        this.mWorldState.xOffset = xOffset;
        this.mState.data((Object)this.mWorldState);
    }

    private void createState() {
        boolean bl = this.isPreview();
        this.mWorldState = new WorldState();
        this.mWorldState.width = this.mWidth;
        this.mWorldState.height = this.mHeight;
        this.mWorldState.bladesCount = 200;
        this.mWorldState.indexCount = this.mIndicies;
        int n = this.mWorldState.isPreview = bl ? 1 : 0;
        if (bl) {
            this.mWorldState.xOffset = 0.5f;
        }
        this.mStateType = Type.createFromClass((RenderScript)this.mRS, WorldState.class, (int)1, (String)"WorldState");
        this.mState = Allocation.createTyped((RenderScript)this.mRS, (Type)this.mStateType);
        this.mState.data((Object)this.mWorldState);
    }

    private void createBlades() {
        this.mVerticies = 0;
        this.mIndicies = 0;
        this.mBladesType = Type.createFromClass((RenderScript)this.mRS, BladesStruct.class, (int)200, (String)"Blade");
        this.mBlades = Allocation.createTyped((RenderScript)this.mRS, (Type)this.mBladesType);
        BladesStruct bladesStruct = new BladesStruct();
        this.mBladeSizes = new int[200];
        for (int i = 0; i < 200; ++i) {
            this.createBlade(bladesStruct);
            this.mIndicies += bladesStruct.size * 2 * 3;
            this.mVerticies += bladesStruct.size + 2;
            this.mBlades.subData(i, (Object)bladesStruct);
            this.mBladeSizes[i] = bladesStruct.size;
        }
        this.createMesh();
    }

    private void createMesh() {
        Element.Builder elementBuilder = new Element.Builder((RenderScript)this.mRS);
        elementBuilder.add(Element.ATTRIB_COLOR_U8_4((RenderScript)this.mRS), "color");
        elementBuilder.add(Element.ATTRIB_POSITION_2((RenderScript)this.mRS), "position");
        elementBuilder.add(Element.ATTRIB_TEXTURE_2((RenderScript)this.mRS), "texture");
        Element vertexElement = elementBuilder.create();
        SimpleMesh.Builder meshBuilder = new SimpleMesh.Builder((RenderScript)this.mRS);
        int vertexSlot = meshBuilder.addVertexType(vertexElement, this.mVerticies * 2);
        meshBuilder.setIndexType(Element.INDEX_16((RenderScript)this.mRS), this.mIndicies);
        meshBuilder.setPrimitive(Primitive.TRIANGLE);
        this.mBladesMesh = meshBuilder.create();
        this.mBladesMesh.setName("BladesMesh");
        this.mBladesBuffer = this.mBladesMesh.createVertexAllocation(vertexSlot);
        this.mBladesBuffer.setName("BladesBuffer");
        this.mBladesMesh.bindVertexAllocation(this.mBladesBuffer, 0);
        this.mBladesIndicies = this.mBladesMesh.createIndexAllocation();
        this.mBladesMesh.bindIndexAllocation(this.mBladesIndicies);
        float[] floatData = this.mFloatData5;
        Allocation buffer = this.mBladesBuffer;
        short[] idx = new short[this.mIndicies];
        int bufferIndex = 0;
        boolean i2 = false;
        for (int i = 0; i < this.mVerticies; i += 2) {
            floatData[3] = 0.0f;
            floatData[4] = 0.0f;
            buffer.subData1D(bufferIndex++, 1, floatData);
            floatData[3] = 1.0f;
            floatData[4] = 0.0f;
            buffer.subData1D(bufferIndex++, 1, floatData);
        }
        int idxIdx = 0;
        int vtxIdx = 0;
        for (int i = 0; i < this.mBladeSizes.length; ++i) {
            for (int ct = 0; ct < this.mBladeSizes[i]; ++ct) {
                idx[idxIdx + 0] = (short)(vtxIdx + 0);
                idx[idxIdx + 1] = (short)(vtxIdx + 1);
                idx[idxIdx + 2] = (short)(vtxIdx + 2);
                idx[idxIdx + 3] = (short)(vtxIdx + 1);
                idx[idxIdx + 4] = (short)(vtxIdx + 3);
                idx[idxIdx + 5] = (short)(vtxIdx + 2);
                idxIdx += 6;
                vtxIdx += 2;
            }
            vtxIdx += 2;
        }
        this.mBladesIndicies.data(idx);
        this.mBladesIndicies.uploadToBufferObject();
    }

    private void createBlade(BladesStruct blades) {
        float size = MathUtils.random((float)4.0f) + 4.0f;
        int xpos = MathUtils.random((int)(-this.mWidth), (int)this.mWidth);
        blades.angle = 0.0f;
        blades.size = (int)(size / 0.5f);
        blades.xPos = xpos;
        blades.yPos = this.mHeight;
        blades.offset = MathUtils.random((float)0.2f) - 0.1f;
        blades.scale = 4.0f / (size / 0.5f) + (MathUtils.random((float)0.6f) + 0.2f) * 0.5f;
        blades.lengthX = (MathUtils.random((float)4.5f) + 3.0f) * 0.5f * size;
        blades.lengthY = (MathUtils.random((float)5.5f) + 2.0f) * 0.5f * size;
        blades.hardness = (MathUtils.random((float)1.0f) + 0.2f) * 0.5f;
        blades.h = MathUtils.random((float)0.02f) + 0.2f;
        blades.s = MathUtils.random((float)0.22f) + 0.78f;
        blades.b = MathUtils.random((float)0.65f) + 0.35f;
        blades.turbulencex = (float)xpos * 0.006f;
    }

    private void loadTextures() {
        Allocation[] textures = this.mTextures = new Allocation[5];
        textures[0] = this.loadTexture(2130837516, "TNight");
        textures[1] = this.loadTexture(2130837525, "TSunrise");
        textures[2] = this.loadTexture(2130837523, "TSky");
        textures[3] = this.loadTexture(2130837526, "TSunset");
        textures[4] = this.generateTextureAlpha(4, 1, new int[]{0xFFFF00}, "TAa");
        int count = textures.length;
        for (int i = 0; i < count; ++i) {
            textures[i].uploadToTexture(0);
        }
    }

    private Allocation generateTextureAlpha(int width, int height, int[] data, String name) {
        Type.Builder builder = new Type.Builder((RenderScript)this.mRS, Element.A_8((RenderScript)this.mRS));
        builder.add(Dimension.X, width);
        builder.add(Dimension.Y, height);
        builder.add(Dimension.LOD, 1);
        Allocation allocation = Allocation.createTyped((RenderScript)this.mRS, (Type)builder.create());
        allocation.setName(name);
        int[] grey1 = new int[]{0x3F3F3F3F};
        int[] grey2 = new int[]{0};
        Allocation.Adapter2D a = allocation.createAdapter2D();
        a.setConstraint(Dimension.LOD, 0);
        a.subData(0, 0, 4, 1, data);
        a.setConstraint(Dimension.LOD, 1);
        a.subData(0, 0, 2, 1, grey1);
        a.setConstraint(Dimension.LOD, 2);
        a.subData(0, 0, 1, 1, grey2);
        return allocation;
    }

    private Allocation loadTexture(int id, String name) {
        Allocation allocation = Allocation.createFromBitmapResource((RenderScript)this.mRS, (Resources)this.mResources, (int)id, (Element)Element.RGB_565((RenderScript)this.mRS), (boolean)false);
        allocation.setName(name);
        return allocation;
    }

    private void createProgramFragment() {
        Sampler.Builder samplerBuilder = new Sampler.Builder((RenderScript)this.mRS);
        samplerBuilder.setMin(Sampler.Value.LINEAR_MIP_LINEAR);
        samplerBuilder.setMag(Sampler.Value.LINEAR);
        samplerBuilder.setWrapS(Sampler.Value.WRAP);
        samplerBuilder.setWrapT(Sampler.Value.WRAP);
        Sampler sl = samplerBuilder.create();
        samplerBuilder.setMin(Sampler.Value.NEAREST);
        samplerBuilder.setMag(Sampler.Value.NEAREST);
        Sampler sn = samplerBuilder.create();
        ProgramFragment.Builder builder = new ProgramFragment.Builder((RenderScript)this.mRS);
        builder.setTexture(ProgramFragment.Builder.EnvMode.REPLACE, ProgramFragment.Builder.Format.ALPHA, 0);
        this.mPfGrass = builder.create();
        this.mPfGrass.setName("PFGrass");
        this.mPfGrass.bindSampler(sl, 0);
        builder = new ProgramFragment.Builder((RenderScript)this.mRS);
        builder.setTexture(ProgramFragment.Builder.EnvMode.REPLACE, ProgramFragment.Builder.Format.RGB, 0);
        this.mPfBackground = builder.create();
        this.mPfBackground.setName("PFBackground");
        this.mPfBackground.bindSampler(sn, 0);
    }

    private void createProgramFragmentStore() {
        ProgramStore.Builder builder = new ProgramStore.Builder((RenderScript)this.mRS, null, null);
        builder.setDepthFunc(ProgramStore.DepthFunc.ALWAYS);
        builder.setBlendFunc(ProgramStore.BlendSrcFunc.SRC_ALPHA, ProgramStore.BlendDstFunc.ONE_MINUS_SRC_ALPHA);
        builder.setDitherEnable(false);
        builder.setDepthMask(false);
        this.mPfsBackground = builder.create();
        this.mPfsBackground.setName("PFSBackground");
    }

    private void createProgramVertex() {
        this.mPvOrthoAlloc = new ProgramVertex.MatrixAllocation((RenderScript)this.mRS);
        this.mPvOrthoAlloc.setupOrthoWindow(this.mWidth, this.mHeight);
        ProgramVertex.Builder pvb = new ProgramVertex.Builder((RenderScript)this.mRS, null, null);
        this.mPvBackground = pvb.create();
        this.mPvBackground.bindAllocation(this.mPvOrthoAlloc);
        this.mPvBackground.setName("PVBackground");
    }

    private void updateLocation() {
        this.updateLocation(this.mLocationManager.getLastKnownLocation("network"));
    }

    private void updateLocation(Location location) {
        if (location != null) {
            String timeZone = Time.getCurrentTimezone();
            SunCalculator calculator = new SunCalculator(location, timeZone);
            Calendar now = Calendar.getInstance();
            double sunrise = calculator.computeSunriseTime(96.0, now);
            this.mWorldState.dawn = SunCalculator.timeToDayFraction(sunrise);
            double sunset = calculator.computeSunsetTime(96.0, now);
            this.mWorldState.dusk = SunCalculator.timeToDayFraction(sunset);
        } else {
            this.mWorldState.dawn = 0.3f;
            this.mWorldState.dusk = 0.75f;
        }
        this.mWorldState.morning = this.mWorldState.dawn + 0.083333336f;
        this.mWorldState.afternoon = this.mWorldState.dusk - 0.083333336f;
        this.mState.data((Object)this.mWorldState);
    }

    private class TimezoneTracker
    extends BroadcastReceiver {
        private TimezoneTracker() {
        }

        public void onReceive(Context context, Intent intent) {
            GrassRS.this.getScript().setTimeZone(Time.getCurrentTimezone());
            GrassRS.this.updateLocation();
        }
    }

    private class LocationUpdater
    implements LocationListener {
        private LocationUpdater() {
        }

        public void onLocationChanged(Location location) {
            GrassRS.this.updateLocation(location);
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }
    }

    static class WorldState {
        public int bladesCount;
        public int indexCount;
        public int width;
        public int height;
        public float xOffset;
        public float dawn;
        public float morning;
        public float afternoon;
        public float dusk;
        public int isPreview;

        WorldState() {
        }
    }

    class BladesStruct {
        public float angle;
        public int size;
        public float xPos;
        public float yPos;
        public float offset;
        public float scale;
        public float lengthX;
        public float lengthY;
        public float hardness;
        public float h;
        public float s;
        public float b;
        public float turbulencex;

        BladesStruct() {
        }
    }
}

