/*
 * Decompiled with CFR 0.152.
 */
package com.android.wallpaper.galaxy;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.Primitive;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.ProgramVertex;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.Script;
import android.renderscript.ScriptC;
import android.renderscript.SimpleMesh;
import android.renderscript.Type;
import com.android.wallpaper.RenderScriptScene;
import java.util.TimeZone;

class GalaxyRS
extends RenderScriptScene {
    private final BitmapFactory.Options mOptionsARGB = new BitmapFactory.Options();
    private ProgramFragment mPfBackground;
    private ProgramFragment mPfStars;
    private ProgramStore mPfsBackground;
    private ProgramStore mPfsLights;
    private ProgramVertex mPvBkOrtho;
    private ProgramVertex mPvBkProj;
    private ProgramVertex mPvStars;
    private Sampler mSampler;
    private Sampler mStarSampler;
    private ProgramVertex.MatrixAllocation mPvOrthoAlloc;
    private ProgramVertex.MatrixAllocation mPvProjectionAlloc;
    private Allocation[] mTextures;
    private GalaxyState mGalaxyState;
    private Type mStateType;
    private Allocation mState;
    private Allocation mParticlesBuffer;
    private SimpleMesh mParticlesMesh;
    private Script.Invokable mInitParticles;

    GalaxyRS(int width, int height) {
        super(width, height);
        this.mOptionsARGB.inScaled = false;
        this.mOptionsARGB.inPreferredConfig = Bitmap.Config.ARGB_8888;
    }

    protected ScriptC createScript() {
        this.createScriptStructures();
        this.createProgramVertex();
        this.createProgramRaster();
        this.createProgramFragmentStore();
        this.createProgramFragment();
        this.loadTextures();
        ScriptC.Builder sb = new ScriptC.Builder((RenderScript)this.mRS);
        sb.setType(this.mStateType, "State", 0);
        sb.setType(this.mParticlesMesh.getVertexType(0), "Particles", 1);
        this.mInitParticles = sb.addInvokable("initParticles");
        sb.setScript(this.mResources, 2130968578);
        sb.setRoot(true);
        ScriptC script = sb.create();
        script.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        script.setTimeZone(TimeZone.getDefault().getID());
        script.bindAllocation(this.mState, 0);
        script.bindAllocation(this.mParticlesBuffer, 1);
        this.mInitParticles.execute();
        return script;
    }

    private void createScriptStructures() {
        this.createState();
        this.createParticlesMesh();
    }

    private void createParticlesMesh() {
        Element.Builder elementBuilder = new Element.Builder((RenderScript)this.mRS);
        elementBuilder.add(Element.createAttrib((RenderScript)this.mRS, (Element.DataType)Element.DataType.UNSIGNED_8, (Element.DataKind)Element.DataKind.USER, (int)4), "color");
        elementBuilder.add(Element.createAttrib((RenderScript)this.mRS, (Element.DataType)Element.DataType.FLOAT_32, (Element.DataKind)Element.DataKind.USER, (int)3), "position");
        Element vertexElement = elementBuilder.create();
        SimpleMesh.Builder meshBuilder = new SimpleMesh.Builder((RenderScript)this.mRS);
        int vertexSlot = meshBuilder.addVertexType(vertexElement, 12000);
        meshBuilder.setPrimitive(Primitive.POINT);
        this.mParticlesMesh = meshBuilder.create();
        this.mParticlesMesh.setName("ParticlesMesh");
        this.mParticlesBuffer = this.mParticlesMesh.createVertexAllocation(vertexSlot);
        this.mParticlesBuffer.setName("ParticlesBuffer");
        this.mParticlesMesh.bindVertexAllocation(this.mParticlesBuffer, 0);
    }

    public void setOffset(float xOffset, float yOffset, int xPixels, int yPixels) {
        this.mGalaxyState.xOffset = xOffset;
        this.mState.data((Object)this.mGalaxyState);
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.mGalaxyState.width = width;
        this.mGalaxyState.height = height;
        this.mGalaxyState.scale = width > height ? 1 : 0;
        this.mState.data((Object)this.mGalaxyState);
        this.mPvOrthoAlloc.setupOrthoWindow(this.mWidth, this.mHeight);
        this.mPvProjectionAlloc.setupProjectionNormalized(this.mWidth, this.mHeight);
        this.mInitParticles.execute();
    }

    private void createState() {
        boolean bl = this.isPreview();
        this.mGalaxyState = new GalaxyState();
        this.mGalaxyState.width = this.mWidth;
        this.mGalaxyState.height = this.mHeight;
        this.mGalaxyState.scale = this.mWidth > this.mHeight ? 1 : 0;
        this.mGalaxyState.particlesCount = 12000;
        this.mGalaxyState.galaxyRadius = 300;
        int n = this.mGalaxyState.isPreview = bl ? 1 : 0;
        if (bl) {
            this.mGalaxyState.xOffset = 0.5f;
        }
        this.mStateType = Type.createFromClass((RenderScript)this.mRS, GalaxyState.class, (int)1, (String)"GalaxyState");
        this.mState = Allocation.createTyped((RenderScript)this.mRS, (Type)this.mStateType);
        this.mState.data((Object)this.mGalaxyState);
    }

    private void loadTextures() {
        Allocation[] textures = this.mTextures = new Allocation[3];
        textures[0] = this.loadTexture(2130837524, "TSpace");
        textures[1] = this.loadTexture(2130837514, "TLight1");
        textures[2] = this.loadTextureARGB(2130837504, "TFlares");
        int count = textures.length;
        for (int i = 0; i < count; ++i) {
            textures[i].uploadToTexture(0);
        }
    }

    private Allocation loadTexture(int id, String name) {
        Allocation allocation = Allocation.createFromBitmapResource((RenderScript)this.mRS, (Resources)this.mResources, (int)id, (Element)Element.RGB_565((RenderScript)this.mRS), (boolean)false);
        allocation.setName(name);
        return allocation;
    }

    private Allocation loadTextureARGB(int id, String name) {
        Bitmap b = BitmapFactory.decodeResource((Resources)this.mResources, (int)id, (BitmapFactory.Options)this.mOptionsARGB);
        Allocation allocation = Allocation.createFromBitmap((RenderScript)this.mRS, (Bitmap)b, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)false);
        allocation.setName(name);
        return allocation;
    }

    private void createProgramFragment() {
        Sampler.Builder samplerBuilder = new Sampler.Builder((RenderScript)this.mRS);
        samplerBuilder.setMin(Sampler.Value.NEAREST);
        samplerBuilder.setMag(Sampler.Value.NEAREST);
        samplerBuilder.setWrapS(Sampler.Value.WRAP);
        samplerBuilder.setWrapT(Sampler.Value.WRAP);
        this.mSampler = samplerBuilder.create();
        ProgramFragment.Builder builder = new ProgramFragment.Builder((RenderScript)this.mRS);
        builder.setTexture(ProgramFragment.Builder.EnvMode.REPLACE, ProgramFragment.Builder.Format.RGB, 0);
        this.mPfBackground = builder.create();
        this.mPfBackground.setName("PFBackground");
        this.mPfBackground.bindSampler(this.mSampler, 0);
        samplerBuilder = new Sampler.Builder((RenderScript)this.mRS);
        samplerBuilder.setMin(Sampler.Value.LINEAR);
        samplerBuilder.setMag(Sampler.Value.LINEAR);
        samplerBuilder.setWrapS(Sampler.Value.WRAP);
        samplerBuilder.setWrapT(Sampler.Value.WRAP);
        this.mStarSampler = samplerBuilder.create();
        builder = new ProgramFragment.Builder((RenderScript)this.mRS);
        builder.setPointSpriteTexCoordinateReplacement(true);
        builder.setTexture(ProgramFragment.Builder.EnvMode.MODULATE, ProgramFragment.Builder.Format.RGBA, 0);
        this.mPfStars = builder.create();
        this.mPfStars.setName("PFStars");
        this.mPfBackground.bindSampler(this.mStarSampler, 0);
    }

    private void createProgramFragmentStore() {
        ProgramStore.Builder builder = new ProgramStore.Builder((RenderScript)this.mRS, null, null);
        builder.setDepthFunc(ProgramStore.DepthFunc.ALWAYS);
        builder.setBlendFunc(ProgramStore.BlendSrcFunc.ONE, ProgramStore.BlendDstFunc.ZERO);
        builder.setDitherEnable(false);
        builder.setDepthMask(false);
        this.mPfsBackground = builder.create();
        this.mPfsBackground.setName("PFSBackground");
        builder = new ProgramStore.Builder((RenderScript)this.mRS, null, null);
        builder.setDepthFunc(ProgramStore.DepthFunc.ALWAYS);
        builder.setBlendFunc(ProgramStore.BlendSrcFunc.SRC_ALPHA, ProgramStore.BlendDstFunc.ONE);
        builder.setDitherEnable(false);
        this.mPfsLights = builder.create();
        this.mPfsLights.setName("PFSLights");
    }

    private void createProgramVertex() {
        this.mPvOrthoAlloc = new ProgramVertex.MatrixAllocation((RenderScript)this.mRS);
        this.mPvOrthoAlloc.setupOrthoWindow(this.mWidth, this.mHeight);
        ProgramVertex.Builder builder = new ProgramVertex.Builder((RenderScript)this.mRS, null, null);
        this.mPvBkOrtho = builder.create();
        this.mPvBkOrtho.bindAllocation(this.mPvOrthoAlloc);
        this.mPvBkOrtho.setName("PVBkOrtho");
        this.mPvProjectionAlloc = new ProgramVertex.MatrixAllocation((RenderScript)this.mRS);
        this.mPvProjectionAlloc.setupProjectionNormalized(this.mWidth, this.mHeight);
        builder = new ProgramVertex.Builder((RenderScript)this.mRS, null, null);
        this.mPvBkProj = builder.create();
        this.mPvBkProj.bindAllocation(this.mPvProjectionAlloc);
        this.mPvBkProj.setName("PVBkProj");
        ProgramVertex.ShaderBuilder sb = new ProgramVertex.ShaderBuilder((RenderScript)this.mRS);
        String t = "void main() {\n  float dist = ATTRIB_position.y;\n  float angle = ATTRIB_position.x;\n  float x = dist * sin(angle);\n  float y = dist * cos(angle) * 0.892;\n  float p = dist * 5.5;\n  float s = cos(p);\n  float t = sin(p);\n  vec4 pos;\n  pos.x = t * x + s * y;\n  pos.y = s * x - t * y;\n  pos.z = ATTRIB_position.z;\n  pos.w = 1.0;\n  gl_Position = UNI_MVP * pos;\n  gl_PointSize = ATTRIB_color.a * 10.0;\n  varColor.rgb = ATTRIB_color.rgb;\n  varColor.a = 1.0;\n}\n";
        sb.setShader(t);
        sb.addInput(this.mParticlesMesh.getVertexType(0).getElement());
        this.mPvStars = sb.create();
        this.mPvStars.bindAllocation(this.mPvProjectionAlloc);
        this.mPvStars.setName("PVStars");
    }

    private void createProgramRaster() {
        ProgramRaster.Builder b = new ProgramRaster.Builder((RenderScript)this.mRS, null, null);
        b.setPointSmoothEnable(true);
        b.setPointSpriteEnable(true);
        this.mRS.contextBindProgramRaster(b.create());
    }

    static class GalaxyState {
        public int width;
        public int height;
        public int particlesCount;
        public int galaxyRadius;
        public float xOffset;
        public int isPreview;
        public int scale;

        GalaxyState() {
        }
    }
}

