/*
 * Decompiled with CFR 0.152.
 */
package com.android.wallpaper.fall;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramStore;
import android.renderscript.ProgramVertex;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.Script;
import android.renderscript.ScriptC;
import android.renderscript.SimpleMesh;
import android.renderscript.Type;
import android.util.MathUtils;
import com.android.wallpaper.RenderScriptScene;
import java.util.TimeZone;

class FallRS
extends RenderScriptScene {
    private final BitmapFactory.Options mOptionsARGB = new BitmapFactory.Options();
    private ProgramFragment mPfBackground;
    private ProgramFragment mPfSky;
    private ProgramStore mPfsBackground;
    private ProgramStore mPfsLeaf;
    private ProgramVertex mPvSky;
    private ProgramVertex mPvWater;
    private ProgramVertex.MatrixAllocation mPvOrthoAlloc;
    private Sampler mSampler;
    private Allocation mState;
    private Allocation mDropState;
    private DropState mDrop;
    private Type mStateType;
    private Type mDropType;
    private int mMeshWidth;
    private Allocation mUniformAlloc;
    private int mMeshHeight;
    private SimpleMesh mMesh;
    private WorldState mWorldState;
    private float mGlHeight;

    public FallRS(int width, int height) {
        super(width, height);
        this.mOptionsARGB.inScaled = false;
        this.mOptionsARGB.inPreferredConfig = Bitmap.Config.ARGB_8888;
    }

    public void setOffset(float xOffset, float yOffset, int xPixels, int yPixels) {
        this.mWorldState.xOffset = xOffset;
        this.mState.data((Object)this.mWorldState);
    }

    public Bundle onCommand(String action, int x, int y, int z, Bundle extras, boolean resultRequested) {
        if ("android.wallpaper.tap".equals(action)) {
            this.addDrop((float)x + (this.mWorldState.rotate == 0 ? (float)this.mWorldState.width * this.mWorldState.xOffset : 0.0f), y);
        } else if ("android.home.drop".equals(action)) {
            this.addDrop((float)x + (this.mWorldState.rotate == 0 ? (float)this.mWorldState.width * this.mWorldState.xOffset : 0.0f), y);
        }
        return null;
    }

    public void start() {
        super.start();
        WorldState worldState = this.mWorldState;
        int width = worldState.width;
        int x = width / 4 + (int)(Math.random() * (double)(width / 2));
        int y = worldState.height / 4 + (int)(Math.random() * (double)(worldState.height / 2));
        this.addDrop((float)x + (this.mWorldState.rotate == 0 ? (float)width * worldState.xOffset : 0.0f), y);
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.mWorldState.width = width;
        this.mWorldState.height = height;
        this.mWorldState.rotate = width > height ? 1 : 0;
        this.mState.data((Object)this.mWorldState);
        this.mPvOrthoAlloc.setupProjectionNormalized(this.mWidth, this.mHeight);
    }

    protected ScriptC createScript() {
        this.createMesh();
        this.createState();
        this.createProgramVertex();
        this.createProgramFragmentStore();
        this.createProgramFragment();
        this.loadTextures();
        ScriptC.Builder sb = new ScriptC.Builder((RenderScript)this.mRS);
        sb.setType(this.mStateType, "State", 0);
        sb.setType(this.mDropType, "Drop", 2);
        sb.setType(this.mUniformAlloc.getType(), "Constants", 1);
        sb.setScript(this.mResources, 2130968577);
        Script.Invokable invokable = sb.addInvokable("initLeaves");
        sb.setRoot(true);
        ScriptC script = sb.create();
        script.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        script.setTimeZone(TimeZone.getDefault().getID());
        script.bindAllocation(this.mState, 0);
        script.bindAllocation(this.mUniformAlloc, 1);
        script.bindAllocation(this.mDropState, 2);
        invokable.execute();
        return script;
    }

    private void createMesh() {
        int y;
        SimpleMesh.TriangleMeshBuilder tmb = new SimpleMesh.TriangleMeshBuilder((RenderScript)this.mRS, 2, 0);
        int width = this.mWidth > this.mHeight ? this.mHeight : this.mWidth;
        int height = this.mWidth > this.mHeight ? this.mWidth : this.mHeight;
        int wResolution = 48;
        int hResolution = (int)((float)(48 * height) / (float)width);
        this.mGlHeight = 2.0f * (float)height / (float)width;
        wResolution += 2;
        hResolution += 2;
        for (y = 0; y <= hResolution; ++y) {
            float yOffset = ((float)y / (float)hResolution * 2.0f - 1.0f) * (float)height / (float)width;
            for (int x = 0; x <= wResolution; ++x) {
                tmb.addVertex((float)x / (float)wResolution * 2.0f - 1.0f, yOffset);
            }
        }
        for (y = 0; y < hResolution; ++y) {
            boolean shift = (y & 1) == 0;
            int yOffset = y * (wResolution + 1);
            for (int x = 0; x < wResolution; ++x) {
                int index = yOffset + x;
                int iWR1 = index + wResolution + 1;
                if (shift) {
                    tmb.addTriangle(index, index + 1, iWR1);
                    tmb.addTriangle(index + 1, iWR1 + 1, iWR1);
                    continue;
                }
                tmb.addTriangle(index, iWR1 + 1, iWR1);
                tmb.addTriangle(index, index + 1, iWR1 + 1);
            }
        }
        this.mMesh = tmb.create();
        this.mMesh.setName("WaterMesh");
        this.mMeshWidth = wResolution + 1;
        this.mMeshHeight = hResolution + 1;
    }

    private void createState() {
        this.mWorldState = new WorldState();
        this.mWorldState.width = this.mWidth;
        this.mWorldState.height = this.mHeight;
        this.mWorldState.meshWidth = this.mMeshWidth;
        this.mWorldState.meshHeight = this.mMeshHeight;
        this.mWorldState.rippleIndex = 0;
        this.mWorldState.glWidth = 2.0f;
        this.mWorldState.glHeight = this.mGlHeight;
        this.mWorldState.skySpeedX = MathUtils.random((float)-0.001f, (float)0.001f);
        this.mWorldState.skySpeedY = MathUtils.random((float)8.0E-5f, (float)2.0E-4f);
        this.mWorldState.rotate = this.mWidth > this.mHeight ? 1 : 0;
        this.mWorldState.isPreview = this.isPreview() ? 1 : 0;
        this.mStateType = Type.createFromClass((RenderScript)this.mRS, WorldState.class, (int)1, (String)"WorldState");
        this.mState = Allocation.createTyped((RenderScript)this.mRS, (Type)this.mStateType);
        this.mState.data((Object)this.mWorldState);
        this.mDrop = new DropState();
        this.mDrop.dropX = -1;
        this.mDrop.dropY = -1;
        this.mDropType = Type.createFromClass((RenderScript)this.mRS, DropState.class, (int)1, (String)"DropState");
        this.mDropState = Allocation.createTyped((RenderScript)this.mRS, (Type)this.mDropType);
        this.mDropState.data((Object)this.mDrop);
    }

    private void loadTextures() {
        Allocation[] textures = new Allocation[]{this.loadTexture(2130837518, "TRiverbed"), this.loadTextureARGB(2130837509, "TLeaves")};
        int count = textures.length;
        for (int i = 0; i < count; ++i) {
            textures[i].uploadToTexture(0);
        }
    }

    private Allocation loadTexture(int id, String name) {
        Allocation allocation = Allocation.createFromBitmapResource((RenderScript)this.mRS, (Resources)this.mResources, (int)id, (Element)Element.RGB_565((RenderScript)this.mRS), (boolean)false);
        allocation.setName(name);
        return allocation;
    }

    private Allocation loadTextureARGB(int id, String name) {
        Bitmap b = BitmapFactory.decodeResource((Resources)this.mResources, (int)id, (BitmapFactory.Options)this.mOptionsARGB);
        Allocation allocation = Allocation.createFromBitmap((RenderScript)this.mRS, (Bitmap)b, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)false);
        allocation.setName(name);
        return allocation;
    }

    private void createProgramFragment() {
        Sampler.Builder sampleBuilder = new Sampler.Builder((RenderScript)this.mRS);
        sampleBuilder.setMin(Sampler.Value.LINEAR);
        sampleBuilder.setMag(Sampler.Value.LINEAR);
        sampleBuilder.setWrapS(Sampler.Value.CLAMP);
        sampleBuilder.setWrapT(Sampler.Value.CLAMP);
        this.mSampler = sampleBuilder.create();
        ProgramFragment.Builder builder = new ProgramFragment.Builder((RenderScript)this.mRS);
        builder.setTexture(ProgramFragment.Builder.EnvMode.REPLACE, ProgramFragment.Builder.Format.RGBA, 0);
        this.mPfBackground = builder.create();
        this.mPfBackground.setName("PFBackground");
        this.mPfBackground.bindSampler(this.mSampler, 0);
        builder = new ProgramFragment.Builder((RenderScript)this.mRS);
        builder.setTexture(ProgramFragment.Builder.EnvMode.MODULATE, ProgramFragment.Builder.Format.RGBA, 0);
        this.mPfSky = builder.create();
        this.mPfSky.setName("PFSky");
        this.mPfSky.bindSampler(this.mSampler, 0);
    }

    private void createProgramFragmentStore() {
        ProgramStore.Builder builder = new ProgramStore.Builder((RenderScript)this.mRS, null, null);
        builder.setDepthFunc(ProgramStore.DepthFunc.ALWAYS);
        builder.setBlendFunc(ProgramStore.BlendSrcFunc.ONE, ProgramStore.BlendDstFunc.ONE);
        builder.setDitherEnable(false);
        builder.setDepthMask(true);
        this.mPfsBackground = builder.create();
        this.mPfsBackground.setName("PFSBackground");
        builder = new ProgramStore.Builder((RenderScript)this.mRS, null, null);
        builder.setDepthFunc(ProgramStore.DepthFunc.ALWAYS);
        builder.setBlendFunc(ProgramStore.BlendSrcFunc.SRC_ALPHA, ProgramStore.BlendDstFunc.ONE_MINUS_SRC_ALPHA);
        builder.setDitherEnable(false);
        builder.setDepthMask(true);
        this.mPfsLeaf = builder.create();
        this.mPfsLeaf.setName("PFSLeaf");
    }

    private void createProgramVertex() {
        this.mPvOrthoAlloc = new ProgramVertex.MatrixAllocation((RenderScript)this.mRS);
        this.mPvOrthoAlloc.setupProjectionNormalized(this.mWidth, this.mHeight);
        ProgramVertex.Builder builder = new ProgramVertex.Builder((RenderScript)this.mRS, null, null);
        this.mPvSky = builder.create();
        this.mPvSky.bindAllocation(this.mPvOrthoAlloc);
        this.mPvSky.setName("PVSky");
        Element.Builder eb = new Element.Builder((RenderScript)this.mRS);
        eb.add(Element.createVector((RenderScript)this.mRS, (Element.DataType)Element.DataType.FLOAT_32, (int)4), "Drop01");
        eb.add(Element.createVector((RenderScript)this.mRS, (Element.DataType)Element.DataType.FLOAT_32, (int)4), "Drop02");
        eb.add(Element.createVector((RenderScript)this.mRS, (Element.DataType)Element.DataType.FLOAT_32, (int)4), "Drop03");
        eb.add(Element.createVector((RenderScript)this.mRS, (Element.DataType)Element.DataType.FLOAT_32, (int)4), "Drop04");
        eb.add(Element.createVector((RenderScript)this.mRS, (Element.DataType)Element.DataType.FLOAT_32, (int)4), "Drop05");
        eb.add(Element.createVector((RenderScript)this.mRS, (Element.DataType)Element.DataType.FLOAT_32, (int)4), "Drop06");
        eb.add(Element.createVector((RenderScript)this.mRS, (Element.DataType)Element.DataType.FLOAT_32, (int)4), "Drop07");
        eb.add(Element.createVector((RenderScript)this.mRS, (Element.DataType)Element.DataType.FLOAT_32, (int)4), "Drop08");
        eb.add(Element.createVector((RenderScript)this.mRS, (Element.DataType)Element.DataType.FLOAT_32, (int)4), "Drop09");
        eb.add(Element.createVector((RenderScript)this.mRS, (Element.DataType)Element.DataType.FLOAT_32, (int)4), "Drop10");
        eb.add(Element.createVector((RenderScript)this.mRS, (Element.DataType)Element.DataType.FLOAT_32, (int)4), "Offset");
        eb.add(Element.USER_F32((RenderScript)this.mRS), "Rotate");
        Element e = eb.create();
        this.mUniformAlloc = Allocation.createSized((RenderScript)this.mRS, (Element)e, (int)1);
        ProgramVertex.ShaderBuilder sb = new ProgramVertex.ShaderBuilder((RenderScript)this.mRS);
        String t = "\nvec2 addDrop(vec4 d, vec2 pos, float dxMul) {\n  vec2 ret = vec2(0.0, 0.0);\n  vec2 delta = d.xy - pos;\n  delta.x *= dxMul;\n  float dist = length(delta);\n  if (dist < d.w) { \n    float amp = d.z * dist;\n    amp /= d.w * d.w;\n    amp *= sin(d.w - dist);\n    ret = delta * amp;\n  }\n  return ret;\n}\nvoid main() {\n  vec2 pos = ATTRIB_position.xy;\n  gl_Position = vec4(pos.x, pos.y, 0.0, 1.0);\n  float dxMul = 1.0;\n  varTex0 = vec4((pos.x + 1.0), (pos.y + 1.6666), 0.0, 0.0);\n  if (UNI_Rotate < 0.9) {\n    varTex0.xy *= vec2(0.25, 0.33);\n    varTex0.x += UNI_Offset.x * 0.5;\n    pos.x += UNI_Offset.x * 2.0;\n  } else {\n    varTex0.xy *= vec2(0.5, 0.3125);\n    dxMul = 2.5;\n  }\n  varColor = vec4(1.0, 1.0, 1.0, 1.0);\n  pos.xy += vec2(1.0, 1.0);\n  pos.xy *= vec2(25.0, 42.0);\n  varTex0.xy += addDrop(UNI_Drop01, pos, dxMul);\n  varTex0.xy += addDrop(UNI_Drop02, pos, dxMul);\n  varTex0.xy += addDrop(UNI_Drop03, pos, dxMul);\n  varTex0.xy += addDrop(UNI_Drop04, pos, dxMul);\n  varTex0.xy += addDrop(UNI_Drop05, pos, dxMul);\n  varTex0.xy += addDrop(UNI_Drop06, pos, dxMul);\n  varTex0.xy += addDrop(UNI_Drop07, pos, dxMul);\n  varTex0.xy += addDrop(UNI_Drop08, pos, dxMul);\n  varTex0.xy += addDrop(UNI_Drop09, pos, dxMul);\n  varTex0.xy += addDrop(UNI_Drop10, pos, dxMul);\n}\n";
        sb.setShader(t);
        sb.addConstant(this.mUniformAlloc.getType());
        sb.addInput(this.mMesh.getVertexType(0).getElement());
        this.mPvWater = sb.create();
        this.mPvWater.bindAllocation(this.mPvOrthoAlloc);
        this.mPvWater.setName("PVWater");
        this.mPvWater.bindConstants(this.mUniformAlloc, 1);
    }

    void addDrop(float x, float y) {
        this.mDrop.dropX = (int)(x / (float)this.mWidth * (float)this.mMeshWidth);
        this.mDrop.dropY = (int)(y / (float)this.mHeight * (float)this.mMeshHeight);
        this.mDropState.data((Object)this.mDrop);
    }

    static class DropState {
        public int dropX;
        public int dropY;

        DropState() {
        }
    }

    static class WorldState {
        public int frameCount;
        public int width;
        public int height;
        public int meshWidth;
        public int meshHeight;
        public int rippleIndex;
        public float glWidth;
        public float glHeight;
        public float skySpeedX;
        public float skySpeedY;
        public int rotate;
        public int isPreview;
        public float xOffset;

        WorldState() {
        }
    }
}

