/*
 * Decompiled with CFR 0.152.
 */
package com.android.wallpaper;

import android.content.res.Resources;
import android.os.Bundle;
import android.renderscript.RenderScriptGL;
import android.renderscript.Script;
import android.renderscript.ScriptC;

public abstract class RenderScriptScene {
    protected int mWidth;
    protected int mHeight;
    protected boolean mPreview;
    protected Resources mResources;
    protected RenderScriptGL mRS;
    protected ScriptC mScript;

    public RenderScriptScene(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public void init(RenderScriptGL rs, Resources res, boolean isPreview) {
        this.mRS = rs;
        this.mResources = res;
        this.mPreview = isPreview;
        this.mScript = this.createScript();
    }

    public boolean isPreview() {
        return this.mPreview;
    }

    public ScriptC getScript() {
        return this.mScript;
    }

    protected abstract ScriptC createScript();

    public void stop() {
        this.mRS.contextBindRootScript(null);
    }

    public void start() {
        this.mRS.contextBindRootScript((Script)this.mScript);
    }

    public void resize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public void setOffset(float xOffset, float yOffset, int xPixels, int yPixels) {
    }

    public Bundle onCommand(String action, int x, int y, int z, Bundle extras, boolean resultRequested) {
        return null;
    }
}

