/*
 * Decompiled with CFR 0.152.
 */
package android.security.tests;

import android.app.Activity;
import android.security.SystemKeyStore;
import android.test.ActivityUnitTestCase;
import android.test.suitebuilder.annotation.MediumTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MediumTest
public class SystemKeyStoreTest
extends ActivityUnitTestCase<Activity> {
    private static final String keyName = "TestKey";
    private static final String keyName2 = "TestKey2";
    private SystemKeyStore mSysKeyStore = null;

    public SystemKeyStoreTest() {
        super(Activity.class);
    }

    protected void setUp() throws Exception {
        this.mSysKeyStore = SystemKeyStore.getInstance();
        try {
            this.mSysKeyStore.deleteKey(keyName);
            this.mSysKeyStore.deleteKey(keyName2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        try {
            this.mSysKeyStore.deleteKey(keyName);
            this.mSysKeyStore.deleteKey(keyName2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    public void testBasicAccess() throws Exception {
        try {
            byte[] newKey = this.mSysKeyStore.generateNewKey(128, "AES", keyName);
            SystemKeyStoreTest.assertNotNull((Object)newKey);
            byte[] recKey = this.mSysKeyStore.retrieveKey(keyName);
            SystemKeyStoreTest.assertEquals((int)newKey.length, (int)recKey.length);
            for (int i = 0; i < newKey.length; ++i) {
                SystemKeyStoreTest.assertEquals((byte)newKey[i], (byte)recKey[i]);
            }
            this.mSysKeyStore.deleteKey(keyName);
            byte[] nullKey = this.mSysKeyStore.retrieveKey(keyName);
            SystemKeyStoreTest.assertNull((Object)nullKey);
            String newKeyStr = this.mSysKeyStore.generateNewKeyHexString(128, "AES", keyName2);
            SystemKeyStoreTest.assertNotNull((Object)newKeyStr);
            String recKeyStr = this.mSysKeyStore.retrieveKeyHexString(keyName2);
            SystemKeyStoreTest.assertEquals((String)newKeyStr, (String)recKeyStr);
            this.mSysKeyStore.deleteKey(keyName2);
            String nullKey2 = this.mSysKeyStore.retrieveKeyHexString(keyName2);
            SystemKeyStoreTest.assertNull((Object)nullKey2);
        }
        catch (Exception e) {
            SystemKeyStoreTest.fail();
        }
    }
}

