/*
 * Decompiled with CFR 0.152.
 */
package android.security.tests;

import android.app.Activity;
import android.security.KeyStore;
import android.test.ActivityUnitTestCase;
import android.test.suitebuilder.annotation.MediumTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MediumTest
public class KeyStoreTest
extends ActivityUnitTestCase<Activity> {
    private static final String TEST_PASSWD = "12345678";
    private static final String TEST_EMPTY_PASSWD = "";
    private static final String TEST_SHORT_PASSWD = "short";
    private static final String TEST_PASSWD2 = "87654321";
    private static final String TEST_KEYNAME = "testkey";
    private static final String TEST_KEYNAME1 = "testkey1";
    private static final String TEST_KEYNAME2 = "testkey2";
    private static final String TEST_KEYVALUE = "test value";
    private static final String TEST_I18N = "\u4f60\u597d, \u4e16\u754c";
    private KeyStore mKeyStore = null;

    public KeyStoreTest() {
        super(Activity.class);
    }

    protected void setUp() throws Exception {
        this.mKeyStore = KeyStore.getInstance();
        if (this.mKeyStore.test() != 3) {
            this.mKeyStore.reset();
        }
        KeyStoreTest.assertEquals((int)3, (int)this.mKeyStore.test());
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.mKeyStore.reset();
        super.tearDown();
    }

    public void testTest() throws Exception {
        KeyStoreTest.assertEquals((int)3, (int)this.mKeyStore.test());
    }

    public void testPassword() throws Exception {
        KeyStoreTest.assertTrue((boolean)this.mKeyStore.password(TEST_PASSWD));
        KeyStoreTest.assertEquals((int)1, (int)this.mKeyStore.test());
        KeyStoreTest.assertFalse((boolean)this.mKeyStore.password(TEST_PASSWD2, TEST_PASSWD2));
        KeyStoreTest.assertTrue((boolean)this.mKeyStore.password(TEST_PASSWD, TEST_PASSWD2));
    }

    public void testPut() throws Exception {
        KeyStoreTest.assertFalse((boolean)this.mKeyStore.put(TEST_KEYNAME, TEST_KEYVALUE));
        KeyStoreTest.assertFalse((boolean)this.mKeyStore.contains(TEST_KEYNAME));
        this.mKeyStore.password(TEST_PASSWD);
        KeyStoreTest.assertTrue((boolean)this.mKeyStore.put(TEST_KEYNAME, TEST_KEYVALUE));
    }

    public void testI18n() throws Exception {
        KeyStoreTest.assertFalse((boolean)this.mKeyStore.put(TEST_I18N, TEST_I18N));
        KeyStoreTest.assertFalse((boolean)this.mKeyStore.contains(TEST_I18N));
        this.mKeyStore.password(TEST_I18N);
        KeyStoreTest.assertTrue((boolean)this.mKeyStore.put(TEST_I18N, TEST_I18N));
        KeyStoreTest.assertTrue((boolean)this.mKeyStore.contains(TEST_I18N));
    }

    public void testDelete() throws Exception {
        KeyStoreTest.assertTrue((boolean)this.mKeyStore.delete(TEST_KEYNAME));
        this.mKeyStore.password(TEST_PASSWD);
        KeyStoreTest.assertTrue((boolean)this.mKeyStore.delete(TEST_KEYNAME));
        this.mKeyStore.put(TEST_KEYNAME, TEST_KEYVALUE);
        KeyStoreTest.assertTrue((boolean)this.mKeyStore.delete(TEST_KEYNAME));
    }

    public void testContains() throws Exception {
        KeyStoreTest.assertFalse((boolean)this.mKeyStore.contains(TEST_KEYNAME));
        this.mKeyStore.password(TEST_PASSWD);
        KeyStoreTest.assertFalse((boolean)this.mKeyStore.contains(TEST_KEYNAME));
        this.mKeyStore.put(TEST_KEYNAME, TEST_KEYVALUE);
        KeyStoreTest.assertTrue((boolean)this.mKeyStore.contains(TEST_KEYNAME));
    }

    public void testSaw() throws Exception {
        String[] results = this.mKeyStore.saw(TEST_KEYNAME);
        KeyStoreTest.assertEquals((int)0, (int)results.length);
        this.mKeyStore.password(TEST_PASSWD);
        this.mKeyStore.put(TEST_KEYNAME1, TEST_KEYVALUE);
        this.mKeyStore.put(TEST_KEYNAME2, TEST_KEYVALUE);
        results = this.mKeyStore.saw(TEST_KEYNAME);
        KeyStoreTest.assertEquals((int)2, (int)results.length);
    }

    public void testLock() throws Exception {
        KeyStoreTest.assertFalse((boolean)this.mKeyStore.lock());
        this.mKeyStore.password(TEST_PASSWD);
        KeyStoreTest.assertEquals((int)1, (int)this.mKeyStore.test());
        KeyStoreTest.assertTrue((boolean)this.mKeyStore.lock());
        KeyStoreTest.assertEquals((int)2, (int)this.mKeyStore.test());
    }

    public void testUnlock() throws Exception {
        this.mKeyStore.password(TEST_PASSWD);
        KeyStoreTest.assertEquals((int)1, (int)this.mKeyStore.test());
        this.mKeyStore.lock();
        KeyStoreTest.assertFalse((boolean)this.mKeyStore.unlock(TEST_PASSWD2));
        KeyStoreTest.assertTrue((boolean)this.mKeyStore.unlock(TEST_PASSWD));
    }
}

