/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ContentResolver;
import android.os.DropBoxManager;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.StatFs;
import android.provider.Settings;
import android.test.AndroidTestCase;
import com.android.internal.os.IDropBoxManagerService;
import com.android.server.DropBoxManagerService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import java.util.zip.GZIPOutputStream;

public class DropBoxTest
extends AndroidTestCase {
    public void tearDown() throws Exception {
        ContentResolver cr = this.getContext().getContentResolver();
        Settings.Secure.putString((ContentResolver)cr, (String)"dropbox_age_seconds", (String)"");
        Settings.Secure.putString((ContentResolver)cr, (String)"dropbox_max_files", (String)"");
        Settings.Secure.putString((ContentResolver)cr, (String)"dropbox_quota_kb", (String)"");
        Settings.Secure.putString((ContentResolver)cr, (String)"dropbox:DropBoxTest", (String)"");
    }

    public void testAddText() throws Exception {
        DropBoxManager dropbox = (DropBoxManager)this.getContext().getSystemService("dropbox");
        long before = System.currentTimeMillis();
        Thread.sleep(5L);
        dropbox.addText("DropBoxTest", "TEST0");
        Thread.sleep(5L);
        long between = System.currentTimeMillis();
        Thread.sleep(5L);
        dropbox.addText("DropBoxTest", "TEST1");
        dropbox.addText("DropBoxTest", "TEST2");
        Thread.sleep(5L);
        long after = System.currentTimeMillis();
        DropBoxManager.Entry e0 = dropbox.getNextEntry("DropBoxTest", before);
        DropBoxManager.Entry e1 = dropbox.getNextEntry("DropBoxTest", e0.getTimeMillis());
        DropBoxManager.Entry e2 = dropbox.getNextEntry("DropBoxTest", e1.getTimeMillis());
        DropBoxTest.assertTrue((null == dropbox.getNextEntry("DropBoxTest", e2.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertTrue((e0.getTimeMillis() > before ? 1 : 0) != 0);
        DropBoxTest.assertTrue((e0.getTimeMillis() < between ? 1 : 0) != 0);
        DropBoxTest.assertTrue((e1.getTimeMillis() > between ? 1 : 0) != 0);
        DropBoxTest.assertTrue((e1.getTimeMillis() < e2.getTimeMillis() ? 1 : 0) != 0);
        DropBoxTest.assertTrue((e2.getTimeMillis() < after ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"TEST0", (String)e0.getText(80));
        DropBoxTest.assertEquals((String)"TEST1", (String)e1.getText(80));
        DropBoxTest.assertEquals((String)"TES", (String)e2.getText(3));
        e0.close();
        e1.close();
        e2.close();
    }

    public void testAddData() throws Exception {
        DropBoxManager dropbox = (DropBoxManager)this.getContext().getSystemService("dropbox");
        long before = System.currentTimeMillis();
        dropbox.addData("DropBoxTest", "TEST".getBytes(), 0);
        long after = System.currentTimeMillis();
        DropBoxManager.Entry e = dropbox.getNextEntry("DropBoxTest", before);
        DropBoxTest.assertTrue((null == dropbox.getNextEntry("DropBoxTest", e.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"DropBoxTest", (String)e.getTag());
        DropBoxTest.assertTrue((e.getTimeMillis() >= before ? 1 : 0) != 0);
        DropBoxTest.assertEquals((int)0, (int)e.getFlags());
        DropBoxTest.assertTrue((null == e.getText(80) ? 1 : 0) != 0);
        byte[] buf = new byte[80];
        DropBoxTest.assertEquals((String)"TEST", (String)new String(buf, 0, e.getInputStream().read(buf)));
        e.close();
    }

    public void testAddFile() throws Exception {
        File dir = this.getEmptyDir("testAddFile");
        long before = System.currentTimeMillis();
        File f0 = new File(dir, "f0.txt");
        File f1 = new File(dir, "f1.txt.gz");
        File f2 = new File(dir, "f2.dat");
        File f3 = new File(dir, "f2.dat.gz");
        FileWriter w0 = new FileWriter(f0);
        GZIPOutputStream gz1 = new GZIPOutputStream(new FileOutputStream(f1));
        FileOutputStream os2 = new FileOutputStream(f2);
        GZIPOutputStream gz3 = new GZIPOutputStream(new FileOutputStream(f3));
        w0.write("FILE0");
        gz1.write("FILE1".getBytes());
        os2.write("DATA2".getBytes());
        gz3.write("DATA3".getBytes());
        w0.close();
        gz1.close();
        os2.close();
        gz3.close();
        DropBoxManager dropbox = (DropBoxManager)this.getContext().getSystemService("dropbox");
        dropbox.addFile("DropBoxTest", f0, 2);
        dropbox.addFile("DropBoxTest", f1, 6);
        dropbox.addFile("DropBoxTest", f2, 0);
        dropbox.addFile("DropBoxTest", f3, 4);
        DropBoxManager.Entry e0 = dropbox.getNextEntry("DropBoxTest", before);
        DropBoxManager.Entry e1 = dropbox.getNextEntry("DropBoxTest", e0.getTimeMillis());
        DropBoxManager.Entry e2 = dropbox.getNextEntry("DropBoxTest", e1.getTimeMillis());
        DropBoxManager.Entry e3 = dropbox.getNextEntry("DropBoxTest", e2.getTimeMillis());
        DropBoxTest.assertTrue((null == dropbox.getNextEntry("DropBoxTest", e3.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertTrue((e0.getTimeMillis() > before ? 1 : 0) != 0);
        DropBoxTest.assertTrue((e1.getTimeMillis() > e0.getTimeMillis() ? 1 : 0) != 0);
        DropBoxTest.assertTrue((e2.getTimeMillis() > e1.getTimeMillis() ? 1 : 0) != 0);
        DropBoxTest.assertTrue((e3.getTimeMillis() > e2.getTimeMillis() ? 1 : 0) != 0);
        DropBoxTest.assertEquals((int)2, (int)e0.getFlags());
        DropBoxTest.assertEquals((int)2, (int)e1.getFlags());
        DropBoxTest.assertEquals((int)0, (int)e2.getFlags());
        DropBoxTest.assertEquals((int)0, (int)e3.getFlags());
        DropBoxTest.assertEquals((String)"FILE0", (String)e0.getText(80));
        byte[] buf1 = new byte[80];
        DropBoxTest.assertEquals((String)"FILE1", (String)new String(buf1, 0, e1.getInputStream().read(buf1)));
        DropBoxTest.assertTrue((null == e2.getText(80) ? 1 : 0) != 0);
        byte[] buf2 = new byte[80];
        DropBoxTest.assertEquals((String)"DATA2", (String)new String(buf2, 0, e2.getInputStream().read(buf2)));
        DropBoxTest.assertTrue((null == e3.getText(80) ? 1 : 0) != 0);
        byte[] buf3 = new byte[80];
        DropBoxTest.assertEquals((String)"DATA3", (String)new String(buf3, 0, e3.getInputStream().read(buf3)));
        e0.close();
        e1.close();
        e2.close();
        e3.close();
    }

    public void testAddEntriesInTheFuture() throws Exception {
        File dir = this.getEmptyDir("testAddEntriesInTheFuture");
        long before = System.currentTimeMillis();
        FileWriter w0 = new FileWriter(new File(dir, "DropBoxTest@" + (before + 5000L) + ".txt"));
        w0.write("FUTURE0");
        w0.close();
        FileWriter w1 = new FileWriter(new File(dir, "DropBoxTest@" + (before + 100000L) + ".txt"));
        w1.write("FUTURE1");
        w1.close();
        File f2 = new File(dir, "DropBoxTest@" + (before + 100001L) + ".txt.gz");
        GZIPOutputStream gz2 = new GZIPOutputStream(new FileOutputStream(f2));
        gz2.write("FUTURE2".getBytes());
        gz2.close();
        new FileOutputStream(new File(dir, "DropBoxTest@" + (before + 100002L) + ".lost")).close();
        DropBoxManagerService service = new DropBoxManagerService(this.getContext(), dir);
        DropBoxManager dropbox = new DropBoxManager((IDropBoxManagerService)service);
        DropBoxManager.Entry e0 = dropbox.getNextEntry(null, before);
        DropBoxManager.Entry e1 = dropbox.getNextEntry(null, e0.getTimeMillis());
        DropBoxManager.Entry e2 = dropbox.getNextEntry(null, e1.getTimeMillis());
        DropBoxManager.Entry e3 = dropbox.getNextEntry(null, e2.getTimeMillis());
        DropBoxTest.assertTrue((null == dropbox.getNextEntry(null, e3.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"FUTURE0", (String)e0.getText(80));
        DropBoxTest.assertEquals((String)"FUTURE1", (String)e1.getText(80));
        DropBoxTest.assertEquals((String)"FUTURE2", (String)e2.getText(80));
        DropBoxTest.assertEquals(null, (String)e3.getText(80));
        DropBoxTest.assertEquals((long)(before + 5000L), (long)e0.getTimeMillis());
        DropBoxTest.assertEquals((long)(before + 100000L), (long)e1.getTimeMillis());
        DropBoxTest.assertEquals((long)(before + 100001L), (long)e2.getTimeMillis());
        DropBoxTest.assertEquals((long)(before + 100002L), (long)e3.getTimeMillis());
        e0.close();
        e1.close();
        e2.close();
        e3.close();
        dropbox.addText("NotDropBoxTest", "FUTURE");
        e0 = dropbox.getNextEntry(null, before);
        e1 = dropbox.getNextEntry(null, e0.getTimeMillis());
        e2 = dropbox.getNextEntry(null, e1.getTimeMillis());
        e3 = dropbox.getNextEntry(null, e2.getTimeMillis());
        DropBoxTest.assertTrue((null == dropbox.getNextEntry("DropBoxTest", e3.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"FUTURE0", (String)e0.getText(80));
        DropBoxTest.assertEquals((String)"FUTURE1", (String)e1.getText(80));
        DropBoxTest.assertEquals((String)"FUTURE2", (String)e2.getText(80));
        DropBoxTest.assertEquals(null, (String)e3.getText(80));
        DropBoxTest.assertEquals((long)(before + 5000L), (long)e0.getTimeMillis());
        DropBoxTest.assertEquals((long)(before + 5001L), (long)e1.getTimeMillis());
        DropBoxTest.assertEquals((long)(before + 5002L), (long)e2.getTimeMillis());
        DropBoxTest.assertEquals((long)(before + 5003L), (long)e3.getTimeMillis());
        e0.close();
        e1.close();
        e2.close();
        e3.close();
        service.stop();
    }

    public void testIsTagEnabled() throws Exception {
        DropBoxManager dropbox = (DropBoxManager)this.getContext().getSystemService("dropbox");
        long before = System.currentTimeMillis();
        dropbox.addText("DropBoxTest", "TEST-ENABLED");
        DropBoxTest.assertTrue((boolean)dropbox.isTagEnabled("DropBoxTest"));
        ContentResolver cr = this.getContext().getContentResolver();
        Settings.Secure.putString((ContentResolver)cr, (String)"dropbox:DropBoxTest", (String)"disabled");
        dropbox.addText("DropBoxTest", "TEST-DISABLED");
        DropBoxTest.assertFalse((boolean)dropbox.isTagEnabled("DropBoxTest"));
        Settings.Secure.putString((ContentResolver)cr, (String)"dropbox:DropBoxTest", (String)"");
        dropbox.addText("DropBoxTest", "TEST-ENABLED-AGAIN");
        DropBoxTest.assertTrue((boolean)dropbox.isTagEnabled("DropBoxTest"));
        DropBoxManager.Entry e0 = dropbox.getNextEntry("DropBoxTest", before);
        DropBoxManager.Entry e1 = dropbox.getNextEntry("DropBoxTest", e0.getTimeMillis());
        DropBoxTest.assertTrue((null == dropbox.getNextEntry("DropBoxTest", e1.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"TEST-ENABLED", (String)e0.getText(80));
        DropBoxTest.assertEquals((String)"TEST-ENABLED-AGAIN", (String)e1.getText(80));
        e0.close();
        e1.close();
    }

    public void testGetNextEntry() throws Exception {
        File dir = this.getEmptyDir("testGetNextEntry");
        DropBoxManagerService service = new DropBoxManagerService(this.getContext(), dir);
        DropBoxManager dropbox = new DropBoxManager((IDropBoxManagerService)service);
        long before = System.currentTimeMillis();
        dropbox.addText("DropBoxTest.A", "A0");
        dropbox.addText("DropBoxTest.B", "B0");
        dropbox.addText("DropBoxTest.A", "A1");
        DropBoxManager.Entry a0 = dropbox.getNextEntry("DropBoxTest.A", before);
        DropBoxManager.Entry a1 = dropbox.getNextEntry("DropBoxTest.A", a0.getTimeMillis());
        DropBoxTest.assertTrue((null == dropbox.getNextEntry("DropBoxTest.A", a1.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxManager.Entry b0 = dropbox.getNextEntry("DropBoxTest.B", before);
        DropBoxTest.assertTrue((null == dropbox.getNextEntry("DropBoxTest.B", b0.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxManager.Entry x0 = dropbox.getNextEntry(null, before);
        DropBoxManager.Entry x1 = dropbox.getNextEntry(null, x0.getTimeMillis());
        DropBoxManager.Entry x2 = dropbox.getNextEntry(null, x1.getTimeMillis());
        DropBoxTest.assertTrue((null == dropbox.getNextEntry(null, x2.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"DropBoxTest.A", (String)a0.getTag());
        DropBoxTest.assertEquals((String)"DropBoxTest.A", (String)a1.getTag());
        DropBoxTest.assertEquals((String)"A0", (String)a0.getText(80));
        DropBoxTest.assertEquals((String)"A1", (String)a1.getText(80));
        DropBoxTest.assertEquals((String)"DropBoxTest.B", (String)b0.getTag());
        DropBoxTest.assertEquals((String)"B0", (String)b0.getText(80));
        DropBoxTest.assertEquals((String)"DropBoxTest.A", (String)x0.getTag());
        DropBoxTest.assertEquals((String)"DropBoxTest.B", (String)x1.getTag());
        DropBoxTest.assertEquals((String)"DropBoxTest.A", (String)x2.getTag());
        DropBoxTest.assertEquals((String)"A0", (String)x0.getText(80));
        DropBoxTest.assertEquals((String)"B0", (String)x1.getText(80));
        DropBoxTest.assertEquals((String)"A1", (String)x2.getText(80));
        a0.close();
        a1.close();
        b0.close();
        x0.close();
        x1.close();
        x2.close();
        service.stop();
    }

    public void testSizeLimits() throws Exception {
        File dir = this.getEmptyDir("testSizeLimits");
        int blockSize = new StatFs(dir.getPath()).getBlockSize();
        int kb = blockSize * 10 / 1024;
        ContentResolver cr = this.getContext().getContentResolver();
        Settings.Secure.putString((ContentResolver)cr, (String)"dropbox_quota_kb", (String)Integer.toString(kb));
        int overhead = 64;
        long before = System.currentTimeMillis();
        DropBoxManagerService service = new DropBoxManagerService(this.getContext(), dir);
        DropBoxManager dropbox = new DropBoxManager((IDropBoxManagerService)service);
        this.addRandomEntry(dropbox, "DropBoxTest0", blockSize - 64);
        this.addRandomEntry(dropbox, "DropBoxTest0", blockSize - 64);
        this.addRandomEntry(dropbox, "DropBoxTest1", blockSize - 64);
        this.addRandomEntry(dropbox, "DropBoxTest1", blockSize - 64);
        this.addRandomEntry(dropbox, "DropBoxTest1", blockSize * 2 - 64);
        this.addRandomEntry(dropbox, "DropBoxTest1", blockSize - 64);
        this.addRandomEntry(dropbox, "DropBoxTest1", blockSize * 20 - 64);
        this.addRandomEntry(dropbox, "DropBoxTest2", blockSize * 4 - 64);
        this.addRandomEntry(dropbox, "DropBoxTest2", blockSize - 64);
        this.addRandomEntry(dropbox, "DropBoxTest2", blockSize - 64);
        DropBoxManager.Entry e0 = dropbox.getNextEntry(null, before);
        DropBoxManager.Entry e1 = dropbox.getNextEntry(null, e0.getTimeMillis());
        DropBoxManager.Entry e2 = dropbox.getNextEntry(null, e1.getTimeMillis());
        DropBoxManager.Entry e3 = dropbox.getNextEntry(null, e2.getTimeMillis());
        DropBoxManager.Entry e4 = dropbox.getNextEntry(null, e3.getTimeMillis());
        DropBoxManager.Entry e5 = dropbox.getNextEntry(null, e4.getTimeMillis());
        DropBoxManager.Entry e6 = dropbox.getNextEntry(null, e5.getTimeMillis());
        DropBoxManager.Entry e7 = dropbox.getNextEntry(null, e6.getTimeMillis());
        DropBoxManager.Entry e8 = dropbox.getNextEntry(null, e7.getTimeMillis());
        DropBoxManager.Entry e9 = dropbox.getNextEntry(null, e8.getTimeMillis());
        DropBoxTest.assertTrue((null == dropbox.getNextEntry(null, e9.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"DropBoxTest0", (String)e0.getTag());
        DropBoxTest.assertEquals((String)"DropBoxTest0", (String)e1.getTag());
        DropBoxTest.assertEquals((int)(blockSize - 64), (int)this.getEntrySize(e0));
        DropBoxTest.assertEquals((int)(blockSize - 64), (int)this.getEntrySize(e1));
        DropBoxTest.assertEquals((String)"DropBoxTest1", (String)e2.getTag());
        DropBoxTest.assertEquals((String)"DropBoxTest1", (String)e3.getTag());
        DropBoxTest.assertEquals((String)"DropBoxTest1", (String)e4.getTag());
        DropBoxTest.assertEquals((String)"DropBoxTest1", (String)e5.getTag());
        DropBoxTest.assertEquals((String)"DropBoxTest1", (String)e6.getTag());
        DropBoxTest.assertEquals((int)-1, (int)this.getEntrySize(e2));
        DropBoxTest.assertEquals((int)(blockSize - 64), (int)this.getEntrySize(e3));
        DropBoxTest.assertEquals((int)(blockSize * 2 - 64), (int)this.getEntrySize(e4));
        DropBoxTest.assertEquals((int)(blockSize - 64), (int)this.getEntrySize(e5));
        DropBoxTest.assertEquals((int)-1, (int)this.getEntrySize(e6));
        DropBoxTest.assertEquals((String)"DropBoxTest2", (String)e7.getTag());
        DropBoxTest.assertEquals((String)"DropBoxTest2", (String)e8.getTag());
        DropBoxTest.assertEquals((String)"DropBoxTest2", (String)e9.getTag());
        DropBoxTest.assertEquals((int)-1, (int)this.getEntrySize(e7));
        DropBoxTest.assertEquals((int)(blockSize - 64), (int)this.getEntrySize(e8));
        DropBoxTest.assertEquals((int)(blockSize - 64), (int)this.getEntrySize(e9));
        e0.close();
        e1.close();
        e2.close();
        e3.close();
        e4.close();
        e5.close();
        e6.close();
        e7.close();
        e8.close();
        e9.close();
        DropBoxManager.Entry t0 = dropbox.getNextEntry("DropBoxTest1", before);
        DropBoxManager.Entry t1 = dropbox.getNextEntry("DropBoxTest1", t0.getTimeMillis());
        DropBoxManager.Entry t2 = dropbox.getNextEntry("DropBoxTest1", t1.getTimeMillis());
        DropBoxTest.assertTrue((null == dropbox.getNextEntry("DropBoxTest1", t2.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"DropBoxTest1", (String)t0.getTag());
        DropBoxTest.assertEquals((String)"DropBoxTest1", (String)t1.getTag());
        DropBoxTest.assertEquals((String)"DropBoxTest1", (String)t2.getTag());
        DropBoxTest.assertEquals((int)(blockSize - 64), (int)this.getEntrySize(t0));
        DropBoxTest.assertEquals((int)(blockSize * 2 - 64), (int)this.getEntrySize(t1));
        DropBoxTest.assertEquals((int)(blockSize - 64), (int)this.getEntrySize(t2));
        t0.close();
        t1.close();
        t2.close();
        service.stop();
    }

    public void testAgeLimits() throws Exception {
        File dir = this.getEmptyDir("testAgeLimits");
        int blockSize = new StatFs(dir.getPath()).getBlockSize();
        int kb = blockSize * 10 / 1024;
        ContentResolver cr = this.getContext().getContentResolver();
        Settings.Secure.putString((ContentResolver)cr, (String)"dropbox_age_seconds", (String)"1");
        Settings.Secure.putString((ContentResolver)cr, (String)"dropbox_quota_kb", (String)Integer.toString(kb));
        long before = System.currentTimeMillis();
        DropBoxManagerService service = new DropBoxManagerService(this.getContext(), dir);
        DropBoxManager dropbox = new DropBoxManager((IDropBoxManagerService)service);
        dropbox.addText("DropBoxTest", "TEST");
        this.addRandomEntry(dropbox, "DropBoxTest", blockSize * 20);
        DropBoxManager.Entry e0 = dropbox.getNextEntry(null, before);
        DropBoxManager.Entry e1 = dropbox.getNextEntry(null, e0.getTimeMillis());
        DropBoxTest.assertTrue((null == dropbox.getNextEntry(null, e1.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"TEST", (String)e0.getText(80));
        DropBoxTest.assertEquals(null, (String)e1.getText(80));
        DropBoxTest.assertEquals((int)-1, (int)this.getEntrySize(e1));
        e0.close();
        e1.close();
        Thread.sleep(2000L);
        dropbox.addText("DropBoxTest", "TEST1");
        e0 = dropbox.getNextEntry(null, before);
        DropBoxTest.assertTrue((null == dropbox.getNextEntry(null, e0.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"TEST1", (String)e0.getText(80));
        e0.close();
    }

    public void testFileCountLimits() throws Exception {
        File dir = this.getEmptyDir("testFileCountLimits");
        DropBoxManagerService service = new DropBoxManagerService(this.getContext(), dir);
        DropBoxManager dropbox = new DropBoxManager((IDropBoxManagerService)service);
        dropbox.addText("DropBoxTest", "TEST0");
        dropbox.addText("DropBoxTest", "TEST1");
        dropbox.addText("DropBoxTest", "TEST2");
        dropbox.addText("DropBoxTest", "TEST3");
        dropbox.addText("DropBoxTest", "TEST4");
        dropbox.addText("DropBoxTest", "TEST5");
        DropBoxManager.Entry e0 = dropbox.getNextEntry(null, 0L);
        DropBoxManager.Entry e1 = dropbox.getNextEntry(null, e0.getTimeMillis());
        DropBoxManager.Entry e2 = dropbox.getNextEntry(null, e1.getTimeMillis());
        DropBoxManager.Entry e3 = dropbox.getNextEntry(null, e2.getTimeMillis());
        DropBoxManager.Entry e4 = dropbox.getNextEntry(null, e3.getTimeMillis());
        DropBoxManager.Entry e5 = dropbox.getNextEntry(null, e4.getTimeMillis());
        DropBoxTest.assertTrue((null == dropbox.getNextEntry(null, e5.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"TEST0", (String)e0.getText(80));
        DropBoxTest.assertEquals((String)"TEST5", (String)e5.getText(80));
        e0.close();
        e1.close();
        e2.close();
        e3.close();
        e4.close();
        e5.close();
        ContentResolver cr = this.getContext().getContentResolver();
        Settings.Secure.putString((ContentResolver)cr, (String)"dropbox_max_files", (String)"3");
        dropbox.addText("DropBoxTest", "TEST6");
        DropBoxManager.Entry f0 = dropbox.getNextEntry(null, 0L);
        DropBoxManager.Entry f1 = dropbox.getNextEntry(null, f0.getTimeMillis());
        DropBoxManager.Entry f2 = dropbox.getNextEntry(null, f1.getTimeMillis());
        DropBoxTest.assertTrue((null == dropbox.getNextEntry(null, f2.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"TEST4", (String)f0.getText(80));
        DropBoxTest.assertEquals((String)"TEST5", (String)f1.getText(80));
        DropBoxTest.assertEquals((String)"TEST6", (String)f2.getText(80));
        f0.close();
        f1.close();
        f2.close();
    }

    public void testCreateDropBoxManagerWithInvalidDirectory() throws Exception {
        File dir = new File(this.getEmptyDir("testCreateDropBoxManagerWith"), "InvalidDirectory");
        new FileOutputStream(dir).close();
        DropBoxManagerService service = new DropBoxManagerService(this.getContext(), dir);
        DropBoxManager dropbox = new DropBoxManager((IDropBoxManagerService)service);
        dropbox.addText("DropBoxTest", "should be ignored");
        dropbox.addData("DropBoxTest", "should be ignored".getBytes(), 0);
        DropBoxTest.assertTrue((null == dropbox.getNextEntry("DropBoxTest", 0L) ? 1 : 0) != 0);
        dir.delete();
        dropbox.addText("DropBoxTest", "TEST");
        DropBoxManager.Entry e = dropbox.getNextEntry("DropBoxTest", 0L);
        DropBoxTest.assertTrue((null == dropbox.getNextEntry("DropBoxTest", e.getTimeMillis()) ? 1 : 0) != 0);
        DropBoxTest.assertEquals((String)"DropBoxTest", (String)e.getTag());
        DropBoxTest.assertEquals((String)"TEST", (String)e.getText(80));
        e.close();
        service.stop();
    }

    public void testDropBoxEntrySerialization() throws Exception {
        Parcel parcel = Parcel.obtain();
        File dir = this.getEmptyDir("testDropBoxEntrySerialization");
        new DropBoxManager.Entry("empty", 1000000L).writeToParcel(parcel, 0);
        new DropBoxManager.Entry("string", 2000000L, "String Value").writeToParcel(parcel, 0);
        new DropBoxManager.Entry("bytes", 3000000L, "Bytes Value".getBytes(), 2).writeToParcel(parcel, 0);
        new DropBoxManager.Entry("zerobytes", 4000000L, new byte[0], 0).writeToParcel(parcel, 0);
        new DropBoxManager.Entry("emptybytes", 5000000L, (byte[])null, 1).writeToParcel(parcel, 0);
        try {
            new DropBoxManager.Entry("badbytes", 99999L, "Bad Bytes Value".getBytes(), 1).writeToParcel(parcel, 0);
            DropBoxTest.fail((String)"IllegalArgumentException expected for non-null byte[] and IS_EMPTY flags");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new DropBoxManager.Entry("badbytes", 99999L, (byte[])null, 0).writeToParcel(parcel, 0);
            DropBoxTest.fail((String)"IllegalArgumentException expected for null byte[] and non-IS_EMPTY flags");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        File f = new File(dir, "file.dat");
        FileOutputStream os = new FileOutputStream(f);
        os.write("File Value".getBytes());
        os.close();
        new DropBoxManager.Entry("file", 6000000L, f, 2).writeToParcel(parcel, 1);
        new DropBoxManager.Entry("binfile", 7000000L, f, 0).writeToParcel(parcel, 1);
        new DropBoxManager.Entry("emptyfile", 8000000L, (ParcelFileDescriptor)null, 1).writeToParcel(parcel, 0);
        try {
            new DropBoxManager.Entry("badfile", 99999L, new File(dir, "nonexist.dat"), 0);
            DropBoxTest.fail((String)"IOException expected for nonexistent file");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            new DropBoxManager.Entry("badfile", 99999L, f, 1).writeToParcel(parcel, 0);
            DropBoxTest.fail((String)"IllegalArgumentException expected for non-null file and IS_EMPTY flags");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new DropBoxManager.Entry("badfile", 99999L, (ParcelFileDescriptor)null, 0);
            DropBoxTest.fail((String)"IllegalArgumentException expected for null PFD and non-IS_EMPTY flags");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        File gz = new File(dir, "file.gz");
        GZIPOutputStream gzout = new GZIPOutputStream(new FileOutputStream(gz));
        gzout.write("Gzip File Value".getBytes());
        gzout.close();
        new DropBoxManager.Entry("gzipfile", 9000000L, gz, 6).writeToParcel(parcel, 1);
        new DropBoxManager.Entry("gzipbinfile", 10000000L, gz, 4).writeToParcel(parcel, 1);
        parcel.setDataPosition(0);
        DropBoxManager.Entry e = (DropBoxManager.Entry)DropBoxManager.Entry.CREATOR.createFromParcel(parcel);
        DropBoxTest.assertEquals((String)"empty", (String)e.getTag());
        DropBoxTest.assertEquals((long)1000000L, (long)e.getTimeMillis());
        DropBoxTest.assertEquals((int)1, (int)e.getFlags());
        DropBoxTest.assertEquals(null, (String)e.getText(100));
        DropBoxTest.assertEquals(null, (Object)e.getInputStream());
        e.close();
        e = (DropBoxManager.Entry)DropBoxManager.Entry.CREATOR.createFromParcel(parcel);
        DropBoxTest.assertEquals((String)"string", (String)e.getTag());
        DropBoxTest.assertEquals((long)2000000L, (long)e.getTimeMillis());
        DropBoxTest.assertEquals((int)2, (int)e.getFlags());
        DropBoxTest.assertEquals((String)"String Value", (String)e.getText(100));
        DropBoxTest.assertEquals((String)"String Value", (String)new BufferedReader(new InputStreamReader(e.getInputStream())).readLine());
        e.close();
        e = (DropBoxManager.Entry)DropBoxManager.Entry.CREATOR.createFromParcel(parcel);
        DropBoxTest.assertEquals((String)"bytes", (String)e.getTag());
        DropBoxTest.assertEquals((long)3000000L, (long)e.getTimeMillis());
        DropBoxTest.assertEquals((int)2, (int)e.getFlags());
        DropBoxTest.assertEquals((String)"Bytes Value", (String)e.getText(100));
        e.close();
        e = (DropBoxManager.Entry)DropBoxManager.Entry.CREATOR.createFromParcel(parcel);
        DropBoxTest.assertEquals((String)"zerobytes", (String)e.getTag());
        DropBoxTest.assertEquals((long)4000000L, (long)e.getTimeMillis());
        DropBoxTest.assertEquals((int)0, (int)e.getFlags());
        DropBoxTest.assertEquals(null, (String)e.getText(100));
        DropBoxTest.assertEquals(null, (String)new BufferedReader(new InputStreamReader(e.getInputStream())).readLine());
        e.close();
        e = (DropBoxManager.Entry)DropBoxManager.Entry.CREATOR.createFromParcel(parcel);
        DropBoxTest.assertEquals((String)"emptybytes", (String)e.getTag());
        DropBoxTest.assertEquals((long)5000000L, (long)e.getTimeMillis());
        DropBoxTest.assertEquals((int)1, (int)e.getFlags());
        DropBoxTest.assertEquals(null, (String)e.getText(100));
        DropBoxTest.assertEquals(null, (Object)e.getInputStream());
        e.close();
        e = (DropBoxManager.Entry)DropBoxManager.Entry.CREATOR.createFromParcel(parcel);
        DropBoxTest.assertEquals((String)"file", (String)e.getTag());
        DropBoxTest.assertEquals((long)6000000L, (long)e.getTimeMillis());
        DropBoxTest.assertEquals((int)2, (int)e.getFlags());
        DropBoxTest.assertEquals((String)"File Value", (String)e.getText(100));
        e.close();
        e = (DropBoxManager.Entry)DropBoxManager.Entry.CREATOR.createFromParcel(parcel);
        DropBoxTest.assertEquals((String)"binfile", (String)e.getTag());
        DropBoxTest.assertEquals((long)7000000L, (long)e.getTimeMillis());
        DropBoxTest.assertEquals((int)0, (int)e.getFlags());
        DropBoxTest.assertEquals(null, (String)e.getText(100));
        DropBoxTest.assertEquals((String)"File Value", (String)new BufferedReader(new InputStreamReader(e.getInputStream())).readLine());
        e.close();
        e = (DropBoxManager.Entry)DropBoxManager.Entry.CREATOR.createFromParcel(parcel);
        DropBoxTest.assertEquals((String)"emptyfile", (String)e.getTag());
        DropBoxTest.assertEquals((long)8000000L, (long)e.getTimeMillis());
        DropBoxTest.assertEquals((int)1, (int)e.getFlags());
        DropBoxTest.assertEquals(null, (String)e.getText(100));
        DropBoxTest.assertEquals(null, (Object)e.getInputStream());
        e.close();
        e = (DropBoxManager.Entry)DropBoxManager.Entry.CREATOR.createFromParcel(parcel);
        DropBoxTest.assertEquals((String)"gzipfile", (String)e.getTag());
        DropBoxTest.assertEquals((long)9000000L, (long)e.getTimeMillis());
        DropBoxTest.assertEquals((int)2, (int)e.getFlags());
        DropBoxTest.assertEquals((String)"Gzip File Value", (String)e.getText(100));
        e.close();
        e = (DropBoxManager.Entry)DropBoxManager.Entry.CREATOR.createFromParcel(parcel);
        DropBoxTest.assertEquals((String)"gzipbinfile", (String)e.getTag());
        DropBoxTest.assertEquals((long)10000000L, (long)e.getTimeMillis());
        DropBoxTest.assertEquals((int)0, (int)e.getFlags());
        DropBoxTest.assertEquals(null, (String)e.getText(100));
        DropBoxTest.assertEquals((String)"Gzip File Value", (String)new BufferedReader(new InputStreamReader(e.getInputStream())).readLine());
        e.close();
        DropBoxTest.assertEquals((int)0, (int)parcel.dataAvail());
        parcel.recycle();
    }

    public void testDropBoxEntrySerializationDoesntLeakFileDescriptors() throws Exception {
        File dir = this.getEmptyDir("testDropBoxEntrySerialization");
        File f = new File(dir, "file.dat");
        FileOutputStream os = new FileOutputStream(f);
        os.write("File Value".getBytes());
        os.close();
        int before = this.countOpenFiles();
        DropBoxTest.assertTrue((before > 0 ? 1 : 0) != 0);
        for (int i = 0; i < 1000; ++i) {
            Parcel parcel = Parcel.obtain();
            new DropBoxManager.Entry("file", 1000000L, f, 0).writeToParcel(parcel, 1);
            parcel.setDataPosition(0);
            DropBoxManager.Entry e = (DropBoxManager.Entry)DropBoxManager.Entry.CREATOR.createFromParcel(parcel);
            DropBoxTest.assertEquals((String)"file", (String)e.getTag());
            e.close();
            parcel.recycle();
        }
        int after = this.countOpenFiles();
        DropBoxTest.assertTrue((after > 0 ? 1 : 0) != 0);
        DropBoxTest.assertTrue((after < before + 20 ? 1 : 0) != 0);
    }

    private void addRandomEntry(DropBoxManager dropbox, String tag, int size) throws Exception {
        byte[] bytes = new byte[size];
        new Random(System.currentTimeMillis()).nextBytes(bytes);
        File f = new File(this.getEmptyDir("addRandomEntry"), "random.dat");
        FileOutputStream os = new FileOutputStream(f);
        os.write(bytes);
        os.close();
        dropbox.addFile(tag, f, 0);
    }

    private int getEntrySize(DropBoxManager.Entry e) throws Exception {
        InputStream is = e.getInputStream();
        if (is == null) {
            return -1;
        }
        int length = 0;
        while (is.read() != -1) {
            ++length;
        }
        return length;
    }

    private void recursiveDelete(File file) {
        if (!file.delete() && file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.recursiveDelete(f);
            }
            file.delete();
        }
    }

    private File getEmptyDir(String name) {
        File dir = this.getContext().getDir("DropBoxTest." + name, 0);
        for (File f : dir.listFiles()) {
            this.recursiveDelete(f);
        }
        DropBoxTest.assertTrue((dir.listFiles().length == 0 ? 1 : 0) != 0);
        return dir;
    }

    private int countOpenFiles() {
        return new File("/proc/" + Process.myPid() + "/fd").listFiles().length;
    }
}

