/*
 * Decompiled with CFR 0.152.
 */
package coretestutils.http;

import android.util.Log;
import coretestutils.http.MockResponse;
import coretestutils.http.RecordedRequest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockWebServer {
    static final String ASCII = "US-ASCII";
    static final String LOG_TAG = "coretestutils.http.MockWebServer";
    private final BlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue<RecordedRequest>();
    private final BlockingQueue<MockResponse> responseQueue = new LinkedBlockingQueue<MockResponse>();
    private int bodyLimit = Integer.MAX_VALUE;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final Queue<Future<?>> futures = new LinkedList();
    private final Object downloadPauseLock = new Object();
    private volatile boolean downloadResume = false;
    private int port = -1;

    public int getPort() {
        if (this.port == -1) {
            throw new IllegalStateException("Cannot retrieve port before calling play()");
        }
        return this.port;
    }

    public URL getUrl(String path) throws MalformedURLException {
        return new URL("http://localhost:" + this.getPort() + path);
    }

    public void setBodyLimit(int maxBodyLength) {
        this.bodyLimit = maxBodyLength;
    }

    public void enqueue(MockResponse response) {
        this.responseQueue.add(response);
    }

    public RecordedRequest takeRequest() throws InterruptedException {
        return this.requestQueue.take();
    }

    public RecordedRequest takeRequestWithTimeout(long timeoutMillis) throws InterruptedException {
        return this.requestQueue.poll(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public List<RecordedRequest> drainRequests() {
        ArrayList<RecordedRequest> requests = new ArrayList<RecordedRequest>();
        this.requestQueue.drainTo(requests);
        return requests;
    }

    public void play() throws IOException {
        this.play(0);
    }

    public void play(int portNumber) throws IOException {
        final ServerSocket ss = new ServerSocket(portNumber);
        ss.setReuseAddress(true);
        this.port = ss.getLocalPort();
        this.submitCallable(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int count = 0;
                while (true) {
                    if (count > 0 && MockWebServer.this.responseQueue.isEmpty()) {
                        ss.close();
                        MockWebServer.this.executor.shutdown();
                        return null;
                    }
                    MockWebServer.this.serveConnection(ss.accept());
                    ++count;
                }
            }
        });
    }

    private void serveConnection(final Socket s) {
        this.submitCallable(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BufferedInputStream in = new BufferedInputStream(s.getInputStream());
                BufferedOutputStream out = new BufferedOutputStream(s.getOutputStream());
                int sequenceNumber = 0;
                while (true) {
                    RecordedRequest request;
                    if ((request = MockWebServer.this.readRequest(in, sequenceNumber)) == null) {
                        if (sequenceNumber != 0) break;
                        throw new IllegalStateException("Connection without any request!");
                    }
                    MockWebServer.this.requestQueue.add(request);
                    MockResponse response = MockWebServer.this.computeResponse(request);
                    MockWebServer.this.writeResponse(out, response);
                    if (response.shouldCloseConnectionAfter()) break;
                    ++sequenceNumber;
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
                return null;
            }
        });
    }

    private void submitCallable(Callable<?> callable) {
        Future<?> future = this.executor.submit(callable);
        this.futures.add(future);
    }

    public void checkForExceptions() throws ExecutionException, InterruptedException {
        int originalSize = this.futures.size();
        for (int i = 0; i < originalSize; ++i) {
            Future<?> future = this.futures.remove();
            try {
                future.get(0L, TimeUnit.SECONDS);
                continue;
            }
            catch (TimeoutException e) {
                this.futures.add(future);
            }
        }
    }

    private RecordedRequest readRequest(InputStream in, int sequenceNumber) throws IOException {
        String header;
        String request = this.readAsciiUntilCrlf(in);
        if (request.equals("")) {
            return null;
        }
        ArrayList<String> headers = new ArrayList<String>();
        int contentLength = -1;
        boolean chunked = false;
        while (!(header = this.readAsciiUntilCrlf(in)).equals("")) {
            headers.add(header);
            String lowercaseHeader = header.toLowerCase();
            if (contentLength == -1 && lowercaseHeader.startsWith("content-length:")) {
                contentLength = Integer.parseInt(header.substring(15).trim());
            }
            if (!lowercaseHeader.startsWith("transfer-encoding:") || !lowercaseHeader.substring(18).trim().equals("chunked")) continue;
            chunked = true;
        }
        boolean hasBody = false;
        TruncatingOutputStream requestBody = new TruncatingOutputStream();
        ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
        if (contentLength != -1) {
            hasBody = true;
            this.transfer(contentLength, in, requestBody);
        } else if (chunked) {
            hasBody = true;
            while (true) {
                int chunkSize;
                if ((chunkSize = Integer.parseInt(this.readAsciiUntilCrlf(in).trim(), 16)) == 0) {
                    this.readEmptyLine(in);
                    break;
                }
                chunkSizes.add(chunkSize);
                this.transfer(chunkSize, in, requestBody);
                this.readEmptyLine(in);
            }
        }
        if (request.startsWith("GET ")) {
            if (hasBody) {
                throw new IllegalArgumentException("GET requests should not have a body!");
            }
        } else if (request.startsWith("POST ")) {
            if (!hasBody) {
                throw new IllegalArgumentException("POST requests must have a body!");
            }
        } else {
            throw new UnsupportedOperationException("Unexpected method: " + request);
        }
        return new RecordedRequest(request, headers, chunkSizes, requestBody.numBytesReceived, requestBody.toByteArray(), sequenceNumber);
    }

    private MockResponse computeResponse(RecordedRequest request) throws InterruptedException {
        if (this.responseQueue.isEmpty()) {
            throw new IllegalStateException("Unexpected request: " + request);
        }
        return this.responseQueue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(OutputStream out, MockResponse response) throws IOException {
        out.write((response.getStatus() + "\r\n").getBytes(ASCII));
        boolean doCloseConnectionAfterHeader = response.getCloseConnectionAfterHeader() != null;
        String closeConnectionAfterHeader = response.getCloseConnectionAfterHeader();
        for (String header : response.getHeaders()) {
            out.write((header + "\r\n").getBytes(ASCII));
            if (!doCloseConnectionAfterHeader || !header.startsWith(closeConnectionAfterHeader)) continue;
            Log.i((String)LOG_TAG, (String)("Closing connection after header" + header));
            break;
        }
        if (!doCloseConnectionAfterHeader) {
            out.write("\r\n".getBytes(ASCII));
            InputStream body = response.getBody();
            int READ_BLOCK_SIZE = 10000;
            byte[] currentBlock = new byte[10000];
            int currentBlockSize = 0;
            int writtenSoFar = 0;
            boolean shouldPause = response.getShouldPause();
            boolean shouldClose = response.getShouldClose();
            int pause = response.getPauseConnectionAfterXBytes();
            int close = response.getCloseConnectionAfterXBytes();
            if (shouldPause && shouldClose && pause > close) {
                shouldPause = false;
            }
            while ((currentBlockSize = body.read(currentBlock)) != -1) {
                int startIndex = 0;
                int writeLength = currentBlockSize;
                if (shouldPause && writtenSoFar + currentBlockSize >= pause) {
                    writeLength = pause - writtenSoFar;
                    out.write(currentBlock, 0, writeLength);
                    out.flush();
                    writtenSoFar += writeLength;
                    try {
                        Log.i((String)LOG_TAG, (String)("Pausing connection after " + pause + " bytes"));
                        Object object = this.downloadPauseLock;
                        synchronized (object) {
                            while (!this.downloadResume) {
                                this.downloadPauseLock.wait();
                            }
                            this.downloadResume = false;
                        }
                    }
                    catch (InterruptedException e) {
                        Log.e((String)LOG_TAG, (String)"Server was interrupted during pause in download.");
                    }
                    startIndex = writeLength;
                    writeLength = currentBlockSize - writeLength;
                }
                if (shouldClose && writtenSoFar + writeLength > close) {
                    writeLength = close - writtenSoFar;
                    out.write(currentBlock, startIndex, writeLength);
                    writtenSoFar += writeLength;
                    Log.i((String)LOG_TAG, (String)("Closing connection after " + close + " bytes"));
                    break;
                }
                out.write(currentBlock, startIndex, writeLength);
                writtenSoFar += writeLength;
            }
        }
        out.flush();
    }

    private void transfer(int length, InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        while (length > 0) {
            int count = in.read(buffer, 0, Math.min(buffer.length, length));
            if (count == -1) {
                return;
            }
            out.write(buffer, 0, count);
            length -= count;
        }
    }

    private String readAsciiUntilCrlf(InputStream in) throws IOException {
        StringBuilder builder = new StringBuilder();
        while (true) {
            int c;
            if ((c = in.read()) == 10 && builder.length() > 0 && builder.charAt(builder.length() - 1) == '\r') {
                builder.deleteCharAt(builder.length() - 1);
                return builder.toString();
            }
            if (c == -1) {
                return builder.toString();
            }
            builder.append((char)c);
        }
    }

    private void readEmptyLine(InputStream in) throws IOException {
        String line = this.readAsciiUntilCrlf(in);
        if (!line.equals("")) {
            throw new IllegalStateException("Expected empty but was: " + line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResumeDownload() {
        Object object = this.downloadPauseLock;
        synchronized (object) {
            this.downloadResume = true;
            this.downloadPauseLock.notifyAll();
        }
    }

    private class TruncatingOutputStream
    extends ByteArrayOutputStream {
        private int numBytesReceived = 0;

        private TruncatingOutputStream() {
        }

        public void write(byte[] buffer, int offset, int len) {
            this.numBytesReceived += len;
            super.write(buffer, offset, Math.min(len, MockWebServer.this.bodyLimit - this.count));
        }

        public void write(int oneByte) {
            ++this.numBytesReceived;
            if (this.count < MockWebServer.this.bodyLimit) {
                super.write(oneByte);
            }
        }
    }
}

