/*
 * Decompiled with CFR 0.152.
 */
package coretestutils.http;

import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockResponse {
    private static final byte[] EMPTY_BODY = new byte[0];
    static final String LOG_TAG = "coretestutils.http.MockResponse";
    private String status = "HTTP/1.1 200 OK";
    private Map<String, String> headers = new HashMap<String, String>();
    private byte[] body = EMPTY_BODY;
    private boolean closeConnectionAfter = false;
    private String closeConnectionAfterHeader = null;
    private int closeConnectionAfterXBytes = -1;
    private int pauseConnectionAfterXBytes = -1;
    private File bodyExternalFile = null;

    public MockResponse() {
        this.addHeader("Content-Length", 0L);
    }

    public String getStatus() {
        return this.status;
    }

    public MockResponse setResponseCode(int code) {
        this.status = "HTTP/1.1 " + code + " OK";
        return this;
    }

    public List<String> getHeaders() {
        ArrayList<String> headerStrings = new ArrayList<String>();
        for (String header : this.headers.keySet()) {
            headerStrings.add(header + ": " + this.headers.get(header));
        }
        return headerStrings;
    }

    public MockResponse addHeader(String header, String value) {
        this.headers.put(header.toLowerCase(), value);
        return this;
    }

    public MockResponse addHeader(String header, long value) {
        return this.addHeader(header, Long.toString(value));
    }

    public MockResponse removeHeader(String header) {
        this.headers.remove(header.toLowerCase());
        return this;
    }

    private boolean bodyIsExternal() {
        return this.bodyExternalFile != null;
    }

    public InputStream getBody() {
        if (this.bodyIsExternal()) {
            try {
                return new FileInputStream(this.bodyExternalFile);
            }
            catch (FileNotFoundException e) {
                Log.e((String)LOG_TAG, (String)("File not found: " + this.bodyExternalFile.getAbsolutePath()));
            }
        }
        return new ByteArrayInputStream(this.body);
    }

    public MockResponse setBody(File body) {
        this.addHeader("Content-Length", body.length());
        this.bodyExternalFile = body;
        return this;
    }

    public MockResponse setBody(byte[] body) {
        this.addHeader("Content-Length", body.length);
        this.body = body;
        return this;
    }

    public MockResponse setBody(String body) {
        try {
            return this.setBody(body.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
    }

    public MockResponse setChunkedBody(byte[] body, int maxChunkSize) throws IOException {
        int chunkSize;
        this.addHeader("Transfer-encoding", "chunked");
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        for (int pos = 0; pos < body.length; pos += chunkSize) {
            chunkSize = Math.min(body.length - pos, maxChunkSize);
            bytesOut.write(Integer.toHexString(chunkSize).getBytes("US-ASCII"));
            bytesOut.write("\r\n".getBytes("US-ASCII"));
            bytesOut.write(body, pos, chunkSize);
            bytesOut.write("\r\n".getBytes("US-ASCII"));
        }
        bytesOut.write("0\r\n".getBytes("US-ASCII"));
        this.body = bytesOut.toByteArray();
        return this;
    }

    public MockResponse setChunkedBody(String body, int maxChunkSize) throws IOException {
        return this.setChunkedBody(body.getBytes("US-ASCII"), maxChunkSize);
    }

    public String toString() {
        return this.status;
    }

    public boolean shouldCloseConnectionAfter() {
        return this.closeConnectionAfter;
    }

    public MockResponse setCloseConnectionAfter(boolean closeConnectionAfter) {
        this.closeConnectionAfter = closeConnectionAfter;
        return this;
    }

    public MockResponse setCloseConnectionAfterHeader(String header) {
        this.closeConnectionAfterHeader = header;
        this.setCloseConnectionAfter(true);
        return this;
    }

    public String getCloseConnectionAfterHeader() {
        return this.closeConnectionAfterHeader;
    }

    public MockResponse setCloseConnectionAfterXBytes(int position) {
        this.closeConnectionAfterXBytes = position;
        this.setCloseConnectionAfter(true);
        return this;
    }

    public int getCloseConnectionAfterXBytes() {
        return this.closeConnectionAfterXBytes;
    }

    public MockResponse setPauseConnectionAfterXBytes(int position) {
        this.pauseConnectionAfterXBytes = position;
        return this;
    }

    public int getPauseConnectionAfterXBytes() {
        return this.pauseConnectionAfterXBytes;
    }

    public boolean getShouldPause() {
        return this.pauseConnectionAfterXBytes != -1;
    }

    public boolean getShouldClose() {
        return this.closeConnectionAfterXBytes != -1;
    }
}

