/*
 * Decompiled with CFR 0.152.
 */
package com.android.frameworks.downloadmanagertests;

import android.app.DownloadManager;
import android.app.DownloadManagerBaseTest;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.android.frameworks.downloadmanagertests.DownloadManagerTestRunner;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.util.HashSet;

public class DownloadManagerTestApp
extends DownloadManagerBaseTest {
    protected static String DOWNLOAD_STARTED_FLAG = "DMTEST_DOWNLOAD_STARTED";
    protected static String LOG_TAG = "com.android.frameworks.downloadmanagertests.DownloadManagerTestApp";
    protected static String DOWNLOAD_500K_FILENAME = "External541kb.apk";
    protected static long DOWNLOAD_500K_FILESIZE = 570927L;
    protected static String DOWNLOAD_1MB_FILENAME = "External1mb.apk";
    protected static long DOWNLOAD_1MB_FILESIZE = 1041262L;
    protected static String DOWNLOAD_5MB_FILENAME = "External5mb.apk";
    protected static long DOWNLOAD_5MB_FILESIZE = 5138700L;
    protected static String DOWNLOAD_10MB_FILENAME = "External10mb.apk";
    protected static long DOWNLOAD_10MB_FILESIZE = 10258741L;
    private static final String FILE_CONCURRENT_DOWNLOAD_FILE_PREFIX = "file";
    private static final String FILE_CONCURRENT_DOWNLOAD_FILE_EXTENSION = ".bin";
    protected static long CONCURRENT_DOWNLOAD_FILESIZE = 1000000L;
    private String externalDownloadUriValue = null;
    private String externalLargeDownloadUriValue = null;

    public void setUp() throws Exception {
        super.setUp();
        DownloadManagerTestRunner mRunner = (DownloadManagerTestRunner)this.getInstrumentation();
        this.externalDownloadUriValue = this.normalizeUri(mRunner.externalDownloadUriValue);
        DownloadManagerTestApp.assertNotNull((Object)this.externalDownloadUriValue);
        this.externalLargeDownloadUriValue = this.normalizeUri(mRunner.externalDownloadUriValue);
        DownloadManagerTestApp.assertNotNull((Object)this.externalLargeDownloadUriValue);
    }

    public String normalizeUri(String uri) {
        if (uri != null && !uri.endsWith("/")) {
            uri = uri + "/";
        }
        return uri;
    }

    private Uri getExternalFileUri(String file) {
        return Uri.parse((String)(this.externalDownloadUriValue + file));
    }

    protected String getDownloadStartedFilePath() {
        String path = Environment.getExternalStorageDirectory().getPath();
        return path + File.separatorChar + DOWNLOAD_STARTED_FLAG;
    }

    protected void doCommonDownloadSetup() throws Exception {
        this.setWiFiStateOn(true);
        this.setAirplaneModeOn(false);
        this.waitForExternalStoreMount();
        this.removeAllCurrentDownloads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateDownload() throws Exception {
        String filename = DOWNLOAD_5MB_FILENAME;
        this.mContext.deleteFile(DOWNLOAD_STARTED_FLAG);
        FileOutputStream fileOutput = this.mContext.openFileOutput(DOWNLOAD_STARTED_FLAG, 0);
        DataOutputStream outputFile = null;
        this.doCommonDownloadSetup();
        try {
            long dlRequest = -1L;
            this.removeAllCurrentDownloads();
            Uri remoteUri = this.getExternalFileUri(filename);
            DownloadManager.Request request = new DownloadManager.Request(remoteUri);
            dlRequest = this.mDownloadManager.enqueue(request);
            this.waitForDownloadToStart(dlRequest);
            DownloadManagerTestApp.assertTrue((dlRequest != -1L ? 1 : 0) != 0);
            outputFile = new DataOutputStream(fileOutput);
            outputFile.writeLong(dlRequest);
        }
        finally {
            if (outputFile != null) {
                outputFile.flush();
                outputFile.close();
            }
        }
    }

    public void verifyFileDownloadSucceeded() throws Exception {
        String filename = DOWNLOAD_5MB_FILENAME;
        long filesize = DOWNLOAD_5MB_FILESIZE;
        long dlRequest = -1L;
        boolean rebootMarkerValid = false;
        FilterInputStream dataInputFile = null;
        this.setWiFiStateOn(true);
        this.setAirplaneModeOn(false);
        try {
            FileInputStream inFile = this.mContext.openFileInput(DOWNLOAD_STARTED_FLAG);
            dataInputFile = new DataInputStream(inFile);
            dlRequest = ((DataInputStream)dataInputFile).readLong();
        }
        catch (Exception e) {
            Log.i((String)LOG_TAG, (String)"Unable to determine initial download id.");
            throw e;
        }
        finally {
            if (dataInputFile != null) {
                dataInputFile.close();
            }
            this.mContext.deleteFile(DOWNLOAD_STARTED_FLAG);
        }
        DownloadManagerTestApp.assertTrue((dlRequest != -1L ? 1 : 0) != 0);
        Cursor cursor = this.getCursor(dlRequest);
        ParcelFileDescriptor pfd = null;
        try {
            DownloadManagerTestApp.assertTrue((String)"Unable to query last initiated download!", (boolean)cursor.moveToFirst());
            int columnIndex = cursor.getColumnIndex("status");
            int status = cursor.getInt(columnIndex);
            boolean currentWaitTime = false;
            this.waitForDownloadOrTimeout(dlRequest);
            Log.i((String)LOG_TAG, (String)"Verifying download information...");
            pfd = this.mDownloadManager.openDownloadedFile(dlRequest);
            this.verifyFileSize(pfd, filesize);
        }
        catch (Exception e) {
            try {
                Log.i((String)LOG_TAG, (String)("error: " + e.toString()));
                throw e;
            }
            catch (Throwable throwable) {
                cursor.close();
                this.mDownloadManager.remove(new long[]{dlRequest});
                if (pfd != null) {
                    pfd.close();
                }
                throw throwable;
            }
        }
        cursor.close();
        this.mDownloadManager.remove(new long[]{dlRequest});
        if (pfd != null) {
            pfd.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runLargeDownloadOverWiFi() throws Exception {
        Cursor cursor;
        long dlRequest;
        block3: {
            String filename = DOWNLOAD_10MB_FILENAME;
            long filesize = DOWNLOAD_10MB_FILESIZE;
            dlRequest = -1L;
            this.doCommonDownloadSetup();
            this.removeAllCurrentDownloads();
            Uri remoteUri = this.getExternalFileUri(filename);
            DownloadManager.Request request = new DownloadManager.Request(remoteUri);
            request.setMimeType(this.getMimeMapping(DownloadManagerBaseTest.DownloadFileType.APK));
            dlRequest = this.mDownloadManager.enqueue(request);
            this.waitForDownloadOrTimeout(dlRequest, 1000L, 900000L);
            cursor = this.getCursor(dlRequest);
            ParcelFileDescriptor pfd = null;
            try {
                Log.i((String)LOG_TAG, (String)"Verifying download information...");
                pfd = this.mDownloadManager.openDownloadedFile(dlRequest);
                this.verifyFileSize(pfd, filesize);
                if (pfd == null) break block3;
            }
            catch (Throwable throwable) {
                if (pfd != null) {
                    pfd.close();
                }
                this.mDownloadManager.remove(new long[]{dlRequest});
                cursor.close();
                throw throwable;
            }
            pfd.close();
        }
        this.mDownloadManager.remove(new long[]{dlRequest});
        cursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDownloadMultipleSwitching() throws Exception {
        String filename = DOWNLOAD_500K_FILENAME;
        long filesize = DOWNLOAD_500K_FILESIZE;
        this.doCommonDownloadSetup();
        String localDownloadDirectory = Environment.getExternalStorageDirectory().getPath();
        File downloadedFile = new File(localDownloadDirectory, filename);
        long dlRequest = -1L;
        try {
            downloadedFile.delete();
            this.removeAllCurrentDownloads();
            Uri remoteUri = this.getExternalFileUri(filename);
            DownloadManager.Request request = new DownloadManager.Request(remoteUri);
            Uri localUri = Uri.fromFile((File)downloadedFile);
            Log.i((String)LOG_TAG, (String)("setting localUri to: " + localUri.getPath()));
            request.setDestinationUri(localUri);
            request.setAllowedNetworkTypes(3);
            dlRequest = this.mDownloadManager.enqueue(request);
            this.waitForDownloadToStart(dlRequest);
            this.waitForFileToGrow(downloadedFile);
            this.setWiFiStateOn(false);
            Log.i((String)LOG_TAG, (String)"Turning on airplane mode...");
            this.setAirplaneModeOn(true);
            Thread.sleep(30000L);
            this.setWiFiStateOn(true);
            Thread.sleep(30000L);
            Log.i((String)LOG_TAG, (String)"Turning off airplane mode...");
            this.setAirplaneModeOn(false);
            Thread.sleep(5000L);
            Log.i((String)LOG_TAG, (String)"Turning off WiFi...");
            this.setWiFiStateOn(false);
            Thread.sleep(30000L);
            Log.i((String)LOG_TAG, (String)"Turning on WiFi...");
            this.setWiFiStateOn(true);
            Log.i((String)LOG_TAG, (String)"Waiting up to 3 minutes for download to complete...");
            this.waitForDownloadsOrTimeout(dlRequest, 180000L);
            ParcelFileDescriptor pfd = this.mDownloadManager.openDownloadedFile(dlRequest);
            this.verifyFileSize(pfd, filesize);
        }
        catch (Throwable throwable) {
            Log.i((String)LOG_TAG, (String)"Cleaning up files...");
            if (dlRequest != -1L) {
                this.mDownloadManager.remove(new long[]{dlRequest});
            }
            downloadedFile.delete();
            throw throwable;
        }
        Log.i((String)LOG_TAG, (String)"Cleaning up files...");
        if (dlRequest != -1L) {
            this.mDownloadManager.remove(new long[]{dlRequest});
        }
        downloadedFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDownloadMultipleWiFiEnableDisable() throws Exception {
        String filename = DOWNLOAD_500K_FILENAME;
        long filesize = DOWNLOAD_500K_FILESIZE;
        this.doCommonDownloadSetup();
        String localDownloadDirectory = Environment.getExternalStorageDirectory().getPath();
        File downloadedFile = new File(localDownloadDirectory, filename);
        long dlRequest = -1L;
        try {
            downloadedFile.delete();
            this.removeAllCurrentDownloads();
            Uri remoteUri = this.getExternalFileUri(filename);
            DownloadManager.Request request = new DownloadManager.Request(remoteUri);
            Uri localUri = Uri.fromFile((File)downloadedFile);
            Log.i((String)LOG_TAG, (String)("setting localUri to: " + localUri.getPath()));
            request.setDestinationUri(localUri);
            request.setAllowedNetworkTypes(2);
            dlRequest = this.mDownloadManager.enqueue(request);
            this.waitForDownloadToStart(dlRequest);
            this.waitForFileToGrow(downloadedFile);
            Log.i((String)LOG_TAG, (String)"Turning off WiFi...");
            this.setWiFiStateOn(false);
            Thread.sleep(40000L);
            Log.i((String)LOG_TAG, (String)"Turning on WiFi again...");
            this.setWiFiStateOn(true);
            this.waitForFileToGrow(downloadedFile);
            Log.i((String)LOG_TAG, (String)"Turning off WiFi...");
            this.setWiFiStateOn(false);
            Thread.sleep(20000L);
            Log.i((String)LOG_TAG, (String)"Turning on WiFi again...");
            this.setWiFiStateOn(true);
            Log.i((String)LOG_TAG, (String)"Waiting up to 3 minutes for download to complete...");
            this.waitForDownloadsOrTimeout(dlRequest, 180000L);
            ParcelFileDescriptor pfd = this.mDownloadManager.openDownloadedFile(dlRequest);
            this.verifyFileSize(pfd, filesize);
        }
        catch (Throwable throwable) {
            Log.i((String)LOG_TAG, (String)"Cleaning up files...");
            if (dlRequest != -1L) {
                this.mDownloadManager.remove(new long[]{dlRequest});
            }
            downloadedFile.delete();
            throw throwable;
        }
        Log.i((String)LOG_TAG, (String)"Cleaning up files...");
        if (dlRequest != -1L) {
            this.mDownloadManager.remove(new long[]{dlRequest});
        }
        downloadedFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDownloadMultipleAirplaneModeEnableDisable() throws Exception {
        String filename = DOWNLOAD_500K_FILENAME;
        long filesize = DOWNLOAD_500K_FILESIZE;
        this.doCommonDownloadSetup();
        String localDownloadDirectory = Environment.getExternalStorageDirectory().getPath();
        File downloadedFile = new File(localDownloadDirectory, filename);
        long dlRequest = -1L;
        try {
            downloadedFile.delete();
            this.removeAllCurrentDownloads();
            Uri remoteUri = this.getExternalFileUri(filename);
            DownloadManager.Request request = new DownloadManager.Request(remoteUri);
            Uri localUri = Uri.fromFile((File)downloadedFile);
            Log.i((String)LOG_TAG, (String)("setting localUri to: " + localUri.getPath()));
            request.setDestinationUri(localUri);
            request.setAllowedNetworkTypes(2);
            dlRequest = this.mDownloadManager.enqueue(request);
            this.waitForDownloadToStart(dlRequest);
            this.waitForFileToGrow(downloadedFile);
            Log.i((String)LOG_TAG, (String)"Turning on Airplane mode...");
            this.setAirplaneModeOn(true);
            Thread.sleep(60000L);
            Log.i((String)LOG_TAG, (String)"Turning off Airplane mode...");
            this.setAirplaneModeOn(false);
            this.waitForFileToGrow(downloadedFile);
            Log.i((String)LOG_TAG, (String)"Turning on Airplane mode again...");
            this.setAirplaneModeOn(true);
            Thread.sleep(20000L);
            Log.i((String)LOG_TAG, (String)"Turning off Airplane mode again...");
            this.setAirplaneModeOn(false);
            Log.i((String)LOG_TAG, (String)"Waiting up to 3 minutes for donwload to complete...");
            this.waitForDownloadsOrTimeout(dlRequest, 180000L);
            ParcelFileDescriptor pfd = this.mDownloadManager.openDownloadedFile(dlRequest);
            this.verifyFileSize(pfd, filesize);
        }
        catch (Throwable throwable) {
            Log.i((String)LOG_TAG, (String)"Cleaning up files...");
            if (dlRequest != -1L) {
                this.mDownloadManager.remove(new long[]{dlRequest});
            }
            downloadedFile.delete();
            throw throwable;
        }
        Log.i((String)LOG_TAG, (String)"Cleaning up files...");
        if (dlRequest != -1L) {
            this.mDownloadManager.remove(new long[]{dlRequest});
        }
        downloadedFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDownloadMultipleSimultaneously() throws Exception {
        int TOTAL_DOWNLOADS = 15;
        HashSet<Long> downloadIds = new HashSet<Long>(15);
        DownloadManagerBaseTest.MultipleDownloadsCompletedReceiver receiver = this.registerNewMultipleDownloadsReceiver();
        this.removeAllCurrentDownloads();
        try {
            for (int i = 0; i < 15; ++i) {
                long dlRequest = -1L;
                String filename = FILE_CONCURRENT_DOWNLOAD_FILE_PREFIX + i + FILE_CONCURRENT_DOWNLOAD_FILE_EXTENSION;
                Uri remoteUri = this.getExternalFileUri(filename);
                DownloadManager.Request request = new DownloadManager.Request(remoteUri);
                request.setTitle((CharSequence)filename);
                dlRequest = this.mDownloadManager.enqueue(request);
                DownloadManagerTestApp.assertTrue((dlRequest != -1L ? 1 : 0) != 0);
                downloadIds.add(dlRequest);
            }
            this.waitForDownloadsOrTimeout(5000L, 1800000L);
            DownloadManagerTestApp.assertEquals((int)15, (int)receiver.numDownloadsCompleted());
        }
        finally {
            this.removeAllCurrentDownloads();
        }
    }
}

