/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.provider.Settings;
import android.test.InstrumentationTestCase;
import android.util.Log;
import coretestutils.http.MockResponse;
import coretestutils.http.MockWebServer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;

public class DownloadManagerBaseTest
extends InstrumentationTestCase {
    protected DownloadManager mDownloadManager = null;
    protected MockWebServer mServer = null;
    protected String mFileType = "text/plain";
    protected Context mContext = null;
    protected MultipleDownloadsCompletedReceiver mReceiver = null;
    protected static final int DEFAULT_FILE_SIZE = 133120;
    protected static final int FILE_BLOCK_READ_SIZE = 0x100000;
    protected static final String LOG_TAG = "android.net.DownloadManagerBaseTest";
    protected static final int HTTP_OK = 200;
    protected static final int HTTP_REDIRECT = 307;
    protected static final int HTTP_PARTIAL_CONTENT = 206;
    protected static final int HTTP_NOT_FOUND = 404;
    protected static final int HTTP_SERVICE_UNAVAILABLE = 503;
    protected String DEFAULT_FILENAME = "somefile.txt";
    protected static final int DEFAULT_MAX_WAIT_TIME = 120000;
    protected static final int DEFAULT_WAIT_POLL_TIME = 5000;
    protected static final int WAIT_FOR_DOWNLOAD_POLL_TIME = 1000;
    protected static final int MAX_WAIT_FOR_DOWNLOAD_TIME = 300000;
    protected static final int MAX_WAIT_FOR_LARGE_DOWNLOAD_TIME = 900000;

    public void setUp() throws Exception {
        this.mContext = this.getInstrumentation().getContext();
        this.mDownloadManager = (DownloadManager)this.mContext.getSystemService("download");
        this.mServer = new MockWebServer();
        this.mReceiver = this.registerNewMultipleDownloadsReceiver();
    }

    protected MockResponse enqueueResponse(int status) {
        return this.doEnqueueResponse(status);
    }

    protected MockResponse enqueueResponse(int status, byte[] body) {
        return this.doEnqueueResponse(status).setBody(body);
    }

    protected MockResponse enqueueResponse(int status, File bodyFile) {
        return this.doEnqueueResponse(status).setBody(bodyFile);
    }

    protected MockResponse doEnqueueResponse(int status) {
        MockResponse response = new MockResponse().setResponseCode(status);
        response.addHeader("Content-type", this.mFileType);
        this.mServer.enqueue(response);
        return response;
    }

    protected byte[] generateData(int size, DataType type) {
        return this.generateData(size, type, null);
    }

    protected byte[] generateData(int size, DataType type, Random rng) {
        int min = -128;
        int max = 127;
        if (type == DataType.TEXT) {
            min = 32;
            max = 126;
        }
        byte[] result = new byte[size];
        Log.i((String)LOG_TAG, (String)("Generating data of size: " + size));
        if (rng == null) {
            rng = new LoggingRng();
        }
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)(min + rng.nextInt(max - min + 1));
        }
        return result;
    }

    protected void verifyFileSize(ParcelFileDescriptor pfd, long size) {
        DownloadManagerBaseTest.assertEquals((long)pfd.getStatSize(), (long)size);
    }

    protected void verifyFileContents(ParcelFileDescriptor actual, byte[] expected) throws IOException {
        ParcelFileDescriptor.AutoCloseInputStream input = new ParcelFileDescriptor.AutoCloseInputStream(actual);
        long fileSize = actual.getStatSize();
        DownloadManagerBaseTest.assertTrue((fileSize <= Integer.MAX_VALUE ? 1 : 0) != 0);
        DownloadManagerBaseTest.assertEquals((long)expected.length, (long)fileSize);
        byte[] actualData = new byte[expected.length];
        DownloadManagerBaseTest.assertEquals((long)input.read(actualData), (long)fileSize);
        this.compareByteArrays(actualData, expected);
    }

    protected void compareByteArrays(byte[] actual, byte[] expected) {
        DownloadManagerBaseTest.assertEquals((int)actual.length, (int)expected.length);
        int length = actual.length;
        for (int i = 0; i < length; ++i) {
            if (actual[i] == expected[i]) continue;
            DownloadManagerBaseTest.fail((String)"Byte arrays are not equal.");
        }
    }

    protected void verifyFileContents(ParcelFileDescriptor pfd, File file) throws IOException {
        byte[] actual = new byte[0x100000];
        byte[] expected = new byte[0x100000];
        ParcelFileDescriptor.AutoCloseInputStream input = new ParcelFileDescriptor.AutoCloseInputStream(pfd);
        DownloadManagerBaseTest.assertEquals((long)file.length(), (long)pfd.getStatSize());
        DataInputStream inFile = new DataInputStream(new FileInputStream(file));
        int actualRead = 0;
        int expectedRead = 0;
        while ((actualRead = input.read(actual)) != -1 && (expectedRead = inFile.read(expected)) != -1) {
            DownloadManagerBaseTest.assertEquals((int)actualRead, (int)expectedRead);
            this.compareByteArrays(actual, expected);
        }
    }

    protected void setServerMimeType(DownloadFileType type) {
        this.mFileType = this.getMimeMapping(type);
    }

    protected String getMimeMapping(DownloadFileType type) {
        switch (type) {
            case APK: {
                return "application/vnd.android.package-archive";
            }
            case GIF: {
                return "image/gif";
            }
            case ZIP: {
                return "application/x-zip-compressed";
            }
            case GARBAGE: {
                return "zip\\pidy/doo/da";
            }
            case UNRECOGNIZED: {
                return "application/new.undefined.type.of.app";
            }
        }
        return "text/plain";
    }

    protected Uri getServerUri(String filename) throws Exception {
        URL url = this.mServer.getUrl("/" + filename);
        return Uri.parse((String)url.toString());
    }

    protected void logDBColumnData(Cursor cursor, String column) {
        int index = cursor.getColumnIndex(column);
        Log.i((String)LOG_TAG, (String)("columnName: " + column));
        Log.i((String)LOG_TAG, (String)("columnValue: " + cursor.getString(index)));
    }

    protected MultipleDownloadsCompletedReceiver registerNewMultipleDownloadsReceiver() {
        MultipleDownloadsCompletedReceiver receiver = new MultipleDownloadsCompletedReceiver();
        this.mContext.registerReceiver((BroadcastReceiver)receiver, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyAndCleanupSingleFileDownload(long requestId, byte[] fileData) throws Exception {
        int fileSize = fileData.length;
        ParcelFileDescriptor pfd = this.mDownloadManager.openDownloadedFile(requestId);
        Cursor cursor = this.mDownloadManager.query(new DownloadManager.Query().setFilterById(new long[]{requestId}));
        try {
            DownloadManagerBaseTest.assertEquals((int)1, (int)cursor.getCount());
            DownloadManagerBaseTest.assertTrue((boolean)cursor.moveToFirst());
            this.mServer.checkForExceptions();
            this.verifyFileSize(pfd, fileSize);
            this.verifyFileContents(pfd, fileData);
        }
        catch (Throwable throwable) {
            pfd.close();
            cursor.close();
            this.mDownloadManager.remove(new long[]{requestId});
            throw throwable;
        }
        pfd.close();
        cursor.close();
        this.mDownloadManager.remove(new long[]{requestId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWiFiStateOn(boolean enable) throws Exception {
        Log.i((String)LOG_TAG, (String)("Setting WiFi State to: " + enable));
        WifiManager manager = (WifiManager)this.mContext.getSystemService("wifi");
        manager.setWifiEnabled(enable);
        String timeoutMessage = "Timed out waiting for Wifi to be " + (enable ? "enabled!" : "disabled!");
        WiFiChangedReceiver receiver = new WiFiChangedReceiver(this.mContext);
        this.mContext.registerReceiver((BroadcastReceiver)receiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        WiFiChangedReceiver wiFiChangedReceiver = receiver;
        synchronized (wiFiChangedReceiver) {
            long timeoutTime = SystemClock.elapsedRealtime() + 120000L;
            boolean timedOut = false;
            while (receiver.getWiFiIsOn() != enable && !timedOut) {
                try {
                    ((Object)((Object)receiver)).wait(5000L);
                    if (SystemClock.elapsedRealtime() <= timeoutTime) continue;
                    timedOut = true;
                }
                catch (InterruptedException e) {}
            }
            if (timedOut) {
                DownloadManagerBaseTest.fail((String)timeoutMessage);
            }
        }
        DownloadManagerBaseTest.assertEquals((boolean)enable, (boolean)receiver.getWiFiIsOn());
    }

    protected void setAirplaneModeOn(boolean enable) throws Exception {
        int state = enable ? 1 : 0;
        Settings.System.putInt((ContentResolver)this.mContext.getContentResolver(), (String)"airplane_mode_on", (int)state);
        String timeoutMessage = "Timed out waiting for airplane mode to be " + (enable ? "enabled!" : "disabled!");
        int currentWaitTime = 0;
        while (Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"airplane_mode_on", (int)-1) != state) {
            this.timeoutWait(currentWaitTime, 5000L, 120000L, timeoutMessage);
        }
        Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
        intent.putExtra("state", true);
        this.mContext.sendBroadcast(intent);
    }

    protected File createFileOnSD(String filename, long fileSize, DataType type, String subdirectory) throws IOException {
        String sdPath = Environment.getExternalStorageDirectory().getPath();
        StringBuilder fullPath = new StringBuilder(sdPath);
        if (subdirectory != null) {
            fullPath.append(File.separatorChar).append(subdirectory);
        }
        File file = null;
        if (filename == null) {
            file = File.createTempFile("DMTEST_", null, new File(fullPath.toString()));
        } else {
            fullPath.append(File.separatorChar).append(filename);
            file = new File(fullPath.toString());
            file.createNewFile();
        }
        DataOutputStream output = new DataOutputStream(new FileOutputStream(file));
        int CHUNK_SIZE = 1000000;
        long remaining = fileSize;
        int nextChunkSize = 1000000;
        byte[] randomData = null;
        LoggingRng rng = new LoggingRng();
        try {
            while (remaining > 0L) {
                if (remaining < 1000000L) {
                    nextChunkSize = (int)remaining;
                    remaining = 0L;
                } else {
                    remaining -= 1000000L;
                }
                randomData = this.generateData(nextChunkSize, type, rng);
                output.write(randomData);
            }
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)("Error writing to file " + file.getAbsolutePath()));
            file.delete();
            throw e;
        }
        finally {
            output.close();
        }
        return file;
    }

    protected void waitForDownloadOrTimeout_skipNotification(long id) throws TimeoutException, InterruptedException {
        this.waitForDownloadOrTimeout(id, 1000L, 300000L);
    }

    protected void waitForDownloadOrTimeout(long id) throws TimeoutException, InterruptedException {
        this.waitForDownloadOrTimeout_skipNotification(id);
        this.waitForReceiverNotifications(1);
    }

    protected void waitForDownloadOrTimeout(long id, long poll, long timeoutMillis) throws TimeoutException, InterruptedException {
        this.doWaitForDownloadsOrTimeout(new DownloadManager.Query().setFilterById(new long[]{id}), poll, timeoutMillis);
        this.waitForReceiverNotifications(1);
    }

    protected void waitForDownloadsOrTimeout(long poll, long timeoutMillis) throws TimeoutException, InterruptedException {
        this.doWaitForDownloadsOrTimeout(new DownloadManager.Query(), poll, timeoutMillis);
    }

    protected boolean waitForDownloadOrTimeoutNoThrow(long id, long poll, long timeoutMillis) {
        try {
            this.doWaitForDownloadsOrTimeout(new DownloadManager.Query().setFilterById(new long[]{id}), poll, timeoutMillis);
            this.waitForReceiverNotifications(1);
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    protected int timeoutWait(int currentTotalWaitTime, long poll, long maxTimeoutMillis, String timedOutMessage) throws TimeoutException {
        long now = SystemClock.elapsedRealtime();
        long end = now + poll;
        while (now < end) {
            try {
                Thread.sleep(end - now);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            now = SystemClock.elapsedRealtime();
        }
        if ((long)(currentTotalWaitTime = (int)((long)currentTotalWaitTime + poll)) > maxTimeoutMillis) {
            throw new TimeoutException(timedOutMessage);
        }
        return currentTotalWaitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWaitForDownloadsOrTimeout(DownloadManager.Query query, long poll, long timeoutMillis) throws TimeoutException {
        int currentWaitTime = 0;
        while (true) {
            query.setFilterByStatus(7);
            Cursor cursor = this.mDownloadManager.query(query);
            try {
                if (cursor.getCount() == 0) {
                    Log.i((String)LOG_TAG, (String)"All downloads should be done...");
                    break;
                }
                currentWaitTime = this.timeoutWait(currentWaitTime, poll, timeoutMillis, "Timed out waiting for all downloads to finish");
                continue;
            }
            finally {
                cursor.close();
                continue;
            }
            break;
        }
    }

    protected void waitForExternalStoreMount() throws Exception {
        String extStorageState = Environment.getExternalStorageState();
        int currentWaitTime = 0;
        while (!extStorageState.equals("mounted")) {
            Log.i((String)LOG_TAG, (String)"Waiting for SD card...");
            currentWaitTime = this.timeoutWait(currentWaitTime, 5000L, 120000L, "Timed out waiting for SD Card to be ready!");
            extStorageState = Environment.getExternalStorageState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForDownloadToStart(long dlRequest) throws Exception {
        Cursor cursor = this.getCursor(dlRequest);
        try {
            int columnIndex = cursor.getColumnIndex("status");
            int value = cursor.getInt(columnIndex);
            int currentWaitTime = 0;
            while (value != 2 && value != 16 && value != 8) {
                Log.i((String)LOG_TAG, (String)"Waiting for download to start...");
                currentWaitTime = this.timeoutWait(currentWaitTime, 1000L, 300000L, "Timed out waiting for download to start!");
                cursor.requery();
                DownloadManagerBaseTest.assertTrue((boolean)cursor.moveToFirst());
                columnIndex = cursor.getColumnIndex("status");
                value = cursor.getInt(columnIndex);
            }
            DownloadManagerBaseTest.assertFalse((String)"Download failed immediately after start", (value == 16 ? 1 : 0) != 0);
        }
        finally {
            cursor.close();
        }
    }

    protected void waitForReceiverNotification() throws Exception {
        this.waitForReceiverNotifications(1);
    }

    protected void waitForReceiverNotifications(int targetNumber) throws TimeoutException {
        int count = this.mReceiver.numDownloadsCompleted();
        int currentWaitTime = 0;
        while (count < targetNumber) {
            Log.i((String)LOG_TAG, (String)"Waiting for notification of downloads...");
            currentWaitTime = this.timeoutWait(currentWaitTime, 1000L, 300000L, "Timed out waiting for download notifications! Received " + count + "notifications.");
            count = this.mReceiver.numDownloadsCompleted();
        }
    }

    protected void waitForFileToGrow(File file) throws Exception {
        int currentWaitTime = 0;
        while (!file.exists()) {
            Log.i((String)LOG_TAG, (String)"Waiting for file to exist...");
            currentWaitTime = this.timeoutWait(currentWaitTime, 1000L, 300000L, "Timed out waiting for file to be created.");
        }
        long originalSize = file.length();
        while (file.length() <= originalSize) {
            Log.i((String)LOG_TAG, (String)"Waiting for file to be written to...");
            currentWaitTime = this.timeoutWait(currentWaitTime, 1000L, 300000L, "Timed out waiting for file to be written to.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllCurrentDownloads() {
        Log.i((String)LOG_TAG, (String)"Removing all current registered downloads...");
        Cursor cursor = this.mDownloadManager.query(new DownloadManager.Query());
        try {
            if (cursor.moveToFirst()) {
                do {
                    int index = cursor.getColumnIndex("_id");
                    long downloadId = cursor.getLong(index);
                    this.mDownloadManager.remove(new long[]{downloadId});
                } while (cursor.moveToNext());
            }
        }
        finally {
            cursor.close();
        }
    }

    protected long doStandardEnqueue(byte[] body) throws Exception {
        this.enqueueResponse(200, body);
        return this.doCommonStandardEnqueue();
    }

    protected long doStandardEnqueue(File body) throws Exception {
        this.enqueueResponse(200, body);
        return this.doCommonStandardEnqueue();
    }

    protected long doCommonStandardEnqueue() throws Exception {
        Uri uri = this.getServerUri(this.DEFAULT_FILENAME);
        DownloadManager.Request request = new DownloadManager.Request(uri);
        request.setTitle((CharSequence)this.DEFAULT_FILENAME);
        long dlRequest = this.mDownloadManager.enqueue(request);
        Log.i((String)LOG_TAG, (String)("request ID: " + dlRequest));
        return dlRequest;
    }

    protected void verifyInt(Cursor cursor, String columnName, int expected) {
        int index = cursor.getColumnIndex(columnName);
        int actual = cursor.getInt(index);
        DownloadManagerBaseTest.assertEquals((int)expected, (int)actual);
    }

    protected void verifyString(Cursor cursor, String columnName, String expected) {
        int index = cursor.getColumnIndex(columnName);
        String actual = cursor.getString(index);
        Log.i((String)LOG_TAG, (String)(": " + actual));
        DownloadManagerBaseTest.assertEquals((String)expected, (String)actual);
    }

    protected Cursor getCursor(long id) throws Exception {
        DownloadManager.Query query = new DownloadManager.Query();
        if (id != -1L) {
            query.setFilterById(new long[]{id});
        }
        Cursor cursor = this.mDownloadManager.query(query);
        int currentWaitTime = 0;
        try {
            while (!cursor.moveToFirst()) {
                Thread.sleep(5000L);
                if ((currentWaitTime += 5000) > 120000) {
                    DownloadManagerBaseTest.fail((String)"timed out waiting for a non-null query result");
                }
                cursor.requery();
            }
        }
        catch (Exception e) {
            cursor.close();
            throw e;
        }
        return cursor;
    }

    public static class WiFiChangedReceiver
    extends BroadcastReceiver {
        private Context mContext = null;

        public WiFiChangedReceiver(Context context) {
            this.mContext = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("android.net.conn.CONNECTIVITY_CHANGE")) {
                Log.i((String)DownloadManagerBaseTest.LOG_TAG, (String)("ConnectivityManager state change: " + intent.getAction()));
                WiFiChangedReceiver wiFiChangedReceiver = this;
                synchronized (wiFiChangedReceiver) {
                    ((Object)((Object)this)).notify();
                }
            }
        }

        public boolean getWiFiIsOn() {
            ConnectivityManager connManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            NetworkInfo info = connManager.getNetworkInfo(1);
            Log.i((String)DownloadManagerBaseTest.LOG_TAG, (String)("WiFi Connection state is currently: " + info.isConnected()));
            return info.isConnected();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultipleDownloadsCompletedReceiver
    extends BroadcastReceiver {
        private volatile int mNumDownloadsCompleted = 0;
        private Set<Long> downloadIds = Collections.synchronizedSet(new HashSet());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("android.intent.action.DOWNLOAD_COMPLETE")) {
                MultipleDownloadsCompletedReceiver multipleDownloadsCompletedReceiver = this;
                synchronized (multipleDownloadsCompletedReceiver) {
                    long id = intent.getExtras().getLong("extra_download_id");
                    Log.i((String)DownloadManagerBaseTest.LOG_TAG, (String)("Received Notification for download: " + id));
                    if (!this.downloadIds.contains(id)) {
                        ++this.mNumDownloadsCompleted;
                        Log.i((String)DownloadManagerBaseTest.LOG_TAG, (String)("MultipleDownloadsCompletedReceiver got intent: " + intent.getAction() + " --> total count: " + this.mNumDownloadsCompleted));
                        this.downloadIds.add(id);
                        DownloadManager dm = (DownloadManager)context.getSystemService("download");
                        Cursor cursor = dm.query(new DownloadManager.Query().setFilterById(new long[]{id}));
                        try {
                            if (cursor.moveToFirst()) {
                                int status = cursor.getInt(cursor.getColumnIndex("status"));
                                Log.i((String)DownloadManagerBaseTest.LOG_TAG, (String)("Download status is: " + status));
                            }
                            Assert.fail((String)"No status found for completed download!");
                        }
                        finally {
                            cursor.close();
                        }
                    } else {
                        Log.i((String)DownloadManagerBaseTest.LOG_TAG, (String)("Notification for id: " + id + " has already been made."));
                    }
                }
            }
        }

        public int numDownloadsCompleted() {
            return this.mNumDownloadsCompleted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Long> getDownloadIds() {
            MultipleDownloadsCompletedReceiver multipleDownloadsCompletedReceiver = this;
            synchronized (multipleDownloadsCompletedReceiver) {
                HashSet<Long> returnIds = new HashSet<Long>(this.downloadIds);
                return returnIds;
            }
        }
    }

    public static class LoggingRng
    extends Random {
        public LoggingRng() {
            this(SystemClock.uptimeMillis());
        }

        public LoggingRng(long seed) {
            super(seed);
            Log.i((String)DownloadManagerBaseTest.LOG_TAG, (String)("Seeding RNG with value: " + seed));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DataType {
        TEXT,
        BINARY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DownloadFileType {
        PLAINTEXT,
        APK,
        GIF,
        GARBAGE,
        UNRECOGNIZED,
        ZIP;

    }
}

