/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.content.ContentResolver;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.provider.Settings;

public class SettingsActivity
extends PreferenceActivity
implements Preference.OnPreferenceChangeListener {
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.addPreferencesFromResource(2131034114);
    }

    protected void onResume() {
        super.onResume();
        this.refresh();
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if ("alarm_in_silent_mode".equals(preference.getKey())) {
            CheckBoxPreference pref = (CheckBoxPreference)preference;
            int ringerModeStreamTypes = Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"mode_ringer_streams_affected", (int)0);
            ringerModeStreamTypes = pref.isChecked() ? (ringerModeStreamTypes &= 0xFFFFFFEF) : (ringerModeStreamTypes |= 0x10);
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"mode_ringer_streams_affected", (int)ringerModeStreamTypes);
            return true;
        }
        return super.onPreferenceTreeClick(preferenceScreen, preference);
    }

    public boolean onPreferenceChange(Preference pref, Object newValue) {
        ListPreference listPref = (ListPreference)pref;
        int idx = listPref.findIndexOfValue((String)newValue);
        listPref.setSummary(listPref.getEntries()[idx]);
        return true;
    }

    private void refresh() {
        CheckBoxPreference alarmInSilentModePref = (CheckBoxPreference)this.findPreference("alarm_in_silent_mode");
        int silentModeStreams = Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"mode_ringer_streams_affected", (int)0);
        alarmInSilentModePref.setChecked((silentModeStreams & 0x10) == 0);
        ListPreference snooze = (ListPreference)this.findPreference("snooze_duration");
        snooze.setSummary(snooze.getEntry());
        snooze.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
    }
}

