/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.app.AlertDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.text.format.DateFormat;
import android.view.View;
import android.widget.Button;
import android.widget.TimePicker;
import android.widget.Toast;
import com.android.deskclock.Alarm;
import com.android.deskclock.AlarmPreference;
import com.android.deskclock.Alarms;
import com.android.deskclock.RepeatPreference;
import com.android.deskclock.ToastMaster;

public class SetAlarm
extends PreferenceActivity
implements TimePickerDialog.OnTimeSetListener,
Preference.OnPreferenceChangeListener {
    private EditTextPreference mLabel;
    private CheckBoxPreference mEnabledPref;
    private Preference mTimePref;
    private AlarmPreference mAlarmPref;
    private CheckBoxPreference mVibratePref;
    private RepeatPreference mRepeatPref;
    private int mId;
    private int mHour;
    private int mMinutes;
    private boolean mTimePickerCancelled;
    private Alarm mOriginalAlarm;
    private static final Handler sHandler = new Handler();

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.setContentView(2130903051);
        this.addPreferencesFromResource(2131034112);
        this.mLabel = (EditTextPreference)this.findPreference("label");
        this.mLabel.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference p, Object newValue) {
                String val = (String)newValue;
                p.setSummary((CharSequence)val);
                if (val != null && !val.equals(SetAlarm.this.mLabel.getText())) {
                    return SetAlarm.this.onPreferenceChange(p, newValue);
                }
                return true;
            }
        });
        this.mEnabledPref = (CheckBoxPreference)this.findPreference("enabled");
        this.mEnabledPref.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference p, Object newValue) {
                if (!SetAlarm.this.mEnabledPref.isChecked()) {
                    SetAlarm.popAlarmSetToast((Context)SetAlarm.this, SetAlarm.this.mHour, SetAlarm.this.mMinutes, SetAlarm.this.mRepeatPref.getDaysOfWeek());
                }
                return SetAlarm.this.onPreferenceChange(p, newValue);
            }
        });
        this.mTimePref = this.findPreference("time");
        this.mAlarmPref = (AlarmPreference)this.findPreference("alarm");
        this.mAlarmPref.setOnPreferenceChangeListener(this);
        this.mVibratePref = (CheckBoxPreference)this.findPreference("vibrate");
        this.mVibratePref.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.mRepeatPref = (RepeatPreference)this.findPreference("setRepeat");
        this.mRepeatPref.setOnPreferenceChangeListener(this);
        Intent i = this.getIntent();
        this.mId = i.getIntExtra("alarm_id", -1);
        Alarm alarm = null;
        if (this.mId == -1) {
            alarm = new Alarm();
        } else {
            alarm = Alarms.getAlarm(this.getContentResolver(), this.mId);
            if (alarm == null) {
                this.finish();
                return;
            }
        }
        this.mOriginalAlarm = alarm;
        this.updatePrefs(this.mOriginalAlarm);
        this.getListView().setItemsCanFocus(true);
        Button b = (Button)this.findViewById(2131492902);
        b.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SetAlarm.this.saveAlarm();
                SetAlarm.this.finish();
            }
        });
        final Button revert = (Button)this.findViewById(2131492903);
        revert.setEnabled(false);
        revert.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int newId = SetAlarm.this.mId;
                SetAlarm.this.updatePrefs(SetAlarm.this.mOriginalAlarm);
                if (((SetAlarm)SetAlarm.this).mOriginalAlarm.id == -1) {
                    Alarms.deleteAlarm((Context)SetAlarm.this, newId);
                } else {
                    SetAlarm.this.saveAlarm();
                }
                revert.setEnabled(false);
            }
        });
        b = (Button)this.findViewById(2131492904);
        if (this.mId == -1) {
            b.setEnabled(false);
        } else {
            b.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SetAlarm.this.deleteAlarm();
                }
            });
        }
        if (this.mId == -1) {
            this.mTimePickerCancelled = true;
            this.showTimePicker();
        }
    }

    public boolean onPreferenceChange(final Preference p, Object newValue) {
        sHandler.post(new Runnable(){

            public void run() {
                if (p != SetAlarm.this.mEnabledPref) {
                    SetAlarm.this.mEnabledPref.setChecked(true);
                }
                SetAlarm.this.saveAlarmAndEnableRevert();
            }
        });
        return true;
    }

    private void updatePrefs(Alarm alarm) {
        this.mId = alarm.id;
        this.mEnabledPref.setChecked(alarm.enabled);
        this.mLabel.setText(alarm.label);
        this.mLabel.setSummary((CharSequence)alarm.label);
        this.mHour = alarm.hour;
        this.mMinutes = alarm.minutes;
        this.mRepeatPref.setDaysOfWeek(alarm.daysOfWeek);
        this.mVibratePref.setChecked(alarm.vibrate);
        this.mAlarmPref.setAlert(alarm.alert);
        this.updateTime();
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference == this.mTimePref) {
            this.showTimePicker();
        }
        return super.onPreferenceTreeClick(preferenceScreen, preference);
    }

    public void onBackPressed() {
        if (!this.mTimePickerCancelled) {
            this.saveAlarm();
        }
        this.finish();
    }

    private void showTimePicker() {
        new TimePickerDialog((Context)this, (TimePickerDialog.OnTimeSetListener)this, this.mHour, this.mMinutes, DateFormat.is24HourFormat((Context)this)).show();
    }

    public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
        this.mTimePickerCancelled = false;
        this.mHour = hourOfDay;
        this.mMinutes = minute;
        this.updateTime();
        this.mEnabledPref.setChecked(true);
        SetAlarm.popAlarmSetToast((Context)this, this.saveAlarmAndEnableRevert());
    }

    private void updateTime() {
        this.mTimePref.setSummary((CharSequence)Alarms.formatTime((Context)this, this.mHour, this.mMinutes, this.mRepeatPref.getDaysOfWeek()));
    }

    private long saveAlarmAndEnableRevert() {
        Button revert = (Button)this.findViewById(2131492903);
        revert.setEnabled(true);
        return this.saveAlarm();
    }

    private long saveAlarm() {
        long time;
        Alarm alarm = new Alarm();
        alarm.id = this.mId;
        alarm.enabled = this.mEnabledPref.isChecked();
        alarm.hour = this.mHour;
        alarm.minutes = this.mMinutes;
        alarm.daysOfWeek = this.mRepeatPref.getDaysOfWeek();
        alarm.vibrate = this.mVibratePref.isChecked();
        alarm.label = this.mLabel.getText();
        alarm.alert = this.mAlarmPref.getAlert();
        if (alarm.id == -1) {
            time = Alarms.addAlarm((Context)this, alarm);
            this.mId = alarm.id;
        } else {
            time = Alarms.setAlarm((Context)this, alarm);
        }
        return time;
    }

    private void deleteAlarm() {
        new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(2131230726)).setMessage((CharSequence)this.getString(2131230729)).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface d, int w) {
                Alarms.deleteAlarm((Context)SetAlarm.this, SetAlarm.this.mId);
                SetAlarm.this.finish();
            }
        }).setNegativeButton(0x1040000, null).show();
    }

    static void popAlarmSetToast(Context context, int hour, int minute, Alarm.DaysOfWeek daysOfWeek) {
        SetAlarm.popAlarmSetToast(context, Alarms.calculateAlarm(hour, minute, daysOfWeek).getTimeInMillis());
    }

    static void popAlarmSetToast(Context context, long timeInMillis) {
        String toastText = SetAlarm.formatToast(context, timeInMillis);
        Toast toast = Toast.makeText((Context)context, (CharSequence)toastText, (int)1);
        ToastMaster.setToast(toast);
        toast.show();
    }

    static String formatToast(Context context, long timeInMillis) {
        String minSeq;
        String daySeq;
        long delta = timeInMillis - System.currentTimeMillis();
        long hours = delta / 3600000L;
        long minutes = delta / 60000L % 60L;
        long days = hours / 24L;
        String string = days == 0L ? "" : (daySeq = days == 1L ? context.getString(2131230743) : context.getString(2131230744, new Object[]{Long.toString(days)}));
        String string2 = minutes == 0L ? "" : (minSeq = minutes == 1L ? context.getString(2131230747) : context.getString(2131230748, new Object[]{Long.toString(minutes)}));
        String hourSeq = hours == 0L ? "" : (hours == 1L ? context.getString(2131230745) : context.getString(2131230746, new Object[]{Long.toString(hours %= 24L)}));
        boolean dispDays = days > 0L;
        boolean dispHour = hours > 0L;
        boolean dispMinute = minutes > 0L;
        int index = (dispDays ? 1 : 0) | (dispHour ? 2 : 0) | (dispMinute ? 4 : 0);
        String[] formats = context.getResources().getStringArray(2131296256);
        return String.format(formats[index], daySeq, hourSeq, minSeq);
    }
}

