/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.preference.ListPreference;
import android.util.AttributeSet;
import com.android.deskclock.Alarm;
import java.text.DateFormatSymbols;

public class RepeatPreference
extends ListPreference {
    private Alarm.DaysOfWeek mDaysOfWeek = new Alarm.DaysOfWeek(0);
    private Alarm.DaysOfWeek mNewDaysOfWeek = new Alarm.DaysOfWeek(0);

    public RepeatPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        String[] weekdays = new DateFormatSymbols().getWeekdays();
        CharSequence[] values = new String[]{weekdays[2], weekdays[3], weekdays[4], weekdays[5], weekdays[6], weekdays[7], weekdays[1]};
        this.setEntries(values);
        this.setEntryValues(values);
    }

    protected void onDialogClosed(boolean positiveResult) {
        if (positiveResult) {
            this.mDaysOfWeek.set(this.mNewDaysOfWeek);
            this.setSummary(this.mDaysOfWeek.toString(this.getContext(), true));
            this.callChangeListener(this.mDaysOfWeek);
        }
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        CharSequence[] entries = this.getEntries();
        CharSequence[] entryValues = this.getEntryValues();
        builder.setMultiChoiceItems(entries, this.mDaysOfWeek.getBooleanArray(), new DialogInterface.OnMultiChoiceClickListener(){

            public void onClick(DialogInterface dialog, int which, boolean isChecked) {
                RepeatPreference.this.mNewDaysOfWeek.set(which, isChecked);
            }
        });
    }

    public void setDaysOfWeek(Alarm.DaysOfWeek dow) {
        this.mDaysOfWeek.set(dow);
        this.mNewDaysOfWeek.set(dow);
        this.setSummary(dow.toString(this.getContext(), true));
    }

    public Alarm.DaysOfWeek getDaysOfWeek() {
        return this.mDaysOfWeek;
    }
}

