/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import com.android.deskclock.Alarm;
import com.android.deskclock.AlarmClock;
import com.android.deskclock.Alarms;
import com.android.deskclock.SetAlarm;
import java.util.Calendar;

public class HandleSetAlarm
extends Activity {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Intent intent = this.getIntent();
        if (intent == null || !"android.intent.action.SET_ALARM".equals(intent.getAction())) {
            this.finish();
            return;
        }
        if (!intent.hasExtra("android.intent.extra.alarm.HOUR")) {
            this.startActivity(new Intent((Context)this, AlarmClock.class));
            this.finish();
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int n = intent.getIntExtra("android.intent.extra.alarm.HOUR", calendar.get(11));
        int n2 = intent.getIntExtra("android.intent.extra.alarm.MINUTES", calendar.get(12));
        String string = intent.getStringExtra("android.intent.extra.alarm.MESSAGE");
        if (string == null) {
            string = "";
        }
        Cursor cursor = null;
        long l = Alarms.calculateAlarm(n, n2, new Alarm.DaysOfWeek(0)).getTimeInMillis();
        try {
            cursor = this.getContentResolver().query(Alarm.Columns.CONTENT_URI, new String[]{"_id"}, "hour=" + n + " AND " + "minutes" + "=" + n2 + " AND " + "daysofweek" + "=0 AND " + "message" + "=?", new String[]{string}, null);
            if (cursor != null && cursor.moveToFirst()) {
                Alarms.enableAlarm((Context)this, cursor.getInt(0), true);
                SetAlarm.popAlarmSetToast((Context)this, l);
                this.finish();
                return;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hour", Integer.valueOf(n));
        contentValues.put("minutes", Integer.valueOf(n2));
        contentValues.put("message", string);
        contentValues.put("enabled", Integer.valueOf(1));
        contentValues.put("vibrate", Integer.valueOf(1));
        contentValues.put("daysofweek", Integer.valueOf(0));
        contentValues.put("alarmtime", Long.valueOf(l));
        if (this.getContentResolver().insert(Alarm.Columns.CONTENT_URI, contentValues) != null) {
            SetAlarm.popAlarmSetToast((Context)this, l);
            Alarms.setNextAlert((Context)this);
        }
        this.finish();
    }
}

