/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetManager;
import android.database.ContentObserver;
import android.graphics.Typeface;
import android.os.Handler;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.deskclock.Alarms;
import java.text.DateFormatSymbols;
import java.util.Calendar;

public class DigitalClock
extends LinearLayout {
    private Calendar mCalendar;
    private String mFormat;
    private TextView mTimeDisplay;
    private AmPm mAmPm;
    private ContentObserver mFormatChangeObserver;
    private boolean mLive = true;
    private boolean mAttached;
    private final Handler mHandler = new Handler();
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (DigitalClock.this.mLive && intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED")) {
                DigitalClock.this.mCalendar = Calendar.getInstance();
            }
            DigitalClock.this.mHandler.post(new Runnable(){

                public void run() {
                    DigitalClock.this.updateTime();
                }
            });
        }
    };
    private static Typeface sTypeface;

    public DigitalClock(Context context) {
        this(context, null);
    }

    public DigitalClock(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (sTypeface == null) {
            sTypeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)"fonts/Clockopia.ttf");
        }
        this.mTimeDisplay = (TextView)this.findViewById(2131492865);
        this.mTimeDisplay.setTypeface(sTypeface);
        this.mAmPm = new AmPm((View)this);
        this.mCalendar = Calendar.getInstance();
        this.setDateFormat();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mAttached) {
            return;
        }
        this.mAttached = true;
        if (this.mLive) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            this.getContext().registerReceiver(this.mIntentReceiver, filter);
        }
        this.mFormatChangeObserver = new FormatChangeObserver();
        this.getContext().getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, this.mFormatChangeObserver);
        this.updateTime();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.mAttached) {
            return;
        }
        this.mAttached = false;
        if (this.mLive) {
            this.getContext().unregisterReceiver(this.mIntentReceiver);
        }
        this.getContext().getContentResolver().unregisterContentObserver(this.mFormatChangeObserver);
    }

    void updateTime(Calendar c) {
        this.mCalendar = c;
        this.updateTime();
    }

    private void updateTime() {
        if (this.mLive) {
            this.mCalendar.setTimeInMillis(System.currentTimeMillis());
        }
        CharSequence newTime = DateFormat.format((CharSequence)this.mFormat, (Calendar)this.mCalendar);
        this.mTimeDisplay.setText(newTime);
        this.mAmPm.setIsMorning(this.mCalendar.get(9) == 0);
    }

    private void setDateFormat() {
        this.mFormat = Alarms.get24HourMode(this.getContext()) ? "kk:mm" : "h:mm";
        this.mAmPm.setShowAmPm(this.mFormat == "h:mm");
    }

    void setLive(boolean live) {
        this.mLive = live;
    }

    void setTypeface(Typeface tf) {
        this.mTimeDisplay.setTypeface(tf);
    }

    private class FormatChangeObserver
    extends ContentObserver {
        public FormatChangeObserver() {
            super(new Handler());
        }

        public void onChange(boolean selfChange) {
            DigitalClock.this.setDateFormat();
            DigitalClock.this.updateTime();
        }
    }

    static class AmPm {
        private TextView mAmPm;
        private String mAmString;
        private String mPmString;

        AmPm(View parent) {
            this.mAmPm = (TextView)parent.findViewById(2131492866);
            String[] ampm = new DateFormatSymbols().getAmPmStrings();
            this.mAmString = ampm[0];
            this.mPmString = ampm[1];
        }

        void setShowAmPm(boolean show) {
            this.mAmPm.setVisibility(show ? 0 : 8);
        }

        void setIsMorning(boolean isMorning) {
            this.mAmPm.setText((CharSequence)(isMorning ? this.mAmString : this.mPmString));
        }
    }
}

