/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.UiModeManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.Cursor;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.provider.MediaStore;
import android.provider.Settings;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AnimationUtils;
import android.widget.AbsoluteLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.deskclock.AlarmClock;
import com.android.deskclock.DigitalClock;
import com.android.deskclock.SetAlarm;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

public class DeskClock
extends Activity {
    private final long QUERY_WEATHER_DELAY = 3600000L;
    private final long SCREEN_SAVER_TIMEOUT = 300000L;
    private final long SCREEN_SAVER_MOVE_DELAY = 60000L;
    private final int SCREEN_SAVER_COLOR = -13598672;
    private final int SCREEN_SAVER_COLOR_DIM = -15192040;
    private final float DIM_BEHIND_AMOUNT_NORMAL = 0.4f;
    private final float DIM_BEHIND_AMOUNT_DIMMED = 0.8f;
    private final int QUERY_WEATHER_DATA_MSG = 4096;
    private final int UPDATE_WEATHER_DISPLAY_MSG = 4097;
    private final int SCREEN_SAVER_TIMEOUT_MSG = 8192;
    private final int SCREEN_SAVER_MOVE_MSG = 8193;
    private static final String[] WEATHER_CONTENT_COLUMNS = new String[]{"location", "timestamp", "temperature", "highTemperature", "lowTemperature", "iconUrl", "iconResId", "description"};
    private DigitalClock mTime;
    private TextView mDate;
    private TextView mNextAlarm = null;
    private TextView mBatteryDisplay;
    private TextView mWeatherCurrentTemperature;
    private TextView mWeatherHighTemperature;
    private TextView mWeatherLowTemperature;
    private TextView mWeatherLocation;
    private ImageView mWeatherIcon;
    private String mWeatherCurrentTemperatureString;
    private String mWeatherHighTemperatureString;
    private String mWeatherLowTemperatureString;
    private String mWeatherLocationString;
    private Drawable mWeatherIconDrawable;
    private Resources mGenieResources = null;
    private boolean mDimmed = false;
    private boolean mScreenSaverMode = false;
    private String mDateFormat;
    private int mBatteryLevel = -1;
    private boolean mPluggedIn = false;
    private boolean mLaunchedFromDock = false;
    private Random mRNG;
    private PendingIntent mMidnightIntent;
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.DATE_CHANGED".equals(action) || "com.android.deskclock.MIDNIGHT".equals(action)) {
                DeskClock.this.refreshDate();
            } else if ("android.intent.action.BATTERY_CHANGED".equals(action)) {
                DeskClock.this.handleBatteryUpdate(intent.getIntExtra("plugged", 0), intent.getIntExtra("status", 1), intent.getIntExtra("level", 0));
            } else if (UiModeManager.ACTION_EXIT_DESK_MODE.equals(action)) {
                if (DeskClock.this.mLaunchedFromDock) {
                    DeskClock.this.finish();
                }
                DeskClock.this.mLaunchedFromDock = false;
            }
        }
    };
    private final Handler mHandy = new Handler(){

        public void handleMessage(Message m) {
            if (m.what == 4096) {
                new Thread(){

                    public void run() {
                        DeskClock.this.queryWeatherData();
                    }
                }.start();
                DeskClock.this.scheduleWeatherQueryDelayed(3600000L);
            } else if (m.what == 4097) {
                DeskClock.this.updateWeatherDisplay();
            } else if (m.what == 8192) {
                DeskClock.this.saveScreen();
            } else if (m.what == 8193) {
                DeskClock.this.moveScreenSaver();
            }
        }
    };
    private final ContentObserver mContentObserver = new ContentObserver(this.mHandy){

        public void onChange(boolean selfChange) {
            DeskClock.this.refreshWeather();
        }
    };

    private void moveScreenSaver() {
        this.moveScreenSaverTo(-1, -1);
    }

    private void moveScreenSaverTo(int x, int y) {
        if (!this.mScreenSaverMode) {
            return;
        }
        View saver_view = this.findViewById(2131492891);
        DisplayMetrics metrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        if (x < 0 || y < 0) {
            int myWidth = saver_view.getMeasuredWidth();
            int myHeight = saver_view.getMeasuredHeight();
            x = (int)(this.mRNG.nextFloat() * (float)(metrics.widthPixels - myWidth));
            y = (int)(this.mRNG.nextFloat() * (float)(metrics.heightPixels - myHeight));
        }
        saver_view.setLayoutParams((ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(-2, -2, x, y));
        this.mHandy.sendEmptyMessageDelayed(8193, 60000L + (1000L - System.currentTimeMillis() % 1000L));
    }

    private void setWakeLock(boolean hold) {
        Window win = this.getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        winParams.flags |= 0x680001;
        winParams.flags = hold ? (winParams.flags |= 0x80) : (winParams.flags &= 0xFFFFFF7F);
        win.setAttributes(winParams);
    }

    private void scheduleScreenSaver() {
        this.mHandy.removeMessages(8192);
        this.mHandy.sendMessageDelayed(Message.obtain((Handler)this.mHandy, (int)8192), 300000L);
    }

    private void restoreScreen() {
        if (!this.mScreenSaverMode) {
            return;
        }
        this.mScreenSaverMode = false;
        this.initViews();
        this.doDim(false);
        if (this.mPluggedIn) {
            this.requestWeatherDataFetch();
        }
        this.scheduleScreenSaver();
        this.refreshAll();
    }

    private void saveScreen() {
        if (this.mScreenSaverMode) {
            return;
        }
        View oldTimeDate = this.findViewById(2131492892);
        int[] oldLoc = new int[2];
        oldTimeDate.getLocationOnScreen(oldLoc);
        this.mScreenSaverMode = true;
        Window win = this.getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        winParams.flags |= 0x400;
        win.setAttributes(winParams);
        View focused = this.getCurrentFocus();
        if (focused != null) {
            focused.clearFocus();
        }
        this.setContentView(2130903048);
        this.mTime = (DigitalClock)this.findViewById(2131492893);
        this.mDate = (TextView)this.findViewById(2131492894);
        this.mNextAlarm = (TextView)this.findViewById(2131492883);
        int color = this.mDimmed ? -15192040 : -13598672;
        ((TextView)this.findViewById(2131492865)).setTextColor(color);
        ((TextView)this.findViewById(2131492866)).setTextColor(color);
        this.mDate.setTextColor(color);
        this.mNextAlarm.setTextColor(color);
        this.mNextAlarm.setCompoundDrawablesWithIntrinsicBounds(this.getResources().getDrawable(this.mDimmed ? 2130837545 : 2130837544), null, null, null);
        this.mWeatherLocation = null;
        this.mWeatherLowTemperature = null;
        this.mWeatherHighTemperature = null;
        this.mWeatherCurrentTemperature = null;
        this.mBatteryDisplay = null;
        this.mWeatherIcon = null;
        this.refreshDate();
        this.refreshAlarm();
        this.moveScreenSaverTo(oldLoc[0], oldLoc[1]);
    }

    public void onUserInteraction() {
        if (this.mScreenSaverMode) {
            this.restoreScreen();
        }
    }

    private void requestWeatherDataFetch() {
        this.sendBroadcast(new Intent("com.google.android.apps.genie.REFRESH").putExtra("requestWeather", true));
    }

    private boolean supportsWeather() {
        return this.mGenieResources != null;
    }

    private void scheduleWeatherQueryDelayed(long delay) {
        this.unscheduleWeatherQuery();
        this.mHandy.sendEmptyMessageDelayed(4096, delay);
    }

    private void unscheduleWeatherQuery() {
        this.mHandy.removeMessages(4096);
    }

    private void queryWeatherData() {
        Cursor cur;
        if (this.mGenieResources == null) {
            return;
        }
        Uri queryUri = new Uri.Builder().scheme("content").authority("com.google.android.apps.genie.geniewidget.weather").path("/weather/current").appendPath(new Long(System.currentTimeMillis()).toString()).build();
        try {
            cur = this.getContentResolver().query(queryUri, WEATHER_CONTENT_COLUMNS, null, null, null);
        }
        catch (RuntimeException e) {
            Log.e((String)"DeskClock", (String)"Weather query failed", (Throwable)e);
            cur = null;
        }
        if (cur != null && cur.moveToFirst()) {
            this.mWeatherIconDrawable = this.mGenieResources.getDrawable(cur.getInt(cur.getColumnIndexOrThrow("iconResId")));
            this.mWeatherLocationString = cur.getString(cur.getColumnIndexOrThrow("location"));
            int colTemp = cur.getColumnIndexOrThrow("temperature");
            int colHigh = cur.getColumnIndexOrThrow("highTemperature");
            int colLow = cur.getColumnIndexOrThrow("lowTemperature");
            this.mWeatherCurrentTemperatureString = cur.isNull(colTemp) ? "\u2014" : String.format("%d\u00b0", cur.getInt(colTemp));
            this.mWeatherHighTemperatureString = cur.isNull(colHigh) ? "\u2014" : String.format("%d\u00b0", cur.getInt(colHigh));
            this.mWeatherLowTemperatureString = cur.isNull(colLow) ? "\u2014" : String.format("%d\u00b0", cur.getInt(colLow));
        } else {
            Log.w((String)"DeskClock", (String)("No weather information available (cur=" + cur + ")"));
            this.mWeatherIconDrawable = null;
            this.mWeatherLocationString = this.getString(2131230777);
            this.mWeatherLowTemperatureString = "";
            this.mWeatherHighTemperatureString = "";
            this.mWeatherCurrentTemperatureString = "";
        }
        if (cur != null) {
            cur.close();
        }
        this.mHandy.sendEmptyMessage(4097);
    }

    private void refreshWeather() {
        if (this.supportsWeather()) {
            this.scheduleWeatherQueryDelayed(0L);
        }
        this.updateWeatherDisplay();
    }

    private void updateWeatherDisplay() {
        if (this.mWeatherCurrentTemperature == null) {
            return;
        }
        this.mWeatherCurrentTemperature.setText((CharSequence)this.mWeatherCurrentTemperatureString);
        this.mWeatherHighTemperature.setText((CharSequence)this.mWeatherHighTemperatureString);
        this.mWeatherLowTemperature.setText((CharSequence)this.mWeatherLowTemperatureString);
        this.mWeatherLocation.setText((CharSequence)this.mWeatherLocationString);
        this.mWeatherIcon.setImageDrawable(this.mWeatherIconDrawable);
    }

    private void handleBatteryUpdate(int plugged, int status, int level) {
        boolean pluggedIn;
        boolean bl = pluggedIn = plugged != 0;
        if (pluggedIn != this.mPluggedIn) {
            this.setWakeLock(pluggedIn);
            if (pluggedIn) {
                this.requestWeatherDataFetch();
            }
        }
        if (pluggedIn != this.mPluggedIn || level != this.mBatteryLevel) {
            this.mBatteryLevel = level;
            this.mPluggedIn = pluggedIn;
            this.refreshBattery();
        }
    }

    private void refreshBattery() {
        if (this.mBatteryDisplay == null) {
            return;
        }
        if (this.mPluggedIn) {
            this.mBatteryDisplay.setCompoundDrawablesWithIntrinsicBounds(0, 0, 17301534, 0);
            this.mBatteryDisplay.setText((CharSequence)this.getString(2131230776, new Object[]{this.mBatteryLevel}));
            this.mBatteryDisplay.setVisibility(0);
        } else {
            this.mBatteryDisplay.setVisibility(4);
        }
    }

    private void refreshDate() {
        Date now = new Date();
        this.mDate.setText(DateFormat.format((CharSequence)this.mDateFormat, (Date)now));
    }

    private void refreshAlarm() {
        if (this.mNextAlarm == null) {
            return;
        }
        String nextAlarm = Settings.System.getString((ContentResolver)this.getContentResolver(), (String)"next_alarm_formatted");
        if (!TextUtils.isEmpty((CharSequence)nextAlarm)) {
            this.mNextAlarm.setText((CharSequence)nextAlarm);
            this.mNextAlarm.setVisibility(0);
        } else {
            this.mNextAlarm.setVisibility(4);
        }
    }

    private void refreshAll() {
        this.refreshDate();
        this.refreshAlarm();
        this.refreshBattery();
        this.refreshWeather();
    }

    private void doDim(boolean fade) {
        View tintView = this.findViewById(2131492886);
        if (tintView == null) {
            return;
        }
        Window win = this.getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        winParams.flags |= 0x100;
        winParams.flags |= 0x200;
        winParams.flags |= 2;
        if (this.mDimmed) {
            winParams.flags |= 0x400;
            winParams.dimAmount = 0.8f;
            winParams.buttonBrightness = 0.0f;
            tintView.startAnimation(AnimationUtils.loadAnimation((Context)this, (int)(fade ? 2130968576 : 2130968577)));
        } else {
            winParams.flags &= 0xFFFFFBFF;
            winParams.dimAmount = 0.4f;
            winParams.buttonBrightness = -1.0f;
            tintView.startAnimation(AnimationUtils.loadAnimation((Context)this, (int)(fade ? 2130968578 : 2130968579)));
        }
        win.setAttributes(winParams);
    }

    public void onNewIntent(Intent newIntent) {
        super.onNewIntent(newIntent);
        this.setIntent(newIntent);
    }

    public void onStart() {
        super.onStart();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.DATE_CHANGED");
        filter.addAction("android.intent.action.BATTERY_CHANGED");
        filter.addAction(UiModeManager.ACTION_EXIT_DESK_MODE);
        filter.addAction("com.android.deskclock.MIDNIGHT");
        this.registerReceiver(this.mIntentReceiver, filter);
    }

    public void onStop() {
        super.onStop();
        this.unregisterReceiver(this.mIntentReceiver);
    }

    public void onResume() {
        super.onResume();
        this.mDateFormat = this.getString(2131230720);
        Uri weatherNotificationUri = new Uri.Builder().scheme("content").authority("com.google.android.apps.genie.geniewidget.weather").path("/weather/current").build();
        this.getContentResolver().registerContentObserver(weatherNotificationUri, true, this.mContentObserver);
        Calendar today = Calendar.getInstance();
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.add(5, 1);
        long alarmTimeUTC = today.getTimeInMillis();
        this.mMidnightIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)new Intent("com.android.deskclock.MIDNIGHT"), (int)0);
        AlarmManager am = (AlarmManager)this.getSystemService("alarm");
        am.setRepeating(1, alarmTimeUTC, 86400000L, this.mMidnightIntent);
        if (this.mTime != null && this.mTime.getWindowVisibility() != 0) {
            this.mDimmed = false;
        }
        this.doDim(false);
        this.restoreScreen();
        this.refreshAll();
        this.setWakeLock(this.mPluggedIn);
        this.scheduleScreenSaver();
        boolean launchedFromDock = this.getIntent().hasCategory("android.intent.category.DESK_DOCK");
        if (this.supportsWeather() && launchedFromDock && !this.mLaunchedFromDock) {
            this.requestWeatherDataFetch();
        }
        this.mLaunchedFromDock = launchedFromDock;
    }

    public void onPause() {
        this.mHandy.removeMessages(8192);
        this.restoreScreen();
        this.getContentResolver().unregisterContentObserver(this.mContentObserver);
        AlarmManager am = (AlarmManager)this.getSystemService("alarm");
        am.cancel(this.mMidnightIntent);
        this.unscheduleWeatherQuery();
        super.onPause();
    }

    private void initViews() {
        View view = this.getCurrentFocus();
        if (view != null) {
            view.clearFocus();
        }
        this.setContentView(2130903045);
        this.mTime = (DigitalClock)this.findViewById(2131492893);
        this.mDate = (TextView)this.findViewById(2131492894);
        this.mBatteryDisplay = (TextView)this.findViewById(2131492887);
        this.mTime.getRootView().requestFocus();
        this.mWeatherCurrentTemperature = (TextView)this.findViewById(2131492898);
        this.mWeatherHighTemperature = (TextView)this.findViewById(2131492900);
        this.mWeatherLowTemperature = (TextView)this.findViewById(2131492899);
        this.mWeatherLocation = (TextView)this.findViewById(2131492901);
        this.mWeatherIcon = (ImageView)this.findViewById(2131492897);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                DeskClock.this.startActivity(new Intent((Context)DeskClock.this, AlarmClock.class));
            }
        };
        this.mNextAlarm = (TextView)this.findViewById(2131492883);
        this.mNextAlarm.setOnClickListener(onClickListener);
        final ImageButton imageButton = (ImageButton)this.findViewById(2131492885);
        imageButton.setOnClickListener(onClickListener);
        ImageButton imageButton2 = (ImageButton)this.findViewById(2131492888);
        imageButton2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    DeskClock.this.startActivity(new Intent("android.intent.action.VIEW", MediaStore.Images.Media.EXTERNAL_CONTENT_URI).putExtra("slideshow", true).addFlags(0x14000000));
                }
                catch (ActivityNotFoundException e) {
                    Log.e((String)"DeskClock", (String)"Couldn't launch image browser", (Throwable)e);
                }
            }
        });
        ImageButton imageButton3 = (ImageButton)this.findViewById(2131492889);
        imageButton3.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    DeskClock.this.startActivity(new Intent("android.intent.action.MUSIC_PLAYER").addFlags(0x14000000));
                }
                catch (ActivityNotFoundException e) {
                    Log.e((String)"DeskClock", (String)"Couldn't launch music browser", (Throwable)e);
                }
            }
        });
        ImageButton imageButton4 = (ImageButton)this.findViewById(2131492890);
        imageButton4.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DeskClock.this.startActivity(new Intent("android.intent.action.MAIN").addFlags(0x14000000).addCategory("android.intent.category.HOME"));
            }
        });
        final ImageButton imageButton5 = (ImageButton)this.findViewById(2131492884);
        imageButton5.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DeskClock.this.mDimmed = !DeskClock.this.mDimmed;
                DeskClock.this.doDim(true);
            }
        });
        imageButton5.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                DeskClock.this.saveScreen();
                return true;
            }
        });
        View view2 = this.findViewById(2131492895);
        view2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!DeskClock.this.supportsWeather()) {
                    return;
                }
                Intent genieAppQuery = DeskClock.this.getPackageManager().getLaunchIntentForPackage("com.google.android.apps.genie.geniewidget").addFlags(0x14000000);
                if (genieAppQuery != null) {
                    DeskClock.this.startActivity(genieAppQuery);
                }
            }
        });
        View view3 = this.findViewById(2131492886);
        view3.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (DeskClock.this.mDimmed && event.getAction() == 0) {
                    Rect r = new Rect();
                    imageButton5.getHitRect(r);
                    int[] gloc = new int[2];
                    imageButton5.getLocationInWindow(gloc);
                    r.offsetTo(gloc[0], gloc[1]);
                    if (!r.contains((int)event.getX(), (int)event.getY())) {
                        DeskClock.this.mDimmed = false;
                        DeskClock.this.doDim(true);
                    }
                }
                return false;
            }
        });
        ViewTreeObserver viewTreeObserver = imageButton.getViewTreeObserver();
        viewTreeObserver.addOnGlobalFocusChangeListener(new ViewTreeObserver.OnGlobalFocusChangeListener(){

            public void onGlobalFocusChanged(View oldFocus, View newFocus) {
                if (oldFocus == null && newFocus == imageButton5) {
                    imageButton.requestFocus();
                }
            }
        });
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mScreenSaverMode) {
            this.moveScreenSaver();
        } else {
            this.initViews();
            this.doDim(false);
            this.refreshAll();
        }
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        switch (menuItem.getItemId()) {
            case 2131492911: {
                this.startActivity(new Intent((Context)this, AlarmClock.class));
                return true;
            }
            case 2131492906: {
                this.startActivity(new Intent((Context)this, SetAlarm.class));
                return true;
            }
            case 2131492912: {
                this.startActivity(new Intent("com.android.settings.DOCK_SETTINGS"));
                return true;
            }
        }
        return false;
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(2131427330, menu);
        return true;
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mRNG = new Random();
        try {
            this.mGenieResources = this.getPackageManager().getResourcesForApplication("com.google.android.apps.genie.geniewidget");
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"DeskClock", (String)"Can't find com.google.android.apps.genie.geniewidget. Weather forecast will not be available.");
        }
        this.initViews();
    }
}

