/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.provider.Settings;
import android.text.format.DateFormat;
import com.android.deskclock.Alarm;
import com.android.deskclock.Log;
import java.util.Calendar;

public class Alarms {
    public static long addAlarm(Context context, Alarm alarm) {
        ContentValues values = Alarms.createContentValues(alarm);
        Uri uri = context.getContentResolver().insert(Alarm.Columns.CONTENT_URI, values);
        alarm.id = (int)ContentUris.parseId((Uri)uri);
        long timeInMillis = Alarms.calculateAlarm(alarm);
        if (alarm.enabled) {
            Alarms.clearSnoozeIfNeeded(context, timeInMillis);
        }
        Alarms.setNextAlert(context);
        return timeInMillis;
    }

    public static void deleteAlarm(Context context, int alarmId) {
        if (alarmId == -1) {
            return;
        }
        ContentResolver contentResolver = context.getContentResolver();
        Alarms.disableSnoozeAlert(context, alarmId);
        Uri uri = ContentUris.withAppendedId((Uri)Alarm.Columns.CONTENT_URI, (long)alarmId);
        contentResolver.delete(uri, "", null);
        Alarms.setNextAlert(context);
    }

    public static Cursor getAlarmsCursor(ContentResolver contentResolver) {
        return contentResolver.query(Alarm.Columns.CONTENT_URI, Alarm.Columns.ALARM_QUERY_COLUMNS, null, null, "hour, minutes ASC");
    }

    private static Cursor getFilteredAlarmsCursor(ContentResolver contentResolver) {
        return contentResolver.query(Alarm.Columns.CONTENT_URI, Alarm.Columns.ALARM_QUERY_COLUMNS, "enabled=1", null, null);
    }

    private static ContentValues createContentValues(Alarm alarm) {
        ContentValues values = new ContentValues(8);
        long time = 0L;
        if (!alarm.daysOfWeek.isRepeatSet()) {
            time = Alarms.calculateAlarm(alarm);
        }
        values.put("enabled", Integer.valueOf(alarm.enabled ? 1 : 0));
        values.put("hour", Integer.valueOf(alarm.hour));
        values.put("minutes", Integer.valueOf(alarm.minutes));
        values.put("alarmtime", Long.valueOf(alarm.time));
        values.put("daysofweek", Integer.valueOf(alarm.daysOfWeek.getCoded()));
        values.put("vibrate", Boolean.valueOf(alarm.vibrate));
        values.put("message", alarm.label);
        values.put("alert", alarm.alert == null ? "silent" : alarm.alert.toString());
        return values;
    }

    private static void clearSnoozeIfNeeded(Context context, long alarmTime) {
        SharedPreferences prefs = context.getSharedPreferences("AlarmClock", 0);
        long snoozeTime = prefs.getLong("snooze_time", 0L);
        if (alarmTime < snoozeTime) {
            Alarms.clearSnoozePreference(context, prefs);
        }
    }

    public static Alarm getAlarm(ContentResolver contentResolver, int alarmId) {
        Cursor cursor = contentResolver.query(ContentUris.withAppendedId((Uri)Alarm.Columns.CONTENT_URI, (long)alarmId), Alarm.Columns.ALARM_QUERY_COLUMNS, null, null, null);
        Alarm alarm = null;
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                alarm = new Alarm(cursor);
            }
            cursor.close();
        }
        return alarm;
    }

    public static long setAlarm(Context context, Alarm alarm) {
        ContentValues values = Alarms.createContentValues(alarm);
        ContentResolver resolver = context.getContentResolver();
        resolver.update(ContentUris.withAppendedId((Uri)Alarm.Columns.CONTENT_URI, (long)alarm.id), values, null, null);
        long timeInMillis = Alarms.calculateAlarm(alarm);
        if (alarm.enabled) {
            Alarms.disableSnoozeAlert(context, alarm.id);
            Alarms.clearSnoozeIfNeeded(context, timeInMillis);
        }
        Alarms.setNextAlert(context);
        return timeInMillis;
    }

    public static void enableAlarm(Context context, int id, boolean enabled) {
        Alarms.enableAlarmInternal(context, id, enabled);
        Alarms.setNextAlert(context);
    }

    private static void enableAlarmInternal(Context context, int id, boolean enabled) {
        Alarms.enableAlarmInternal(context, Alarms.getAlarm(context.getContentResolver(), id), enabled);
    }

    private static void enableAlarmInternal(Context context, Alarm alarm, boolean enabled) {
        if (alarm == null) {
            return;
        }
        ContentResolver resolver = context.getContentResolver();
        ContentValues values = new ContentValues(2);
        values.put("enabled", Integer.valueOf(enabled ? 1 : 0));
        if (enabled) {
            long time = 0L;
            if (!alarm.daysOfWeek.isRepeatSet()) {
                time = Alarms.calculateAlarm(alarm);
            }
            values.put("alarmtime", Long.valueOf(time));
        } else {
            Alarms.disableSnoozeAlert(context, alarm.id);
        }
        resolver.update(ContentUris.withAppendedId((Uri)Alarm.Columns.CONTENT_URI, (long)alarm.id), values, null, null);
    }

    public static Alarm calculateNextAlert(Context context) {
        Alarm alarm = null;
        long minTime = Long.MAX_VALUE;
        long now = System.currentTimeMillis();
        Cursor cursor = Alarms.getFilteredAlarmsCursor(context.getContentResolver());
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                do {
                    Alarm a = new Alarm(cursor);
                    if (a.time == 0L) {
                        a.time = Alarms.calculateAlarm(a);
                    } else if (a.time < now) {
                        Log.v("Disabling expired alarm set for " + Log.formatTime(a.time));
                        Alarms.enableAlarmInternal(context, a, false);
                        continue;
                    }
                    if (a.time >= minTime) continue;
                    minTime = a.time;
                    alarm = a;
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return alarm;
    }

    public static void disableExpiredAlarms(Context context) {
        Cursor cur = Alarms.getFilteredAlarmsCursor(context.getContentResolver());
        long now = System.currentTimeMillis();
        if (cur.moveToFirst()) {
            do {
                Alarm alarm = new Alarm(cur);
                if (alarm.time == 0L || alarm.time >= now) continue;
                Log.v("Disabling expired alarm set for " + Log.formatTime(alarm.time));
                Alarms.enableAlarmInternal(context, alarm, false);
            } while (cur.moveToNext());
        }
        cur.close();
    }

    public static void setNextAlert(Context context) {
        if (!Alarms.enableSnoozeAlert(context)) {
            Alarm alarm = Alarms.calculateNextAlert(context);
            if (alarm != null) {
                Alarms.enableAlert(context, alarm, alarm.time);
            } else {
                Alarms.disableAlert(context);
            }
        }
    }

    private static void enableAlert(Context context, Alarm alarm, long atTimeInMillis) {
        AlarmManager am = (AlarmManager)context.getSystemService("alarm");
        Intent intent = new Intent("com.android.deskclock.ALARM_ALERT");
        Parcel out = Parcel.obtain();
        alarm.writeToParcel(out, 0);
        out.setDataPosition(0);
        intent.putExtra("intent.extra.alarm_raw", out.marshall());
        PendingIntent sender = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x10000000);
        am.set(0, atTimeInMillis, sender);
        Alarms.setStatusBarIcon(context, true);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(atTimeInMillis);
        String timeString = Alarms.formatDayAndTime(context, c);
        Alarms.saveNextAlarm(context, timeString);
    }

    static void disableAlert(Context context) {
        AlarmManager am = (AlarmManager)context.getSystemService("alarm");
        PendingIntent sender = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent("com.android.deskclock.ALARM_ALERT"), (int)0x10000000);
        am.cancel(sender);
        Alarms.setStatusBarIcon(context, false);
        Alarms.saveNextAlarm(context, "");
    }

    static void saveSnoozeAlert(Context context, int id, long time) {
        SharedPreferences prefs = context.getSharedPreferences("AlarmClock", 0);
        if (id == -1) {
            Alarms.clearSnoozePreference(context, prefs);
        } else {
            SharedPreferences.Editor ed = prefs.edit();
            ed.putInt("snooze_id", id);
            ed.putLong("snooze_time", time);
            ed.apply();
        }
        Alarms.setNextAlert(context);
    }

    static void disableSnoozeAlert(Context context, int id) {
        SharedPreferences prefs = context.getSharedPreferences("AlarmClock", 0);
        int snoozeId = prefs.getInt("snooze_id", -1);
        if (snoozeId == -1) {
            return;
        }
        if (snoozeId == id) {
            Alarms.clearSnoozePreference(context, prefs);
        }
    }

    private static void clearSnoozePreference(Context context, SharedPreferences prefs) {
        int alarmId = prefs.getInt("snooze_id", -1);
        if (alarmId != -1) {
            NotificationManager nm = (NotificationManager)context.getSystemService("notification");
            nm.cancel(alarmId);
        }
        SharedPreferences.Editor ed = prefs.edit();
        ed.remove("snooze_id");
        ed.remove("snooze_time");
        ed.apply();
    }

    private static boolean enableSnoozeAlert(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("AlarmClock", 0);
        int id = prefs.getInt("snooze_id", -1);
        if (id == -1) {
            return false;
        }
        long time = prefs.getLong("snooze_time", -1L);
        Alarm alarm = Alarms.getAlarm(context.getContentResolver(), id);
        if (alarm == null) {
            return false;
        }
        alarm.time = time;
        Alarms.enableAlert(context, alarm, time);
        return true;
    }

    private static void setStatusBarIcon(Context context, boolean enabled) {
        Intent alarmChanged = new Intent("android.intent.action.ALARM_CHANGED");
        alarmChanged.putExtra("alarmSet", enabled);
        context.sendBroadcast(alarmChanged);
    }

    private static long calculateAlarm(Alarm alarm) {
        return Alarms.calculateAlarm(alarm.hour, alarm.minutes, alarm.daysOfWeek).getTimeInMillis();
    }

    static Calendar calculateAlarm(int hour, int minute, Alarm.DaysOfWeek daysOfWeek) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        int nowHour = c.get(11);
        int nowMinute = c.get(12);
        if (hour < nowHour || hour == nowHour && minute <= nowMinute) {
            c.add(6, 1);
        }
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, 0);
        c.set(14, 0);
        int addDays = daysOfWeek.getNextAlarm(c);
        if (addDays > 0) {
            c.add(7, addDays);
        }
        return c;
    }

    static String formatTime(Context context, int hour, int minute, Alarm.DaysOfWeek daysOfWeek) {
        Calendar c = Alarms.calculateAlarm(hour, minute, daysOfWeek);
        return Alarms.formatTime(context, c);
    }

    static String formatTime(Context context, Calendar c) {
        String format = Alarms.get24HourMode(context) ? "kk:mm" : "h:mm aa";
        return c == null ? "" : (String)DateFormat.format((CharSequence)format, (Calendar)c);
    }

    private static String formatDayAndTime(Context context, Calendar c) {
        String format = Alarms.get24HourMode(context) ? "E k:mm" : "E h:mm aa";
        return c == null ? "" : (String)DateFormat.format((CharSequence)format, (Calendar)c);
    }

    static void saveNextAlarm(Context context, String timeString) {
        Settings.System.putString((ContentResolver)context.getContentResolver(), (String)"next_alarm_formatted", (String)timeString);
    }

    static boolean get24HourMode(Context context) {
        return DateFormat.is24HourFormat((Context)context);
    }
}

