/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.deskclock.Alarm;
import com.android.deskclock.AlarmAlert;
import com.android.deskclock.AlarmAlertFullScreen;
import com.android.deskclock.AlarmAlertWakeLock;
import com.android.deskclock.Alarms;
import com.android.deskclock.Log;
import com.android.deskclock.SetAlarm;

public class AlarmReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        if ("alarm_killed".equals(intent.getAction())) {
            this.updateNotification(context, (Alarm)intent.getParcelableExtra("intent.extra.alarm"), intent.getIntExtra("alarm_killed_timeout", -1));
            return;
        }
        if ("cancel_snooze".equals(intent.getAction())) {
            Alarms.saveSnoozeAlert(context, -1, -1L);
            return;
        }
        if (!"com.android.deskclock.ALARM_ALERT".equals(intent.getAction())) {
            return;
        }
        Alarm alarm = null;
        byte[] byArray = intent.getByteArrayExtra("intent.extra.alarm_raw");
        if (byArray != null) {
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            alarm = (Alarm)Alarm.CREATOR.createFromParcel(parcel);
        }
        if (alarm == null) {
            Log.wtf("Failed to parse the alarm from the intent");
            Alarms.setNextAlert(context);
            return;
        }
        Alarms.disableSnoozeAlert(context, alarm.id);
        if (!alarm.daysOfWeek.isRepeatSet()) {
            Alarms.enableAlarm(context, alarm.id, false);
        } else {
            Alarms.setNextAlert(context);
        }
        long l = System.currentTimeMillis();
        Log.v("Recevied alarm set for " + Log.formatTime(alarm.time));
        if (l > alarm.time + 1800000L) {
            Log.v("Ignoring stale alarm");
            return;
        }
        AlarmAlertWakeLock.acquireCpuWakeLock(context);
        Intent intent2 = new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        context.sendBroadcast(intent2);
        Class clazz = AlarmAlert.class;
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        if (keyguardManager.inKeyguardRestrictedInputMode()) {
            clazz = AlarmAlertFullScreen.class;
        }
        Intent intent3 = new Intent("com.android.deskclock.ALARM_ALERT");
        intent3.putExtra("intent.extra.alarm", (Parcelable)alarm);
        context.startService(intent3);
        Intent intent4 = new Intent(context, AlarmAlert.class);
        intent4.putExtra("intent.extra.alarm", (Parcelable)alarm);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)alarm.id, (Intent)intent4, (int)0);
        String string = alarm.getLabelOrDefault(context);
        Notification notification = new Notification(2130837556, (CharSequence)string, alarm.time);
        notification.setLatestEventInfo(context, (CharSequence)string, (CharSequence)context.getString(2131230764), pendingIntent);
        notification.flags |= 3;
        notification.defaults |= 4;
        Intent intent5 = new Intent(context, clazz);
        intent5.putExtra("intent.extra.alarm", (Parcelable)alarm);
        intent5.setFlags(0x10040000);
        notification.fullScreenIntent = PendingIntent.getActivity((Context)context, (int)alarm.id, (Intent)intent5, (int)0);
        NotificationManager notificationManager = this.getNotificationManager(context);
        notificationManager.notify(alarm.id, notification);
    }

    private NotificationManager getNotificationManager(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    private void updateNotification(Context context, Alarm alarm, int n) {
        NotificationManager notificationManager = this.getNotificationManager(context);
        if (alarm == null) {
            return;
        }
        Intent intent = new Intent(context, SetAlarm.class);
        intent.putExtra("alarm_id", alarm.id);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)alarm.id, (Intent)intent, (int)0);
        String string = alarm.getLabelOrDefault(context);
        Notification notification = new Notification(2130837556, (CharSequence)string, alarm.time);
        notification.setLatestEventInfo(context, (CharSequence)string, (CharSequence)context.getString(2131230740, new Object[]{n}), pendingIntent);
        notification.flags |= 0x10;
        notificationManager.cancel(alarm.id);
        notificationManager.notify(alarm.id, notification);
    }
}

