/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;
import com.android.deskclock.Alarm;

public class AlarmProvider
extends ContentProvider {
    private SQLiteOpenHelper mOpenHelper;
    private static final UriMatcher sURLMatcher = new UriMatcher(-1);

    public boolean onCreate() {
        this.mOpenHelper = new DatabaseHelper(this.getContext());
        return true;
    }

    public Cursor query(Uri url, String[] projectionIn, String selection, String[] selectionArgs, String sort) {
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        int match = sURLMatcher.match(url);
        switch (match) {
            case 1: {
                qb.setTables("alarms");
                break;
            }
            case 2: {
                qb.setTables("alarms");
                qb.appendWhere((CharSequence)"_id=");
                qb.appendWhere((CharSequence)url.getPathSegments().get(1));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URL " + url);
            }
        }
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor ret = qb.query(db, projectionIn, selection, selectionArgs, null, null, sort);
        if (ret != null) {
            ret.setNotificationUri(this.getContext().getContentResolver(), url);
        }
        return ret;
    }

    public String getType(Uri url) {
        int match = sURLMatcher.match(url);
        switch (match) {
            case 1: {
                return "vnd.android.cursor.dir/alarms";
            }
            case 2: {
                return "vnd.android.cursor.item/alarms";
            }
        }
        throw new IllegalArgumentException("Unknown URL");
    }

    public int update(Uri url, ContentValues values, String where, String[] whereArgs) {
        int count;
        long rowId = 0L;
        int match = sURLMatcher.match(url);
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        switch (match) {
            case 2: {
                String segment = (String)url.getPathSegments().get(1);
                rowId = Long.parseLong(segment);
                count = db.update("alarms", values, "_id=" + rowId, null);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot update URL: " + url);
            }
        }
        this.getContext().getContentResolver().notifyChange(url, null);
        return count;
    }

    public Uri insert(Uri url, ContentValues initialValues) {
        if (sURLMatcher.match(url) != 1) {
            throw new IllegalArgumentException("Cannot insert into URL: " + url);
        }
        ContentValues values = new ContentValues(initialValues);
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        long rowId = db.insert("alarms", "message", values);
        if (rowId < 0L) {
            throw new SQLException("Failed to insert row into " + url);
        }
        Uri newUrl = ContentUris.withAppendedId((Uri)Alarm.Columns.CONTENT_URI, (long)rowId);
        this.getContext().getContentResolver().notifyChange(newUrl, null);
        return newUrl;
    }

    public int delete(Uri url, String where, String[] whereArgs) {
        int count;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        long rowId = 0L;
        switch (sURLMatcher.match(url)) {
            case 1: {
                count = db.delete("alarms", where, whereArgs);
                break;
            }
            case 2: {
                String segment = (String)url.getPathSegments().get(1);
                rowId = Long.parseLong(segment);
                where = TextUtils.isEmpty((CharSequence)where) ? "_id=" + segment : "_id=" + segment + " AND (" + where + ")";
                count = db.delete("alarms", where, whereArgs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot delete from URL: " + url);
            }
        }
        this.getContext().getContentResolver().notifyChange(url, null);
        return count;
    }

    static {
        sURLMatcher.addURI("com.android.deskclock", "alarm", 1);
        sURLMatcher.addURI("com.android.deskclock", "alarm/#", 2);
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        public DatabaseHelper(Context context) {
            super(context, "alarms.db", null, 5);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE alarms (_id INTEGER PRIMARY KEY,hour INTEGER, minutes INTEGER, daysofweek INTEGER, alarmtime INTEGER, enabled INTEGER, vibrate INTEGER, message TEXT, alert TEXT);");
            String insertMe = "INSERT INTO alarms (hour, minutes, daysofweek, alarmtime, enabled, vibrate, message, alert) VALUES ";
            db.execSQL(insertMe + "(8, 30, 31, 0, 0, 1, '', '');");
            db.execSQL(insertMe + "(9, 00, 96, 0, 0, 1, '', '');");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int currentVersion) {
            db.execSQL("DROP TABLE IF EXISTS alarms");
            this.onCreate(db);
        }
    }
}

