/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.Vibrator;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.android.deskclock.Alarm;
import com.android.deskclock.AlarmAlertWakeLock;
import com.android.deskclock.Log;
import java.io.IOException;

public class AlarmKlaxon
extends Service {
    private static final long[] sVibratePattern = new long[]{500L, 500L};
    private boolean mPlaying = false;
    private Vibrator mVibrator;
    private MediaPlayer mMediaPlayer;
    private Alarm mCurrentAlarm;
    private long mStartTime;
    private TelephonyManager mTelephonyManager;
    private int mInitialCallState;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1000: {
                    AlarmKlaxon.this.sendKillBroadcast((Alarm)msg.obj);
                    AlarmKlaxon.this.stopSelf();
                }
            }
        }
    };
    private PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        public void onCallStateChanged(int state, String ignored) {
            if (state != 0 && state != AlarmKlaxon.this.mInitialCallState) {
                AlarmKlaxon.this.sendKillBroadcast(AlarmKlaxon.this.mCurrentAlarm);
                AlarmKlaxon.this.stopSelf();
            }
        }
    };

    public void onCreate() {
        this.mVibrator = (Vibrator)this.getSystemService("vibrator");
        this.mTelephonyManager = (TelephonyManager)this.getSystemService("phone");
        this.mTelephonyManager.listen(this.mPhoneStateListener, 32);
        AlarmAlertWakeLock.acquireCpuWakeLock((Context)this);
    }

    public void onDestroy() {
        this.stop();
        this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
        AlarmAlertWakeLock.releaseCpuLock();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            this.stopSelf();
            return 2;
        }
        Alarm alarm = (Alarm)intent.getParcelableExtra("intent.extra.alarm");
        if (alarm == null) {
            Log.v("AlarmKlaxon failed to parse the alarm from the intent");
            this.stopSelf();
            return 2;
        }
        if (this.mCurrentAlarm != null) {
            this.sendKillBroadcast(this.mCurrentAlarm);
        }
        this.play(alarm);
        this.mCurrentAlarm = alarm;
        this.mInitialCallState = this.mTelephonyManager.getCallState();
        return 1;
    }

    private void sendKillBroadcast(Alarm alarm) {
        long millis = System.currentTimeMillis() - this.mStartTime;
        int minutes = (int)Math.round((double)millis / 60000.0);
        Intent alarmKilled = new Intent("alarm_killed");
        alarmKilled.putExtra("intent.extra.alarm", (Parcelable)alarm);
        alarmKilled.putExtra("alarm_killed_timeout", minutes);
        this.sendBroadcast(alarmKilled);
    }

    private void play(Alarm alarm) {
        this.stop();
        if (!alarm.silent) {
            Uri alert = alarm.alert;
            if (alert == null) {
                alert = RingtoneManager.getDefaultUri((int)4);
            }
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(MediaPlayer mp, int what, int extra) {
                    Log.e("Error occurred while playing audio.");
                    mp.stop();
                    mp.release();
                    AlarmKlaxon.this.mMediaPlayer = null;
                    return true;
                }
            });
            try {
                if (this.mTelephonyManager.getCallState() != 0) {
                    Log.v("Using the in-call alarm");
                    this.mMediaPlayer.setVolume(0.125f, 0.125f);
                    this.setDataSourceFromResource(this.getResources(), this.mMediaPlayer, 2131099649);
                } else {
                    this.mMediaPlayer.setDataSource((Context)this, alert);
                }
                this.startAlarm(this.mMediaPlayer);
            }
            catch (Exception ex) {
                Log.v("Using the fallback ringtone");
                try {
                    this.mMediaPlayer.reset();
                    this.setDataSourceFromResource(this.getResources(), this.mMediaPlayer, 2131099648);
                    this.startAlarm(this.mMediaPlayer);
                }
                catch (Exception ex2) {
                    Log.e("Failed to play fallback ringtone", ex2);
                }
            }
        }
        if (alarm.vibrate) {
            this.mVibrator.vibrate(sVibratePattern, 0);
        } else {
            this.mVibrator.cancel();
        }
        this.enableKiller(alarm);
        this.mPlaying = true;
        this.mStartTime = System.currentTimeMillis();
    }

    private void startAlarm(MediaPlayer player) throws IOException, IllegalArgumentException, IllegalStateException {
        AudioManager audioManager = (AudioManager)this.getSystemService("audio");
        if (audioManager.getStreamVolume(4) != 0) {
            player.setAudioStreamType(4);
            player.setLooping(true);
            player.prepare();
            player.start();
        }
    }

    private void setDataSourceFromResource(Resources resources, MediaPlayer player, int res) throws IOException {
        AssetFileDescriptor afd = resources.openRawResourceFd(res);
        if (afd != null) {
            player.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            afd.close();
        }
    }

    public void stop() {
        if (this.mPlaying) {
            this.mPlaying = false;
            Intent alarmDone = new Intent("com.android.deskclock.ALARM_DONE");
            this.sendBroadcast(alarmDone);
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.stop();
                this.mMediaPlayer.release();
                this.mMediaPlayer = null;
            }
            this.mVibrator.cancel();
        }
        this.disableKiller();
    }

    private void enableKiller(Alarm alarm) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1000, (Object)alarm), 600000L);
    }

    private void disableKiller() {
        this.mHandler.removeMessages(1000);
    }
}

