/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.graphics.Typeface;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.CheckBox;
import android.widget.CursorAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.android.deskclock.Alarm;
import com.android.deskclock.Alarms;
import com.android.deskclock.DeskClock;
import com.android.deskclock.DigitalClock;
import com.android.deskclock.SetAlarm;
import com.android.deskclock.SettingsActivity;
import com.android.deskclock.ToastMaster;
import java.util.Calendar;

public class AlarmClock
extends Activity
implements AdapterView.OnItemClickListener {
    private SharedPreferences mPrefs;
    private LayoutInflater mFactory;
    private ListView mAlarmsList;
    private Cursor mCursor;

    private void updateIndicatorAndAlarm(boolean enabled, ImageView bar, Alarm alarm) {
        bar.setImageResource(enabled ? 2130837541 : 2130837540);
        Alarms.enableAlarm((Context)this, alarm.id, enabled);
        if (enabled) {
            SetAlarm.popAlarmSetToast((Context)this, alarm.hour, alarm.minutes, alarm.daysOfWeek);
        }
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        AdapterView.AdapterContextMenuInfo adapterContextMenuInfo = (AdapterView.AdapterContextMenuInfo)menuItem.getMenuInfo();
        final int n = (int)adapterContextMenuInfo.id;
        if (n == -1) {
            return super.onContextItemSelected(menuItem);
        }
        switch (menuItem.getItemId()) {
            case 2131492910: {
                new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(2131230726)).setMessage((CharSequence)this.getString(2131230729)).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface d, int w) {
                        Alarms.deleteAlarm((Context)AlarmClock.this, n);
                    }
                }).setNegativeButton(0x1040000, null).show();
                return true;
            }
            case 2131492908: {
                Cursor cursor = (Cursor)this.mAlarmsList.getAdapter().getItem(adapterContextMenuInfo.position);
                Alarm alarm = new Alarm(cursor);
                Alarms.enableAlarm((Context)this, alarm.id, !alarm.enabled);
                if (!alarm.enabled) {
                    SetAlarm.popAlarmSetToast((Context)this, alarm.hour, alarm.minutes, alarm.daysOfWeek);
                }
                return true;
            }
            case 2131492909: {
                Intent intent = new Intent((Context)this, SetAlarm.class);
                intent.putExtra("alarm_id", n);
                this.startActivity(intent);
                return true;
            }
        }
        return super.onContextItemSelected(menuItem);
    }

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mFactory = LayoutInflater.from((Context)this);
        this.mPrefs = this.getSharedPreferences("AlarmClock", 0);
        this.mCursor = Alarms.getAlarmsCursor(this.getContentResolver());
        this.updateLayout();
    }

    private void updateLayout() {
        this.setContentView(2130903041);
        this.mAlarmsList = (ListView)this.findViewById(2131492871);
        AlarmTimeAdapter adapter = new AlarmTimeAdapter((Context)this, this.mCursor);
        this.mAlarmsList.setAdapter((ListAdapter)adapter);
        this.mAlarmsList.setVerticalScrollBarEnabled(true);
        this.mAlarmsList.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mAlarmsList.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
        View addAlarm = this.findViewById(2131492870);
        addAlarm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlarmClock.this.addNewAlarm();
            }
        });
        addAlarm.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                v.setSelected(hasFocus);
            }
        });
        ImageButton deskClock = (ImageButton)this.findViewById(2131492872);
        deskClock.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AlarmClock.this.startActivity(new Intent((Context)AlarmClock.this, DeskClock.class));
            }
        });
    }

    private void addNewAlarm() {
        this.startActivity(new Intent((Context)this, SetAlarm.class));
    }

    protected void onDestroy() {
        super.onDestroy();
        ToastMaster.cancelToast();
        this.mCursor.close();
    }

    public void onCreateContextMenu(ContextMenu menu, View view, ContextMenu.ContextMenuInfo menuInfo) {
        this.getMenuInflater().inflate(2131427329, (Menu)menu);
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)menuInfo;
        Cursor c = (Cursor)this.mAlarmsList.getAdapter().getItem(info.position);
        Alarm alarm = new Alarm(c);
        Calendar cal = Calendar.getInstance();
        cal.set(11, alarm.hour);
        cal.set(12, alarm.minutes);
        String time = Alarms.formatTime((Context)this, cal);
        View v = this.mFactory.inflate(2130903044, null);
        TextView textView = (TextView)v.findViewById(2131492880);
        textView.setText((CharSequence)time);
        textView = (TextView)v.findViewById(2131492881);
        textView.setText((CharSequence)alarm.label);
        menu.setHeaderView(v);
        if (alarm.enabled) {
            menu.findItem(2131492908).setTitle(2131230728);
        }
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        switch (menuItem.getItemId()) {
            case 2131492907: {
                this.startActivity(new Intent((Context)this, SettingsActivity.class));
                return true;
            }
            case 2131492905: {
                this.startActivity(new Intent((Context)this, DeskClock.class));
                return true;
            }
            case 2131492906: {
                this.addNewAlarm();
                return true;
            }
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        this.getMenuInflater().inflate(2131427328, menu);
        return super.onCreateOptionsMenu(menu);
    }

    public void onItemClick(AdapterView adapterView, View view, int n, long l) {
        Intent intent = new Intent((Context)this, SetAlarm.class);
        intent.putExtra("alarm_id", (int)l);
        this.startActivity(intent);
    }

    private class AlarmTimeAdapter
    extends CursorAdapter {
        public AlarmTimeAdapter(Context context, Cursor cursor) {
            super(context, cursor);
        }

        public View newView(Context context, Cursor cursor, ViewGroup parent) {
            View ret = AlarmClock.this.mFactory.inflate(2130903042, parent, false);
            DigitalClock digitalClock = (DigitalClock)ret.findViewById(2131492876);
            digitalClock.setLive(false);
            return ret;
        }

        public void bindView(View view, Context context, Cursor cursor) {
            final Alarm alarm = new Alarm(cursor);
            View indicator = view.findViewById(2131492873);
            final ImageView barOnOff = (ImageView)indicator.findViewById(2131492875);
            barOnOff.setImageResource(alarm.enabled ? 2130837541 : 2130837540);
            final CheckBox clockOnOff = (CheckBox)indicator.findViewById(2131492874);
            clockOnOff.setChecked(alarm.enabled);
            indicator.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    clockOnOff.toggle();
                    AlarmClock.this.updateIndicatorAndAlarm(clockOnOff.isChecked(), barOnOff, alarm);
                }
            });
            DigitalClock digitalClock = (DigitalClock)view.findViewById(2131492876);
            Calendar c = Calendar.getInstance();
            c.set(11, alarm.hour);
            c.set(12, alarm.minutes);
            digitalClock.updateTime(c);
            digitalClock.setTypeface(Typeface.DEFAULT);
            TextView daysOfWeekView = (TextView)digitalClock.findViewById(2131492878);
            String daysOfWeekStr = alarm.daysOfWeek.toString((Context)AlarmClock.this, false);
            if (daysOfWeekStr != null && daysOfWeekStr.length() != 0) {
                daysOfWeekView.setText((CharSequence)daysOfWeekStr);
                daysOfWeekView.setVisibility(0);
            } else {
                daysOfWeekView.setVisibility(8);
            }
            TextView labelView = (TextView)view.findViewById(2131492877);
            if (alarm.label != null && alarm.label.length() != 0) {
                labelView.setText((CharSequence)alarm.label);
                labelView.setVisibility(0);
            } else {
                labelView.setVisibility(8);
            }
        }
    }
}

