/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import com.android.deskclock.Alarm;
import com.android.deskclock.AlarmReceiver;
import com.android.deskclock.Alarms;
import com.android.deskclock.Log;
import java.util.Calendar;

public class AlarmAlertFullScreen
extends Activity {
    protected Alarm mAlarm;
    private int mVolumeBehavior;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("com.android.deskclock.ALARM_SNOOZE")) {
                AlarmAlertFullScreen.this.snooze();
            } else if (action.equals("com.android.deskclock.ALARM_DISMISS")) {
                AlarmAlertFullScreen.this.dismiss(false);
            } else {
                Alarm alarm = (Alarm)intent.getParcelableExtra("intent.extra.alarm");
                if (alarm != null && AlarmAlertFullScreen.this.mAlarm.id == alarm.id) {
                    AlarmAlertFullScreen.this.dismiss(true);
                }
            }
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mAlarm = (Alarm)this.getIntent().getParcelableExtra("intent.extra.alarm");
        String vol = PreferenceManager.getDefaultSharedPreferences((Context)this).getString("volume_button_setting", "2");
        this.mVolumeBehavior = Integer.parseInt(vol);
        this.requestWindowFeature(1);
        Window win = this.getWindow();
        win.addFlags(0x480000);
        if (!this.getIntent().getBooleanExtra("screen_off", false)) {
            win.addFlags(2097281);
        }
        this.updateLayout();
        IntentFilter filter = new IntentFilter("alarm_killed");
        filter.addAction("com.android.deskclock.ALARM_SNOOZE");
        filter.addAction("com.android.deskclock.ALARM_DISMISS");
        this.registerReceiver(this.mReceiver, filter);
    }

    private void setTitle() {
        String label = this.mAlarm.getLabelOrDefault((Context)this);
        TextView title = (TextView)this.findViewById(2131492864);
        title.setText((CharSequence)label);
    }

    private void updateLayout() {
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        this.setContentView(inflater.inflate(2130903040, null));
        Button snooze = (Button)this.findViewById(2131492867);
        snooze.requestFocus();
        snooze.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlarmAlertFullScreen.this.snooze();
            }
        });
        this.findViewById(2131492868).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlarmAlertFullScreen.this.dismiss(false);
            }
        });
        this.setTitle();
    }

    private void snooze() {
        if (!this.findViewById(2131492867).isEnabled()) {
            this.dismiss(false);
            return;
        }
        String string = PreferenceManager.getDefaultSharedPreferences((Context)this).getString("snooze_duration", "10");
        int n = Integer.parseInt(string);
        long l = System.currentTimeMillis() + (long)(60000 * n);
        Alarms.saveSnoozeAlert((Context)this, this.mAlarm.id, l);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        String string2 = this.mAlarm.getLabelOrDefault((Context)this);
        string2 = this.getString(2131230765, new Object[]{string2});
        Intent intent = new Intent((Context)this, AlarmReceiver.class);
        intent.setAction("cancel_snooze");
        intent.putExtra("alarm_id", this.mAlarm.id);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this, (int)this.mAlarm.id, (Intent)intent, (int)0);
        NotificationManager notificationManager = this.getNotificationManager();
        Notification notification = new Notification(2130837556, (CharSequence)string2, 0L);
        notification.setLatestEventInfo((Context)this, (CharSequence)string2, (CharSequence)this.getString(2131230766, new Object[]{Alarms.formatTime((Context)this, calendar)}), pendingIntent);
        notification.flags |= 0x12;
        notificationManager.notify(this.mAlarm.id, notification);
        String string3 = this.getString(2131230742, new Object[]{n});
        Log.v(string3);
        Toast.makeText((Context)this, (CharSequence)string3, (int)1).show();
        this.stopService(new Intent("com.android.deskclock.ALARM_ALERT"));
        this.finish();
    }

    private NotificationManager getNotificationManager() {
        return (NotificationManager)this.getSystemService("notification");
    }

    private void dismiss(boolean killed) {
        Log.i(killed ? "Alarm killed" : "Alarm dismissed by user");
        if (!killed) {
            NotificationManager nm = this.getNotificationManager();
            nm.cancel(this.mAlarm.id);
            this.stopService(new Intent("com.android.deskclock.ALARM_ALERT"));
        }
        this.finish();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.mAlarm = (Alarm)intent.getParcelableExtra("intent.extra.alarm");
        this.setTitle();
    }

    protected void onResume() {
        super.onResume();
        if (Alarms.getAlarm(this.getContentResolver(), this.mAlarm.id) == null) {
            Button snooze = (Button)this.findViewById(2131492867);
            snooze.setEnabled(false);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.mReceiver);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean up = event.getAction() == 1;
        switch (event.getKeyCode()) {
            case 24: 
            case 25: 
            case 27: 
            case 80: {
                if (up) {
                    switch (this.mVolumeBehavior) {
                        case 1: {
                            this.snooze();
                            break;
                        }
                        case 2: {
                            this.dismiss(false);
                            break;
                        }
                    }
                }
                return true;
            }
        }
        return super.dispatchKeyEvent(event);
    }

    public void onBackPressed() {
    }
}

