/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import com.android.deskclock.AlarmAlertFullScreen;
import com.android.deskclock.Log;

public class AlarmAlert
extends AlarmAlertFullScreen {
    private int mKeyguardRetryCount;
    private final int MAX_KEYGUARD_CHECKS = 5;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            AlarmAlert.this.handleScreenOff((KeyguardManager)msg.obj);
        }
    };
    private final BroadcastReceiver mScreenOffReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            KeyguardManager km = (KeyguardManager)context.getSystemService("keyguard");
            AlarmAlert.this.handleScreenOff(km);
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.registerReceiver(this.mScreenOffReceiver, new IntentFilter("android.intent.action.SCREEN_OFF"));
    }

    public void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.mScreenOffReceiver);
        this.mHandler.removeMessages(0);
    }

    public void onBackPressed() {
        this.finish();
    }

    private boolean checkRetryCount() {
        if (this.mKeyguardRetryCount++ >= 5) {
            Log.e("Tried to read keyguard status too many times, bailing...");
            return false;
        }
        return true;
    }

    private void handleScreenOff(KeyguardManager keyguardManager) {
        if (!keyguardManager.inKeyguardRestrictedInputMode() && this.checkRetryCount()) {
            if (this.checkRetryCount()) {
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(0, (Object)keyguardManager), 500L);
            }
        } else {
            Intent intent = new Intent((Context)this, AlarmAlertFullScreen.class);
            intent.putExtra("intent.extra.alarm", (Parcelable)this.mAlarm);
            intent.putExtra("screen_off", true);
            this.startActivity(intent);
            this.finish();
        }
    }
}

