/*
 * Decompiled with CFR 0.152.
 */
package com.android.deskclock;

import android.content.Context;
import android.database.Cursor;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.BaseColumns;
import java.text.DateFormatSymbols;
import java.util.Calendar;

public final class Alarm
implements Parcelable {
    public static final Parcelable.Creator<Alarm> CREATOR = new Parcelable.Creator<Alarm>(){

        public Alarm createFromParcel(Parcel p) {
            return new Alarm(p);
        }

        public Alarm[] newArray(int size) {
            return new Alarm[size];
        }
    };
    public int id;
    public boolean enabled;
    public int hour;
    public int minutes;
    public DaysOfWeek daysOfWeek;
    public long time;
    public boolean vibrate;
    public String label;
    public Uri alert;
    public boolean silent;

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel p, int flags) {
        p.writeInt(this.id);
        p.writeInt(this.enabled ? 1 : 0);
        p.writeInt(this.hour);
        p.writeInt(this.minutes);
        p.writeInt(this.daysOfWeek.getCoded());
        p.writeLong(this.time);
        p.writeInt(this.vibrate ? 1 : 0);
        p.writeString(this.label);
        p.writeParcelable((Parcelable)this.alert, flags);
        p.writeInt(this.silent ? 1 : 0);
    }

    public Alarm(Cursor c) {
        this.id = c.getInt(0);
        this.enabled = c.getInt(5) == 1;
        this.hour = c.getInt(1);
        this.minutes = c.getInt(2);
        this.daysOfWeek = new DaysOfWeek(c.getInt(3));
        this.time = c.getLong(4);
        this.vibrate = c.getInt(6) == 1;
        this.label = c.getString(7);
        String alertString = c.getString(8);
        if ("silent".equals(alertString)) {
            this.silent = true;
        } else {
            if (alertString != null && alertString.length() != 0) {
                this.alert = Uri.parse((String)alertString);
            }
            if (this.alert == null) {
                this.alert = RingtoneManager.getDefaultUri((int)4);
            }
        }
    }

    public Alarm(Parcel p) {
        this.id = p.readInt();
        this.enabled = p.readInt() == 1;
        this.hour = p.readInt();
        this.minutes = p.readInt();
        this.daysOfWeek = new DaysOfWeek(p.readInt());
        this.time = p.readLong();
        this.vibrate = p.readInt() == 1;
        this.label = p.readString();
        this.alert = (Uri)p.readParcelable(null);
        this.silent = p.readInt() == 1;
    }

    public Alarm() {
        this.id = -1;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        this.hour = c.get(11);
        this.minutes = c.get(12);
        this.vibrate = true;
        this.daysOfWeek = new DaysOfWeek(0);
        this.alert = RingtoneManager.getDefaultUri((int)4);
    }

    public String getLabelOrDefault(Context context) {
        if (this.label == null || this.label.length() == 0) {
            return context.getString(2131230733);
        }
        return this.label;
    }

    static final class DaysOfWeek {
        private static int[] DAY_MAP = new int[]{2, 3, 4, 5, 6, 7, 1};
        private int mDays;

        DaysOfWeek(int days) {
            this.mDays = days;
        }

        public String toString(Context context, boolean showNever) {
            StringBuilder ret = new StringBuilder();
            if (this.mDays == 0) {
                return showNever ? ((Object)context.getText(2131230750)).toString() : "";
            }
            if (this.mDays == 127) {
                return ((Object)context.getText(2131230749)).toString();
            }
            int dayCount = 0;
            for (int days = this.mDays; days > 0; days >>= 1) {
                if ((days & 1) != 1) continue;
                ++dayCount;
            }
            DateFormatSymbols dfs = new DateFormatSymbols();
            String[] dayList = dayCount > 1 ? dfs.getShortWeekdays() : dfs.getWeekdays();
            for (int i = 0; i < 7; ++i) {
                if ((this.mDays & 1 << i) == 0) continue;
                ret.append(dayList[DAY_MAP[i]]);
                if (--dayCount <= 0) continue;
                ret.append(context.getText(2131230751));
            }
            return ret.toString();
        }

        private boolean isSet(int day) {
            return (this.mDays & 1 << day) > 0;
        }

        public void set(int day, boolean set) {
            this.mDays = set ? (this.mDays |= 1 << day) : (this.mDays &= ~(1 << day));
        }

        public void set(DaysOfWeek dow) {
            this.mDays = dow.mDays;
        }

        public int getCoded() {
            return this.mDays;
        }

        public boolean[] getBooleanArray() {
            boolean[] ret = new boolean[7];
            for (int i = 0; i < 7; ++i) {
                ret[i] = this.isSet(i);
            }
            return ret;
        }

        public boolean isRepeatSet() {
            return this.mDays != 0;
        }

        public int getNextAlarm(Calendar c) {
            int dayCount;
            if (this.mDays == 0) {
                return -1;
            }
            int today = (c.get(7) + 5) % 7;
            int day = 0;
            for (dayCount = 0; dayCount < 7 && !this.isSet(day = (today + dayCount) % 7); ++dayCount) {
            }
            return dayCount;
        }
    }

    public static class Columns
    implements BaseColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.android.deskclock/alarm");
        static final String[] ALARM_QUERY_COLUMNS = new String[]{"_id", "hour", "minutes", "daysofweek", "alarmtime", "enabled", "vibrate", "message", "alert"};
    }
}

