/*
 * Decompiled with CFR 0.152.
 */
package android.util.cts;

import android.content.res.XmlResourceParser;
import android.test.AndroidTestCase;
import android.util.AttributeSet;
import android.util.Xml;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

@TestTargetClass(value=Xml.class)
public class XmlTest
extends AndroidTestCase {
    private static final String STR_INVALIDATE_EN_CODING = "invalidateEnCoding";
    private static final String STR_N2 = "-2";
    private static final String STR_N1 = "-1";
    private static final String STR_LAYOUT_HEIGHT = "layout_height";
    private static final String STR_LAYOUT_WIDTH = "layout_width";
    private static final String STR_ISO_8859_1 = "ISO-8859-1";
    private static final String STR_US_ASCII = "US-ASCII";
    private static final String STR_UTF_16 = "UTF-16";
    private static final String STR_UTF_8 = "UTF-8";
    private static final String STR_END_DOCUMENT = "endDocument";
    private static final String STR_1_NUMBER = "1";
    private static final String STR_0_NUMBER = "0";
    private static final String STR_EMPTY = "";
    private static final String STR_END_ELEMENT = "endElement";
    private static final String STR_ABC = "abc";
    private static final String ATT_NAME = "name";
    private static final String TAG_SON = "Son";
    private static final String TAG_TEST = "Test";
    private static final String STR_START_ELEMENT = "startElement:";
    private static final String STR_START_DOCUMENT = "startDocument";
    private static final String STR_SET_DOCUMENT_LOCATOR = "setDocumentLocator:Locator[publicId: null, systemId: null, line: 1, column: 0]";
    private static final String STR_START_PREFIX_MAPPING_TAG = "startPrefixMapping:";
    private static final String STR_SKIPPED_ENTITY_TAG = "skippedEntity:";
    private static final String STR_SET_DOCUMENT_LOCATOR_TAG = "setDocumentLocator:";
    private static final String STR_PROCESSING_INSTRUCTION_TAG = "processingInstruction:";
    private static final String STR_IGNORABLE_WHITESPACE_TAG = "ignorableWhitespace:";
    private static final String STR_END_PREFIX_MAPPING_TAG = "endPrefixMapping:";
    private static final String STR_LENGTH_TAG = "length:";
    private static final String STR_START_TAG = "start:";
    private static final String STR_CHARACTERS_TAG = "characters:";
    final String sourceStr = "<Test><Son name=\"abc\"/></Test>";

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test constructor(s) of Xml.", method="Xml", args={})
    public void testConstructor() {
        new Xml();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test parse(String xml, ContentHandler contentHandler).", method="parse", args={String.class, ContentHandler.class})
    public void testParseStringContentHandler() {
        String xmlStr = "<Test><Son name=\"abc\"/></Test>";
        DefaultContentHandler dc = new DefaultContentHandler();
        try {
            Xml.parse((String)"<Test><Son name=\"abc\"/></Test>", (ContentHandler)dc);
            XmlTest.assertEquals((String)STR_SET_DOCUMENT_LOCATOR, (String)dc.mVec.elementAt(0));
            XmlTest.assertEquals((String)STR_START_DOCUMENT, (String)dc.mVec.elementAt(1));
            XmlTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(2));
            XmlTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(3));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(4));
            XmlTest.assertEquals((String)STR_0_NUMBER, (String)dc.mVec.elementAt(5));
            XmlTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(6));
            XmlTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(7));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(8));
            XmlTest.assertEquals((String)STR_1_NUMBER, (String)dc.mVec.elementAt(9));
            XmlTest.assertEquals((String)ATT_NAME, (String)dc.mVec.elementAt(10));
            XmlTest.assertEquals((String)STR_ABC, (String)dc.mVec.elementAt(11));
            XmlTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(12));
            XmlTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(13));
            XmlTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(14));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(15));
            XmlTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(16));
            XmlTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(17));
            XmlTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(18));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(19));
            XmlTest.assertEquals((String)STR_END_DOCUMENT, (String)dc.mVec.elementAt(20));
        }
        catch (SAXException e) {
            XmlTest.fail((String)e.getMessage());
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test parse(Reader in, ContentHandler contentHandler).", method="parse", args={Reader.class, ContentHandler.class})
    public void testParseReaderContentHander() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        for (int i = 0; i < "<Test><Son name=\"abc\"/></Test>".length(); ++i) {
            try {
                dout.write("<Test><Son name=\"abc\"/></Test>".charAt(i));
                continue;
            }
            catch (IOException e) {
                XmlTest.fail((String)e.getMessage());
            }
        }
        try {
            dout.flush();
        }
        catch (IOException e) {
            XmlTest.fail((String)e.getMessage());
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bout.toByteArray())));
        DefaultContentHandler dc = new DefaultContentHandler();
        try {
            Xml.parse((Reader)reader, (ContentHandler)dc);
            XmlTest.assertEquals((String)STR_SET_DOCUMENT_LOCATOR, (String)dc.mVec.elementAt(0));
            XmlTest.assertEquals((String)STR_START_DOCUMENT, (String)dc.mVec.elementAt(1));
            XmlTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(2));
            XmlTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(3));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(4));
            XmlTest.assertEquals((String)STR_0_NUMBER, (String)dc.mVec.elementAt(5));
            XmlTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(6));
            XmlTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(7));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(8));
            XmlTest.assertEquals((String)STR_1_NUMBER, (String)dc.mVec.elementAt(9));
            XmlTest.assertEquals((String)ATT_NAME, (String)dc.mVec.elementAt(10));
            XmlTest.assertEquals((String)STR_ABC, (String)dc.mVec.elementAt(11));
            XmlTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(12));
            XmlTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(13));
            XmlTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(14));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(15));
            XmlTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(16));
            XmlTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(17));
            XmlTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(18));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(19));
            XmlTest.assertEquals((String)STR_END_DOCUMENT, (String)dc.mVec.elementAt(20));
        }
        catch (SAXException e) {
            XmlTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            XmlTest.fail((String)e.getMessage());
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test parse(InputStream in, Encoding encoding, ContentHandler contentHandler).", method="parse", args={InputStream.class, Xml.Encoding.class, ContentHandler.class})
    public void testParseInputStreamEncodingContentHandler() {
        DefaultContentHandler dc = new DefaultContentHandler();
        try {
            Xml.parse((InputStream)new ByteArrayInputStream("<Test><Son name=\"abc\"/></Test>".getBytes(STR_US_ASCII)), (Xml.Encoding)Xml.Encoding.US_ASCII, (ContentHandler)dc);
            XmlTest.assertEquals((String)STR_SET_DOCUMENT_LOCATOR, (String)dc.mVec.elementAt(0));
            XmlTest.assertEquals((String)STR_START_DOCUMENT, (String)dc.mVec.elementAt(1));
            XmlTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(2));
            XmlTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(3));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(4));
            XmlTest.assertEquals((String)STR_0_NUMBER, (String)dc.mVec.elementAt(5));
            XmlTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(6));
            XmlTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(7));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(8));
            XmlTest.assertEquals((String)STR_1_NUMBER, (String)dc.mVec.elementAt(9));
            XmlTest.assertEquals((String)ATT_NAME, (String)dc.mVec.elementAt(10));
            XmlTest.assertEquals((String)STR_ABC, (String)dc.mVec.elementAt(11));
            XmlTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(12));
            XmlTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(13));
            XmlTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(14));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(15));
            XmlTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(16));
            XmlTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(17));
            XmlTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(18));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(19));
            XmlTest.assertEquals((String)STR_END_DOCUMENT, (String)dc.mVec.elementAt(20));
        }
        catch (SAXException e) {
            XmlTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            XmlTest.fail((String)e.getMessage());
        }
        dc = new DefaultContentHandler();
        try {
            Xml.parse((InputStream)new ByteArrayInputStream("<Test><Son name=\"abc\"/></Test>".getBytes(STR_UTF_8)), (Xml.Encoding)Xml.Encoding.UTF_8, (ContentHandler)dc);
            XmlTest.assertEquals((String)STR_SET_DOCUMENT_LOCATOR, (String)dc.mVec.elementAt(0));
            XmlTest.assertEquals((String)STR_START_DOCUMENT, (String)dc.mVec.elementAt(1));
            XmlTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(2));
            XmlTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(3));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(4));
            XmlTest.assertEquals((String)STR_0_NUMBER, (String)dc.mVec.elementAt(5));
            XmlTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(6));
            XmlTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(7));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(8));
            XmlTest.assertEquals((String)STR_1_NUMBER, (String)dc.mVec.elementAt(9));
            XmlTest.assertEquals((String)ATT_NAME, (String)dc.mVec.elementAt(10));
            XmlTest.assertEquals((String)STR_ABC, (String)dc.mVec.elementAt(11));
            XmlTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(12));
            XmlTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(13));
            XmlTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(14));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(15));
            XmlTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(16));
            XmlTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(17));
            XmlTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(18));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(19));
            XmlTest.assertEquals((String)STR_END_DOCUMENT, (String)dc.mVec.elementAt(20));
        }
        catch (SAXException e) {
            XmlTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            XmlTest.fail((String)e.getMessage());
        }
        dc = new DefaultContentHandler();
        try {
            Xml.parse((InputStream)new ByteArrayInputStream("<Test><Son name=\"abc\"/></Test>".getBytes(STR_UTF_16)), (Xml.Encoding)Xml.Encoding.UTF_16, (ContentHandler)dc);
            XmlTest.assertEquals((String)STR_SET_DOCUMENT_LOCATOR, (String)dc.mVec.elementAt(0));
            XmlTest.assertEquals((String)STR_START_DOCUMENT, (String)dc.mVec.elementAt(1));
            XmlTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(2));
            XmlTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(3));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(4));
            XmlTest.assertEquals((String)STR_0_NUMBER, (String)dc.mVec.elementAt(5));
            XmlTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(6));
            XmlTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(7));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(8));
            XmlTest.assertEquals((String)STR_1_NUMBER, (String)dc.mVec.elementAt(9));
            XmlTest.assertEquals((String)ATT_NAME, (String)dc.mVec.elementAt(10));
            XmlTest.assertEquals((String)STR_ABC, (String)dc.mVec.elementAt(11));
            XmlTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(12));
            XmlTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(13));
            XmlTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(14));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(15));
            XmlTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(16));
            XmlTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(17));
            XmlTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(18));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(19));
            XmlTest.assertEquals((String)STR_END_DOCUMENT, (String)dc.mVec.elementAt(20));
        }
        catch (SAXException e) {
            XmlTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            XmlTest.fail((String)e.getMessage());
        }
        dc = new DefaultContentHandler();
        try {
            Xml.parse((InputStream)new ByteArrayInputStream("<Test><Son name=\"abc\"/></Test>".getBytes(STR_ISO_8859_1)), (Xml.Encoding)Xml.Encoding.ISO_8859_1, (ContentHandler)dc);
            XmlTest.assertEquals((String)STR_SET_DOCUMENT_LOCATOR, (String)dc.mVec.elementAt(0));
            XmlTest.assertEquals((String)STR_START_DOCUMENT, (String)dc.mVec.elementAt(1));
            XmlTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(2));
            XmlTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(3));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(4));
            XmlTest.assertEquals((String)STR_0_NUMBER, (String)dc.mVec.elementAt(5));
            XmlTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(6));
            XmlTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(7));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(8));
            XmlTest.assertEquals((String)STR_1_NUMBER, (String)dc.mVec.elementAt(9));
            XmlTest.assertEquals((String)ATT_NAME, (String)dc.mVec.elementAt(10));
            XmlTest.assertEquals((String)STR_ABC, (String)dc.mVec.elementAt(11));
            XmlTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(12));
            XmlTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(13));
            XmlTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(14));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(15));
            XmlTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(16));
            XmlTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(17));
            XmlTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(18));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(19));
            XmlTest.assertEquals((String)STR_END_DOCUMENT, (String)dc.mVec.elementAt(20));
        }
        catch (SAXException e) {
            XmlTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            XmlTest.fail((String)e.getMessage());
        }
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test newSerializer() and newPullParser().", method="newSerializer", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test newSerializer() and newPullParser().", method="newPullParser", args={})})
    public void testNewSerializer() {
        XmlSerializer xs = Xml.newSerializer();
        XmlTest.assertNotNull((Object)xs);
        XmlPullParser xp = Xml.newPullParser();
        XmlTest.assertNotNull((Object)xp);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test findEncodingByName(String encodingName).", method="findEncodingByName", args={String.class})
    public void testFindEncodingByName() {
        try {
            XmlTest.assertEquals((Object)Xml.Encoding.UTF_8, (Object)Xml.findEncodingByName((String)STR_UTF_8));
            XmlTest.assertEquals((Object)Xml.Encoding.UTF_16, (Object)Xml.findEncodingByName((String)STR_UTF_16));
            XmlTest.assertEquals((Object)Xml.Encoding.US_ASCII, (Object)Xml.findEncodingByName((String)STR_US_ASCII));
            XmlTest.assertEquals((Object)Xml.Encoding.ISO_8859_1, (Object)Xml.findEncodingByName((String)STR_ISO_8859_1));
        }
        catch (UnsupportedEncodingException e) {
            XmlTest.fail((String)e.getMessage());
        }
        try {
            Xml.findEncodingByName((String)STR_INVALIDATE_EN_CODING);
            XmlTest.fail((String)"should throw out exception");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test asAttributeSet(XmlPullParser parser).", method="asAttributeSet", args={XmlPullParser.class})
    public void testAsAttributeSet() {
        XmlResourceParser xp = this.getContext().getResources().getLayout(2130903145);
        int eventType = -1;
        try {
            eventType = xp.getEventType();
        }
        catch (XmlPullParserException e) {
            XmlTest.fail((String)e.getMessage());
        }
        while (eventType != 2 && eventType != 1) {
            try {
                eventType = xp.next();
            }
            catch (XmlPullParserException e) {
                XmlTest.fail((String)e.getMessage());
            }
            catch (IOException e) {
                XmlTest.fail((String)e.getMessage());
            }
        }
        if (eventType == 2) {
            AttributeSet set = Xml.asAttributeSet((XmlPullParser)xp);
            XmlTest.assertEquals((int)2, (int)set.getAttributeCount());
            XmlTest.assertEquals((String)STR_LAYOUT_WIDTH, (String)set.getAttributeName(0));
            XmlTest.assertEquals((String)STR_N1, (String)set.getAttributeValue(0));
            XmlTest.assertEquals((String)STR_LAYOUT_HEIGHT, (String)set.getAttributeName(1));
            XmlTest.assertEquals((String)STR_N2, (String)set.getAttributeValue(1));
        } else {
            XmlTest.fail((String)"XML parser didn't find the start element of the specified xml file.");
        }
    }

    private void assertEqualsOrEmpty(String expected, String actual) {
        if (actual.length() != 0) {
            XmlTest.assertEquals((String)expected, (String)actual);
        }
    }

    class DefaultContentHandler
    implements ContentHandler {
        public Vector<String> mVec = new Vector();

        DefaultContentHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.mVec.add(XmlTest.STR_CHARACTERS_TAG + new String(ch));
            this.mVec.add(XmlTest.STR_START_TAG + start);
            this.mVec.add(XmlTest.STR_LENGTH_TAG + length);
        }

        public void endDocument() throws SAXException {
            this.mVec.add(XmlTest.STR_END_DOCUMENT);
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            this.mVec.add(XmlTest.STR_END_ELEMENT);
            this.mVec.add(uri);
            this.mVec.add(localName);
            this.mVec.add(name);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.mVec.add(XmlTest.STR_END_PREFIX_MAPPING_TAG + prefix);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.mVec.add(XmlTest.STR_IGNORABLE_WHITESPACE_TAG + new String(ch));
            this.mVec.add(XmlTest.STR_START_TAG + start);
            this.mVec.add(XmlTest.STR_LENGTH_TAG + length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.mVec.add(XmlTest.STR_PROCESSING_INSTRUCTION_TAG + target);
            this.mVec.add(data);
        }

        public void setDocumentLocator(Locator locator) {
            this.mVec.add(XmlTest.STR_SET_DOCUMENT_LOCATOR_TAG + locator);
        }

        public void skippedEntity(String name) throws SAXException {
            this.mVec.add(XmlTest.STR_SKIPPED_ENTITY_TAG + name);
        }

        public void startDocument() throws SAXException {
            this.mVec.add(XmlTest.STR_START_DOCUMENT);
        }

        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            this.mVec.add(XmlTest.STR_START_ELEMENT + uri);
            this.mVec.add(localName);
            this.mVec.add(name);
            this.mVec.add(atts.getLength() + XmlTest.STR_EMPTY);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.mVec.add(atts.getLocalName(i));
                this.mVec.add(atts.getValue(i));
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.mVec.add(XmlTest.STR_START_PREFIX_MAPPING_TAG + prefix);
            this.mVec.add(uri);
        }
    }
}

