/*
 * Decompiled with CFR 0.152.
 */
package android.util.cts;

import android.util.Xml;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import junit.framework.TestCase;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

@TestTargetClass(value=Xml.Encoding.class)
public class XmlEncodingTest
extends TestCase {
    private static final String STR_ISO_8859_1 = "ISO-8859-1";
    private static final String STR_US_ASCII = "US-ASCII";
    private static final String STR_UTF_16 = "UTF-16";
    private static final String STR_UTF_8 = "UTF-8";
    private static final String STR_END_DOCUMENT = "endDocument";
    private static final String STR_1_NUMBER = "1";
    private static final String STR_0_NUMBER = "0";
    private static final String STR_EMPTY = "";
    private static final String STR_END_ELEMENT = "endElement";
    private static final String STR_ABC = "abc";
    private static final String ATT_NAME = "name";
    private static final String TAG_SON = "Son";
    private static final String TAG_TEST = "Test";
    private static final String STR_START_ELEMENT = "startElement:";
    private static final String STR_START_DOCUMENT = "startDocument";
    private static final String STR_SET_DOCUMENT_LOCATOR = "setDocumentLocator:Locator[publicId: null, systemId: null, line: 1, column: 0]";
    final String sourceStr = "<Test><Son name=\"abc\"/></Test>";
    private static final String STR_START_PREFIX_MAPPING_TAG = "startPrefixMapping:";
    private static final String STR_SKIPPED_ENTITY_TAG = "skippedEntity:";
    private static final String STR_SET_DOCUMENT_LOCATOR_TAG = "setDocumentLocator:";
    private static final String STR_PROCESSING_INSTRUCTION_TAG = "processingInstruction:";
    private static final String STR_IGNORABLE_WHITESPACE_TAG = "ignorableWhitespace:";
    private static final String STR_END_PREFIX_MAPPING_TAG = "endPrefixMapping:";
    private static final String STR_LENGTH_TAG = "length:";
    private static final String STR_START_TAG = "start:";
    private static final String STR_CHARACTERS_TAG = "characters:";

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test valueOf(String name).", method="valueOf", args={String.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test valueOf(String name).", method="values", args={})})
    public void testValueOf() {
        DefaultContentHandler dc = new DefaultContentHandler();
        try {
            Xml.parse((InputStream)new ByteArrayInputStream("<Test><Son name=\"abc\"/></Test>".getBytes(STR_US_ASCII)), (Xml.Encoding)Xml.Encoding.US_ASCII, (ContentHandler)dc);
            XmlEncodingTest.assertEquals((String)STR_SET_DOCUMENT_LOCATOR, (String)dc.mVec.elementAt(0));
            XmlEncodingTest.assertEquals((String)STR_START_DOCUMENT, (String)dc.mVec.elementAt(1));
            XmlEncodingTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(2));
            XmlEncodingTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(3));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(4));
            XmlEncodingTest.assertEquals((String)STR_0_NUMBER, (String)dc.mVec.elementAt(5));
            XmlEncodingTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(6));
            XmlEncodingTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(7));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(8));
            XmlEncodingTest.assertEquals((String)STR_1_NUMBER, (String)dc.mVec.elementAt(9));
            XmlEncodingTest.assertEquals((String)ATT_NAME, (String)dc.mVec.elementAt(10));
            XmlEncodingTest.assertEquals((String)STR_ABC, (String)dc.mVec.elementAt(11));
            XmlEncodingTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(12));
            XmlEncodingTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(13));
            XmlEncodingTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(14));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(15));
            XmlEncodingTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(16));
            XmlEncodingTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(17));
            XmlEncodingTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(18));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(19));
            XmlEncodingTest.assertEquals((String)STR_END_DOCUMENT, (String)dc.mVec.elementAt(20));
        }
        catch (SAXException e) {
            XmlEncodingTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            XmlEncodingTest.fail((String)e.getMessage());
        }
        dc = new DefaultContentHandler();
        try {
            Xml.parse((InputStream)new ByteArrayInputStream("<Test><Son name=\"abc\"/></Test>".getBytes(STR_UTF_8)), (Xml.Encoding)Xml.Encoding.UTF_8, (ContentHandler)dc);
            XmlEncodingTest.assertEquals((String)STR_SET_DOCUMENT_LOCATOR, (String)dc.mVec.elementAt(0));
            XmlEncodingTest.assertEquals((String)STR_START_DOCUMENT, (String)dc.mVec.elementAt(1));
            XmlEncodingTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(2));
            XmlEncodingTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(3));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(4));
            XmlEncodingTest.assertEquals((String)STR_0_NUMBER, (String)dc.mVec.elementAt(5));
            XmlEncodingTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(6));
            XmlEncodingTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(7));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(8));
            XmlEncodingTest.assertEquals((String)STR_1_NUMBER, (String)dc.mVec.elementAt(9));
            XmlEncodingTest.assertEquals((String)ATT_NAME, (String)dc.mVec.elementAt(10));
            XmlEncodingTest.assertEquals((String)STR_ABC, (String)dc.mVec.elementAt(11));
            XmlEncodingTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(12));
            XmlEncodingTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(13));
            XmlEncodingTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(14));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(15));
            XmlEncodingTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(16));
            XmlEncodingTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(17));
            XmlEncodingTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(18));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(19));
            XmlEncodingTest.assertEquals((String)STR_END_DOCUMENT, (String)dc.mVec.elementAt(20));
        }
        catch (SAXException e) {
            XmlEncodingTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            XmlEncodingTest.fail((String)e.getMessage());
        }
        dc = new DefaultContentHandler();
        try {
            Xml.parse((InputStream)new ByteArrayInputStream("<Test><Son name=\"abc\"/></Test>".getBytes(STR_UTF_16)), (Xml.Encoding)Xml.Encoding.UTF_16, (ContentHandler)dc);
            XmlEncodingTest.assertEquals((String)STR_SET_DOCUMENT_LOCATOR, (String)dc.mVec.elementAt(0));
            XmlEncodingTest.assertEquals((String)STR_START_DOCUMENT, (String)dc.mVec.elementAt(1));
            XmlEncodingTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(2));
            XmlEncodingTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(3));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(4));
            XmlEncodingTest.assertEquals((String)STR_0_NUMBER, (String)dc.mVec.elementAt(5));
            XmlEncodingTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(6));
            XmlEncodingTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(7));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(8));
            XmlEncodingTest.assertEquals((String)STR_1_NUMBER, (String)dc.mVec.elementAt(9));
            XmlEncodingTest.assertEquals((String)ATT_NAME, (String)dc.mVec.elementAt(10));
            XmlEncodingTest.assertEquals((String)STR_ABC, (String)dc.mVec.elementAt(11));
            XmlEncodingTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(12));
            XmlEncodingTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(13));
            XmlEncodingTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(14));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(15));
            XmlEncodingTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(16));
            XmlEncodingTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(17));
            XmlEncodingTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(18));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(19));
            XmlEncodingTest.assertEquals((String)STR_END_DOCUMENT, (String)dc.mVec.elementAt(20));
        }
        catch (SAXException e) {
            XmlEncodingTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            XmlEncodingTest.fail((String)e.getMessage());
        }
        dc = new DefaultContentHandler();
        try {
            Xml.parse((InputStream)new ByteArrayInputStream("<Test><Son name=\"abc\"/></Test>".getBytes(STR_ISO_8859_1)), (Xml.Encoding)Xml.Encoding.ISO_8859_1, (ContentHandler)dc);
            XmlEncodingTest.assertEquals((String)STR_SET_DOCUMENT_LOCATOR, (String)dc.mVec.elementAt(0));
            XmlEncodingTest.assertEquals((String)STR_START_DOCUMENT, (String)dc.mVec.elementAt(1));
            XmlEncodingTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(2));
            XmlEncodingTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(3));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(4));
            XmlEncodingTest.assertEquals((String)STR_0_NUMBER, (String)dc.mVec.elementAt(5));
            XmlEncodingTest.assertEquals((String)STR_START_ELEMENT, (String)dc.mVec.elementAt(6));
            XmlEncodingTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(7));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(8));
            XmlEncodingTest.assertEquals((String)STR_1_NUMBER, (String)dc.mVec.elementAt(9));
            XmlEncodingTest.assertEquals((String)ATT_NAME, (String)dc.mVec.elementAt(10));
            XmlEncodingTest.assertEquals((String)STR_ABC, (String)dc.mVec.elementAt(11));
            XmlEncodingTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(12));
            XmlEncodingTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(13));
            XmlEncodingTest.assertEquals((String)TAG_SON, (String)dc.mVec.elementAt(14));
            this.assertEqualsOrEmpty(TAG_SON, dc.mVec.elementAt(15));
            XmlEncodingTest.assertEquals((String)STR_END_ELEMENT, (String)dc.mVec.elementAt(16));
            XmlEncodingTest.assertEquals((String)STR_EMPTY, (String)dc.mVec.elementAt(17));
            XmlEncodingTest.assertEquals((String)TAG_TEST, (String)dc.mVec.elementAt(18));
            this.assertEqualsOrEmpty(TAG_TEST, dc.mVec.elementAt(19));
            XmlEncodingTest.assertEquals((String)STR_END_DOCUMENT, (String)dc.mVec.elementAt(20));
        }
        catch (SAXException e) {
            XmlEncodingTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            XmlEncodingTest.fail((String)e.getMessage());
        }
    }

    private void assertEqualsOrEmpty(String expected, String actual) {
        if (actual.length() != 0) {
            XmlEncodingTest.assertEquals((String)expected, (String)actual);
        }
    }

    class DefaultContentHandler
    implements ContentHandler {
        public Vector<String> mVec = new Vector();

        DefaultContentHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.mVec.add(XmlEncodingTest.STR_CHARACTERS_TAG + new String(ch));
            this.mVec.add(XmlEncodingTest.STR_START_TAG + start);
            this.mVec.add(XmlEncodingTest.STR_LENGTH_TAG + length);
        }

        public void endDocument() throws SAXException {
            this.mVec.add(XmlEncodingTest.STR_END_DOCUMENT);
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            this.mVec.add(XmlEncodingTest.STR_END_ELEMENT);
            this.mVec.add(uri);
            this.mVec.add(localName);
            this.mVec.add(name);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.mVec.add(XmlEncodingTest.STR_END_PREFIX_MAPPING_TAG + prefix);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.mVec.add(XmlEncodingTest.STR_IGNORABLE_WHITESPACE_TAG + new String(ch));
            this.mVec.add(XmlEncodingTest.STR_START_TAG + start);
            this.mVec.add(XmlEncodingTest.STR_LENGTH_TAG + length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.mVec.add(XmlEncodingTest.STR_PROCESSING_INSTRUCTION_TAG + target);
            this.mVec.add(data);
        }

        public void setDocumentLocator(Locator locator) {
            this.mVec.add(XmlEncodingTest.STR_SET_DOCUMENT_LOCATOR_TAG + locator);
        }

        public void skippedEntity(String name) throws SAXException {
            this.mVec.add(XmlEncodingTest.STR_SKIPPED_ENTITY_TAG + name);
        }

        public void startDocument() throws SAXException {
            this.mVec.add(XmlEncodingTest.STR_START_DOCUMENT);
        }

        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            this.mVec.add(XmlEncodingTest.STR_START_ELEMENT + uri);
            this.mVec.add(localName);
            this.mVec.add(name);
            this.mVec.add(atts.getLength() + XmlEncodingTest.STR_EMPTY);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.mVec.add(atts.getLocalName(i));
                this.mVec.add(atts.getValue(i));
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.mVec.add(XmlEncodingTest.STR_START_PREFIX_MAPPING_TAG + prefix);
            this.mVec.add(uri);
        }
    }
}

