/*
 * Decompiled with CFR 0.152.
 */
package android.util.cts;

import android.util.DisplayMetrics;
import android.util.TypedValue;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import junit.framework.TestCase;

@TestTargetClass(value=TypedValue.class)
public class TypedValueTest
extends TestCase {
    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test constructor(s) of {@link TypedValue}", method="TypedValue", args={})
    public void testConstructor() {
        new TypedValue();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getFloat().", method="getFloat", args={})
    public void testGetFloat() {
        float EXPECTED = Float.intBitsToFloat(99);
        TypedValue tv = new TypedValue();
        tv.data = 99;
        TypedValueTest.assertEquals((Object)Float.valueOf(EXPECTED), (Object)Float.valueOf(tv.getFloat()));
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test complexToDimension().", method="complexToDimension", args={int.class, DisplayMetrics.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test complexToDimensionPixelOffset().", method="complexToDimensionPixelOffset", args={int.class, DisplayMetrics.class})})
    public void testComplexToDimension() {
        DisplayMetrics dm = new DisplayMetrics();
        dm.density = 1.1f;
        dm.heightPixels = 100;
        dm.scaledDensity = 2.1f;
        dm.xdpi = 200.0f;
        dm.ydpi = 300.0f;
        float EXPECTED = TypedValue.applyDimension((int)10, (float)TypedValue.complexToFloat((int)10), (DisplayMetrics)dm);
        TypedValueTest.assertEquals((Object)Float.valueOf(EXPECTED), (Object)Float.valueOf(TypedValue.complexToDimension((int)10, (DisplayMetrics)dm)));
        TypedValueTest.assertEquals((int)((int)EXPECTED), (int)TypedValue.complexToDimensionPixelOffset((int)10, (DisplayMetrics)dm));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test setTo().", method="setTo", args={TypedValue.class})
    public void testSetTo() {
        TypedValue tv1 = new TypedValue();
        TypedValue tv2 = new TypedValue();
        tv1.assetCookie = 1;
        tv1.changingConfigurations = 2;
        tv1.data = 3;
        tv1.resourceId = 4;
        tv1.string = "test";
        tv1.type = 5;
        tv2.setTo(tv1);
        TypedValueTest.assertEquals((int)1, (int)tv2.assetCookie);
        TypedValueTest.assertEquals((int)-1, (int)tv2.changingConfigurations);
        TypedValueTest.assertEquals((int)3, (int)tv2.data);
        TypedValueTest.assertEquals((int)4, (int)tv2.resourceId);
        TypedValueTest.assertEquals((Object)"test", (Object)tv2.string);
        TypedValueTest.assertEquals((int)5, (int)tv2.type);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getFraction().", method="getFraction", args={float.class, float.class})
    public void testGetFraction() {
        float EXPECTED = TypedValue.complexToFraction((int)10, (float)1.1f, (float)2.1f);
        TypedValue tv = new TypedValue();
        tv.data = 10;
        TypedValueTest.assertEquals((Object)Float.valueOf(EXPECTED), (Object)Float.valueOf(tv.getFraction(1.1f, 2.1f)));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test complexToDimensionPixelSize().", method="complexToDimensionPixelSize", args={int.class, DisplayMetrics.class})
    public void testComplexToDimensionPixelSize() {
        DisplayMetrics dm = new DisplayMetrics();
        dm.density = 1.1f;
        dm.heightPixels = 100;
        dm.scaledDensity = 2.1f;
        dm.xdpi = 200.0f;
        dm.ydpi = 300.0f;
        TypedValueTest.assertEquals((int)1, (int)TypedValue.complexToDimensionPixelSize((int)1000, (DisplayMetrics)dm));
        TypedValueTest.assertEquals((int)1, (int)TypedValue.complexToDimensionPixelSize((int)9999, (DisplayMetrics)dm));
        TypedValueTest.assertEquals((int)1, (int)TypedValue.complexToDimensionPixelSize((int)5000, (DisplayMetrics)dm));
        TypedValueTest.assertEquals((int)102, (int)TypedValue.complexToDimensionPixelSize((int)3333, (DisplayMetrics)dm));
        TypedValueTest.assertEquals((int)1, (int)TypedValue.complexToDimensionPixelSize((int)2222, (DisplayMetrics)dm));
        TypedValueTest.assertEquals((int)1, (int)TypedValue.complexToDimensionPixelSize((int)1500, (DisplayMetrics)dm));
        TypedValueTest.assertEquals((int)0, (int)TypedValue.complexToDimensionPixelSize((int)10, (DisplayMetrics)dm));
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test complexToFraction().", method="complexToFraction", args={int.class, float.class, float.class})})
    public void testComplexToFraction() {
        boolean data1 = true;
        float base1 = 1.1f;
        float pbase1 = 2.2f;
        float expected1 = 0.0f;
        int data2 = 100000;
        float base2 = 1.1f;
        float pbase2 = 2.2f;
        float expected2 = 0.013092041f;
        TypedValueTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(TypedValue.complexToFraction((int)1, (float)1.1f, (float)2.2f)));
        TypedValueTest.assertEquals((Object)Float.valueOf(0.013092041f), (Object)Float.valueOf(TypedValue.complexToFraction((int)100000, (float)1.1f, (float)2.2f)));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test toString().", method="toString", args={})
    public void testToString() {
        TypedValue tv = new TypedValue();
        tv.assetCookie = 1;
        tv.changingConfigurations = 2;
        tv.data = 3;
        tv.resourceId = 4;
        tv.string = "test";
        tv.type = 5;
        TypedValueTest.assertNotNull((Object)tv.toString());
        tv.type = 3;
        TypedValueTest.assertNotNull((Object)tv.toString());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test applyDimension().", method="applyDimension", args={int.class, float.class, DisplayMetrics.class})
    public void testApplyDimension() {
        DisplayMetrics dm = new DisplayMetrics();
        dm.density = 1.1f;
        dm.heightPixels = 100;
        dm.scaledDensity = 2.1f;
        dm.xdpi = 200.0f;
        dm.ydpi = 300.0f;
        TypedValueTest.assertEquals((Object)Float.valueOf(10.0f), (Object)Float.valueOf(TypedValue.applyDimension((int)0, (float)10.0f, (DisplayMetrics)dm)));
        TypedValueTest.assertEquals((Object)Float.valueOf(10.0f * dm.density), (Object)Float.valueOf(TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)dm)));
        TypedValueTest.assertEquals((Object)Float.valueOf(10.0f * dm.scaledDensity), (Object)Float.valueOf(TypedValue.applyDimension((int)2, (float)10.0f, (DisplayMetrics)dm)));
        TypedValueTest.assertEquals((Object)Float.valueOf(10.0f * dm.xdpi * 0.013888889f), (Object)Float.valueOf(TypedValue.applyDimension((int)3, (float)10.0f, (DisplayMetrics)dm)));
        TypedValueTest.assertEquals((Object)Float.valueOf(10.0f * dm.xdpi), (Object)Float.valueOf(TypedValue.applyDimension((int)4, (float)10.0f, (DisplayMetrics)dm)));
        TypedValueTest.assertEquals((Object)Float.valueOf(10.0f * dm.xdpi * 0.03937008f), (Object)Float.valueOf(TypedValue.applyDimension((int)5, (float)10.0f, (DisplayMetrics)dm)));
        TypedValueTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(TypedValue.applyDimension((int)-1, (float)10.0f, (DisplayMetrics)dm)));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test coerceToString().", method="coerceToString", args={})
    public void testCoerceToString1() {
        TypedValue tv = new TypedValue();
        tv.assetCookie = 1;
        tv.changingConfigurations = 2;
        tv.data = 3;
        tv.resourceId = 4;
        tv.string = "test";
        tv.type = 5;
        TypedValueTest.assertNotNull((Object)tv.coerceToString());
        tv.type = 3;
        TypedValueTest.assertNotNull((Object)tv.coerceToString());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test coerceToString().", method="coerceToString", args={int.class, int.class})
    public void testCoerceToString2() {
        TypedValueTest.assertNull((Object)TypedValue.coerceToString((int)0, (int)10));
        TypedValueTest.assertNotNull((Object)TypedValue.coerceToString((int)1, (int)10));
        TypedValueTest.assertNotNull((Object)TypedValue.coerceToString((int)2, (int)10));
        TypedValueTest.assertNotNull((Object)TypedValue.coerceToString((int)4, (int)10));
        TypedValueTest.assertNotNull((Object)TypedValue.coerceToString((int)5, (int)2));
        TypedValueTest.assertNotNull((Object)TypedValue.coerceToString((int)6, (int)1));
        TypedValueTest.assertNotNull((Object)TypedValue.coerceToString((int)17, (int)10));
        TypedValueTest.assertNotNull((Object)TypedValue.coerceToString((int)18, (int)1));
        TypedValueTest.assertNotNull((Object)TypedValue.coerceToString((int)18, (int)0));
        TypedValueTest.assertNotNull((Object)TypedValue.coerceToString((int)28, (int)10));
        TypedValueTest.assertNotNull((Object)TypedValue.coerceToString((int)17, (int)10));
        TypedValueTest.assertNull((Object)TypedValue.coerceToString((int)-1, (int)10));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test complexToFloat().", method="complexToFloat", args={int.class})
    public void testComplexToFloat() {
        boolean complex1 = true;
        float expected1 = 0.0f;
        int complex2 = 17;
        float expected2 = 0.0f;
        int complex3 = 9999;
        float expected3 = 39.0f;
        TypedValueTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(TypedValue.complexToFloat((int)1)));
        TypedValueTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(TypedValue.complexToFloat((int)17)));
        TypedValueTest.assertEquals((Object)Float.valueOf(39.0f), (Object)Float.valueOf(TypedValue.complexToFloat((int)9999)));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test getDimension().", method="getDimension", args={DisplayMetrics.class})
    public void testGetDimension() {
        DisplayMetrics dm = new DisplayMetrics();
        dm.density = 1.1f;
        dm.heightPixels = 100;
        dm.scaledDensity = 2.1f;
        dm.xdpi = 200.0f;
        dm.ydpi = 300.0f;
        TypedValue tv = new TypedValue();
        tv.data = 10;
        tv.getDimension(dm);
        TypedValueTest.assertEquals((Object)Float.valueOf(TypedValue.complexToDimension((int)10, (DisplayMetrics)dm)), (Object)Float.valueOf(tv.getDimension(dm)));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test complexToDimensionNoisy().", method="complexToDimensionNoisy", args={int.class, DisplayMetrics.class})
    public void testComplexToDimensionNoisy() {
        DisplayMetrics dm = new DisplayMetrics();
        dm.density = 1.1f;
        dm.heightPixels = 100;
        dm.scaledDensity = 2.1f;
        dm.xdpi = 200.0f;
        dm.ydpi = 300.0f;
        TypedValueTest.assertEquals((Object)Float.valueOf(TypedValue.complexToDimension((int)1, (DisplayMetrics)dm)), (Object)Float.valueOf(TypedValue.complexToDimensionNoisy((int)1, (DisplayMetrics)dm)));
    }
}

