/*
 * Decompiled with CFR 0.152.
 */
package android.util.cts;

import android.test.AndroidTestCase;
import android.util.StateSet;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;

@TestTargetClass(value=StateSet.class)
public class StateSetTest
extends AndroidTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Test trim state set.", method="trimStateSet", args={int[].class, int.class})
    public void testTrimStateSet() {
        int[] stateSet = new int[]{1, 2, 3};
        StateSetTest.assertEquals((Object)stateSet, (Object)StateSet.trimStateSet((int[])stateSet, (int)3));
        int[] stateSet2 = StateSet.trimStateSet((int[])stateSet, (int)2);
        StateSetTest.assertEquals((int)2, (int)stateSet2.length);
        for (int i : stateSet2) {
            StateSetTest.assertEquals((int)stateSet2[i - 1], (int)stateSet[i - 1]);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="test dump state set", method="dump", args={int[].class})
    public void testDump() {
        int[] stateSet = new int[]{16842909, 16842919, 0x10100A1, 16842908, 16842910, 1234325};
        String string = StateSet.dump((int[])stateSet);
        StateSetTest.assertEquals((String)"W P S F E ", (String)string);
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="stateSetMatches", args={int[].class, int[].class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="isWildCard", args={int[].class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="stateSetMatches", args={int[].class, int.class})})
    public void testStateSetMatches() throws Exception {
        int[] stateSpec1 = new int[2];
        int[] stateSet1 = new int[3];
        stateSpec1[0] = 1;
        stateSet1[0] = 1;
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec1, (int[])stateSet1));
        stateSet1[0] = 2;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec1, (int[])stateSet1));
        stateSpec1[1] = 2;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec1, (int[])stateSet1));
        stateSet1[1] = 1;
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec1, (int[])stateSet1));
        stateSet1[2] = 12345;
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec1, (int[])stateSet1));
        int[] stateSpec2 = new int[2];
        int[] stateSet2 = new int[2];
        stateSpec2[0] = 1;
        stateSpec2[1] = -2;
        stateSet2[0] = 1;
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec2, (int[])stateSet2));
        stateSet2[0] = 2;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec2, (int[])stateSet2));
        stateSet2[1] = 1;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec2, (int[])stateSet2));
        stateSet2[0] = 12345;
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec2, (int[])stateSet2));
        int[] stateSpec3 = new int[2];
        int[] stateSet3 = new int[3];
        stateSpec3[0] = -1;
        stateSet3[0] = 2;
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec3, (int[])stateSet3));
        stateSet3[1] = 12345;
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec3, (int[])stateSet3));
        stateSet3[0] = 1;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec3, (int[])stateSet3));
        stateSpec3[1] = -2;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec3, (int[])stateSet3));
        stateSet3[2] = 12345;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec3, (int[])stateSet3));
        int[] stateSpec4 = new int[]{-12345, -6789};
        int[] stateSet4 = new int[]{};
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec4, (int[])stateSet4));
        int[] stateSet4b = new int[]{0};
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec4, (int[])stateSet4b));
        int[] stateSpec5 = new int[]{12345};
        int[] stateSet5a = new int[]{};
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec5, (int[])stateSet5a));
        int[] stateSet5b = new int[]{0};
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec5, (int[])stateSet5b));
        int[] stateSpec6 = StateSet.WILD_CARD;
        int[] stateSet6a = new int[]{};
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec6, (int[])stateSet6a));
        int[] stateSet6b = new int[]{0};
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec6, (int[])stateSet6b));
        int[] stateSpec7 = new int[3];
        int[] stateSet7 = null;
        stateSpec7[0] = 1;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec7, stateSet7));
        stateSpec7[1] = -1;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec7, stateSet7));
        stateSpec7 = StateSet.WILD_CARD;
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec7, stateSet7));
        int[] stateSpec8 = new int[2];
        stateSpec8[0] = 1;
        int state1 = 1;
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec8, (int)state1));
        state1 = 2;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec8, (int)state1));
        stateSpec8[1] = -12345;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec8, (int)state1));
        int[] stateSpec9 = new int[2];
        stateSpec9[0] = -1;
        int state2 = 1;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec9, (int)state2));
        state2 = 2;
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec9, (int)state2));
        stateSpec9[1] = -12345;
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec9, (int)state2));
        int[] stateSpec10 = new int[3];
        int state3 = 0;
        stateSpec10[0] = 1;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec10, (int)state3));
        stateSpec10[1] = -1;
        StateSetTest.assertFalse((boolean)StateSet.stateSetMatches((int[])stateSpec10, (int)state3));
        stateSpec10 = StateSet.WILD_CARD;
        StateSetTest.assertTrue((boolean)StateSet.stateSetMatches((int[])stateSpec10, (int)state3));
    }
}

