/*
 * Decompiled with CFR 0.152.
 */
package android.util.cts;

import android.test.AndroidTestCase;
import android.util.SparseIntArray;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;

@TestTargetClass(value=SparseIntArray.class)
public class SparseIntArrayTest
extends AndroidTestCase {
    private static final int[] KEYS = new int[]{12, 23, 4, 6, 8, 1, 3, -12, 0, -3, 11, 14, -23};
    private static final int[] VALUES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    private static final int NON_EXISTED_KEY = 123;
    private static final int VALUE_FOR_NON_EXISTED_KEY = -1;

    protected void setUp() throws Exception {
        super.setUp();
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with default capacity.", method="SparseIntArray", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with default capacity.", method="append", args={int.class, int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with default capacity.", method="clear", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with default capacity.", method="delete", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with default capacity.", method="get", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with default capacity.", method="get", args={int.class, int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with default capacity.", method="indexOfKey", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with default capacity.", method="indexOfValue", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with default capacity.", method="keyAt", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with default capacity.", method="put", args={int.class, int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with default capacity.", method="size", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with default capacity.", method="valueAt", args={int.class})})
    public void testSparseIntArrayWithDefaultCapacity() {
        int i;
        SparseIntArray sparseIntArray = new SparseIntArray();
        SparseIntArrayTest.assertEquals((int)0, (int)sparseIntArray.size());
        int length = VALUES.length;
        for (i = 0; i < length; ++i) {
            sparseIntArray.put(KEYS[i], VALUES[i]);
            SparseIntArrayTest.assertEquals((int)(i + 1), (int)sparseIntArray.size());
        }
        for (i = 0; i < length; ++i) {
            SparseIntArrayTest.assertEquals((int)VALUES[i], (int)sparseIntArray.get(KEYS[i]));
        }
        for (i = 0; i < length; ++i) {
            SparseIntArrayTest.assertEquals((int)sparseIntArray.indexOfValue(VALUES[i]), (int)sparseIntArray.indexOfKey(KEYS[i]));
        }
        int existKey = KEYS[0];
        int oldValue = VALUES[0];
        int newValue = 23;
        SparseIntArrayTest.assertEquals((int)oldValue, (int)sparseIntArray.get(existKey));
        SparseIntArrayTest.assertEquals((int)13, (int)sparseIntArray.size());
        sparseIntArray.put(existKey, newValue);
        SparseIntArrayTest.assertEquals((int)newValue, (int)sparseIntArray.get(existKey));
        SparseIntArrayTest.assertEquals((int)13, (int)sparseIntArray.size());
        SparseIntArrayTest.assertEquals((int)-1, (int)sparseIntArray.get(123, -1));
        SparseIntArrayTest.assertEquals((int)0, (int)sparseIntArray.get(123));
        int size = sparseIntArray.size();
        sparseIntArray.append(123, -1);
        SparseIntArrayTest.assertEquals((int)(size + 1), (int)sparseIntArray.size());
        SparseIntArrayTest.assertEquals((int)size, (int)sparseIntArray.indexOfKey(123));
        SparseIntArrayTest.assertEquals((int)size, (int)sparseIntArray.indexOfValue(-1));
        SparseIntArrayTest.assertEquals((int)123, (int)sparseIntArray.keyAt(size));
        SparseIntArrayTest.assertEquals((int)-1, (int)sparseIntArray.valueAt(size));
        SparseIntArrayTest.assertEquals((int)VALUES[1], (int)sparseIntArray.get(KEYS[1]));
        SparseIntArrayTest.assertFalse((-1 == VALUES[1] ? 1 : 0) != 0);
        sparseIntArray.delete(KEYS[1]);
        SparseIntArrayTest.assertEquals((int)-1, (int)sparseIntArray.get(KEYS[1], -1));
        sparseIntArray.clear();
        SparseIntArrayTest.assertEquals((int)0, (int)sparseIntArray.size());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="SparseIntArray", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="append", args={int.class, int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="clear", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="delete", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="get", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="get", args={int.class, int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="indexOfKey", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="indexOfValue", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="keyAt", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="put", args={int.class, int.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="size", args={}), @TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="valueAt", args={int.class})})
    public void testSparseIntArrayWithSpecifiedCapacity() {
        int i;
        SparseIntArray sparseIntArray = new SparseIntArray(5);
        SparseIntArrayTest.assertEquals((int)0, (int)sparseIntArray.size());
        int length = VALUES.length;
        for (i = 0; i < length; ++i) {
            sparseIntArray.put(KEYS[i], VALUES[i]);
            SparseIntArrayTest.assertEquals((int)(i + 1), (int)sparseIntArray.size());
        }
        for (i = 0; i < length; ++i) {
            SparseIntArrayTest.assertEquals((int)VALUES[i], (int)sparseIntArray.get(KEYS[i]));
        }
        for (i = 0; i < length; ++i) {
            SparseIntArrayTest.assertEquals((int)sparseIntArray.indexOfValue(VALUES[i]), (int)sparseIntArray.indexOfKey(KEYS[i]));
        }
        int existKey = KEYS[0];
        int oldValue = VALUES[0];
        int newValue = 23;
        SparseIntArrayTest.assertEquals((int)oldValue, (int)sparseIntArray.get(existKey));
        SparseIntArrayTest.assertEquals((int)13, (int)sparseIntArray.size());
        sparseIntArray.put(existKey, newValue);
        SparseIntArrayTest.assertEquals((int)newValue, (int)sparseIntArray.get(existKey));
        SparseIntArrayTest.assertEquals((int)13, (int)sparseIntArray.size());
        SparseIntArrayTest.assertEquals((int)-1, (int)sparseIntArray.get(123, -1));
        SparseIntArrayTest.assertEquals((int)0, (int)sparseIntArray.get(123));
        int size = sparseIntArray.size();
        sparseIntArray.append(123, -1);
        SparseIntArrayTest.assertEquals((int)(size + 1), (int)sparseIntArray.size());
        SparseIntArrayTest.assertEquals((int)size, (int)sparseIntArray.indexOfKey(123));
        SparseIntArrayTest.assertEquals((int)size, (int)sparseIntArray.indexOfValue(-1));
        SparseIntArrayTest.assertEquals((int)123, (int)sparseIntArray.keyAt(size));
        SparseIntArrayTest.assertEquals((int)-1, (int)sparseIntArray.valueAt(size));
        SparseIntArrayTest.assertEquals((int)VALUES[1], (int)sparseIntArray.get(KEYS[1]));
        SparseIntArrayTest.assertFalse((-1 == VALUES[1] ? 1 : 0) != 0);
        sparseIntArray.delete(KEYS[1]);
        SparseIntArrayTest.assertEquals((int)-1, (int)sparseIntArray.get(KEYS[1], -1));
        sparseIntArray.clear();
        SparseIntArrayTest.assertEquals((int)0, (int)sparseIntArray.size());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="Test SparseIntArray with specified capacity.", method="removeAt", args={int.class})})
    public void testSparseIntArrayRemoveAt() {
        int[] testData = new int[]{13, 42, 85932, 885932, -6, Integer.MAX_VALUE, 0, Integer.MIN_VALUE};
        for (int i = 0; i < testData.length; ++i) {
            SparseIntArray sia = new SparseIntArray();
            for (int value : testData) {
                sia.put(value, value);
            }
            int size = testData.length;
            SparseIntArrayTest.assertEquals((int)size, (int)sia.size());
            int key = sia.keyAt(i);
            SparseIntArrayTest.assertEquals((int)key, (int)sia.get(key));
            sia.removeAt(i);
            SparseIntArrayTest.assertEquals((int)21, (int)sia.get(key, 21));
            SparseIntArrayTest.assertEquals((int)(size - 1), (int)sia.size());
        }
        SparseIntArray sia = new SparseIntArray();
        for (int value : testData) {
            sia.put(value, value);
        }
        for (int i = 0; i < testData.length; ++i) {
            sia.removeAt(0);
        }
        SparseIntArrayTest.assertEquals((int)0, (int)sia.size());
        for (int value : testData) {
            SparseIntArrayTest.assertEquals((int)21, (int)sia.get(value, 21));
        }
        try {
            new SparseIntArray().removeAt(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

