/*
 * Decompiled with CFR 0.152.
 */
package android.util.cts;

import android.test.AndroidTestCase;
import android.util.SparseBooleanArray;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;

@TestTargetClass(value=SparseBooleanArray.class)
public class SparseBooleanArrayTest
extends AndroidTestCase {
    private static final int[] KEYS = new int[]{12, 23, 4, 6, 8, 1, 3, -12, 0, -3, 11, 14, -23};
    private static final boolean[] VALUES = new boolean[]{true, false, true, false, false, true, true, true, true, false, false, false, false};
    private static final int NON_EXISTED_KEY = 123;
    private static final boolean VALUE_FOR_NON_EXISTED_KEY = true;

    protected void setUp() throws Exception {
        super.setUp();
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, method="SparseBooleanArray", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="append", args={int.class, boolean.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="clear", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="delete", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="get", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="get", args={int.class, boolean.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="indexOfKey", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="indexOfValue", args={boolean.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="keyAt", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="put", args={int.class, boolean.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="size", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="valueAt", args={int.class})})
    public void testSparseBooleanArrayWithDefaultCapacity() {
        int expectPos;
        int i;
        SparseBooleanArray sparseBooleanArray = new SparseBooleanArray();
        SparseBooleanArrayTest.assertEquals((int)0, (int)sparseBooleanArray.size());
        int length = VALUES.length;
        for (i = 0; i < length; ++i) {
            sparseBooleanArray.put(KEYS[i], VALUES[i]);
            SparseBooleanArrayTest.assertEquals((int)(i + 1), (int)sparseBooleanArray.size());
        }
        for (i = 0; i < length; ++i) {
            SparseBooleanArrayTest.assertEquals((boolean)VALUES[i], (boolean)sparseBooleanArray.get(KEYS[i]));
        }
        int truePos = sparseBooleanArray.indexOfValue(true);
        int falsePos = sparseBooleanArray.indexOfValue(false);
        for (int i2 = 0; i2 < length; ++i2) {
            int keyIndex = sparseBooleanArray.indexOfKey(KEYS[i2]);
            SparseBooleanArrayTest.assertEquals((boolean)VALUES[i2], (boolean)sparseBooleanArray.valueAt(keyIndex));
            expectPos = VALUES[i2] ? truePos : falsePos;
            SparseBooleanArrayTest.assertEquals((int)expectPos, (int)sparseBooleanArray.indexOfValue(VALUES[i2]));
        }
        int existKey = KEYS[0];
        boolean oldValue = VALUES[0];
        boolean newValue = false;
        SparseBooleanArrayTest.assertEquals((boolean)oldValue, (boolean)sparseBooleanArray.get(existKey));
        SparseBooleanArrayTest.assertEquals((int)13, (int)sparseBooleanArray.size());
        sparseBooleanArray.put(existKey, newValue);
        SparseBooleanArrayTest.assertEquals((boolean)newValue, (boolean)sparseBooleanArray.get(existKey));
        SparseBooleanArrayTest.assertEquals((int)13, (int)sparseBooleanArray.size());
        SparseBooleanArrayTest.assertEquals((boolean)true, (boolean)sparseBooleanArray.get(123, true));
        SparseBooleanArrayTest.assertEquals((boolean)false, (boolean)sparseBooleanArray.get(123));
        int size = sparseBooleanArray.size();
        sparseBooleanArray.append(123, true);
        SparseBooleanArrayTest.assertEquals((int)(size + 1), (int)sparseBooleanArray.size());
        SparseBooleanArrayTest.assertEquals((int)size, (int)sparseBooleanArray.indexOfKey(123));
        expectPos = truePos;
        SparseBooleanArrayTest.assertEquals((int)expectPos, (int)sparseBooleanArray.indexOfValue(true));
        SparseBooleanArrayTest.assertEquals((int)123, (int)sparseBooleanArray.keyAt(size));
        SparseBooleanArrayTest.assertEquals((boolean)true, (boolean)sparseBooleanArray.valueAt(size));
        SparseBooleanArrayTest.assertEquals((boolean)VALUES[1], (boolean)sparseBooleanArray.get(KEYS[1]));
        SparseBooleanArrayTest.assertFalse((true == VALUES[1] ? 1 : 0) != 0);
        sparseBooleanArray.delete(KEYS[1]);
        SparseBooleanArrayTest.assertEquals((boolean)true, (boolean)sparseBooleanArray.get(KEYS[1], true));
        sparseBooleanArray.clear();
        SparseBooleanArrayTest.assertEquals((int)0, (int)sparseBooleanArray.size());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, method="SparseBooleanArray", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="append", args={int.class, boolean.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="clear", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="delete", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="get", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="get", args={int.class, boolean.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="indexOfKey", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="indexOfValue", args={boolean.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="keyAt", args={int.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="put", args={int.class, boolean.class}), @TestTargetNew(level=TestLevel.COMPLETE, method="size", args={}), @TestTargetNew(level=TestLevel.COMPLETE, method="valueAt", args={int.class})})
    public void testSparseBooleanArrayWithSpecifiedCapacity() {
        int expectPos;
        int i;
        SparseBooleanArray sparseBooleanArray = new SparseBooleanArray(5);
        SparseBooleanArrayTest.assertEquals((int)0, (int)sparseBooleanArray.size());
        int length = VALUES.length;
        for (i = 0; i < length; ++i) {
            sparseBooleanArray.put(KEYS[i], VALUES[i]);
            SparseBooleanArrayTest.assertEquals((int)(i + 1), (int)sparseBooleanArray.size());
        }
        for (i = 0; i < length; ++i) {
            SparseBooleanArrayTest.assertEquals((boolean)VALUES[i], (boolean)sparseBooleanArray.get(KEYS[i]));
        }
        int truePos = sparseBooleanArray.indexOfValue(true);
        int falsePos = sparseBooleanArray.indexOfValue(false);
        for (int i2 = 0; i2 < length; ++i2) {
            int keyIndex = sparseBooleanArray.indexOfKey(KEYS[i2]);
            SparseBooleanArrayTest.assertEquals((boolean)VALUES[i2], (boolean)sparseBooleanArray.valueAt(keyIndex));
            expectPos = VALUES[i2] ? truePos : falsePos;
            SparseBooleanArrayTest.assertEquals((int)expectPos, (int)sparseBooleanArray.indexOfValue(VALUES[i2]));
        }
        int existKey = KEYS[0];
        boolean oldValue = VALUES[0];
        boolean newValue = false;
        SparseBooleanArrayTest.assertEquals((boolean)oldValue, (boolean)sparseBooleanArray.get(existKey));
        SparseBooleanArrayTest.assertEquals((int)13, (int)sparseBooleanArray.size());
        sparseBooleanArray.put(existKey, newValue);
        SparseBooleanArrayTest.assertEquals((boolean)newValue, (boolean)sparseBooleanArray.get(existKey));
        SparseBooleanArrayTest.assertEquals((int)13, (int)sparseBooleanArray.size());
        SparseBooleanArrayTest.assertEquals((boolean)true, (boolean)sparseBooleanArray.get(123, true));
        SparseBooleanArrayTest.assertEquals((boolean)false, (boolean)sparseBooleanArray.get(123));
        int size = sparseBooleanArray.size();
        sparseBooleanArray.append(123, true);
        SparseBooleanArrayTest.assertEquals((int)(size + 1), (int)sparseBooleanArray.size());
        SparseBooleanArrayTest.assertEquals((int)size, (int)sparseBooleanArray.indexOfKey(123));
        expectPos = truePos;
        SparseBooleanArrayTest.assertEquals((int)expectPos, (int)sparseBooleanArray.indexOfValue(true));
        SparseBooleanArrayTest.assertEquals((int)123, (int)sparseBooleanArray.keyAt(size));
        SparseBooleanArrayTest.assertEquals((boolean)true, (boolean)sparseBooleanArray.valueAt(size));
        SparseBooleanArrayTest.assertEquals((boolean)VALUES[1], (boolean)sparseBooleanArray.get(KEYS[1]));
        SparseBooleanArrayTest.assertFalse((true == VALUES[1] ? 1 : 0) != 0);
        sparseBooleanArray.delete(KEYS[1]);
        SparseBooleanArrayTest.assertEquals((boolean)true, (boolean)sparseBooleanArray.get(KEYS[1], true));
        sparseBooleanArray.clear();
        SparseBooleanArrayTest.assertEquals((int)0, (int)sparseBooleanArray.size());
    }
}

